/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.providers;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorsProviderByField {
    private static final Logger log = LoggerFactory.getLogger(GeneratorsProviderByField.class);
    private final Map<String, Generator<?>> overriddenGeneratorsForFields = new HashMap();

    synchronized Generator<?> getGenerator(Field field) {
        return this.overriddenGeneratorsForFields.get(field.getName());
    }

    synchronized boolean isGeneratorOverridden(String fieldName) {
        return this.overriddenGeneratorsForFields.containsKey(fieldName);
    }

    synchronized void setGeneratorForField(String fieldName, Generator<?> generator) {
        if (this.overriddenGeneratorsForFields.containsKey(fieldName)) {
            throw new DtoGeneratorException("Generator has already been added explicitly for the field: '" + fieldName + "'");
        }
        this.overriddenGeneratorsForFields.put(fieldName, generator);
    }
}

