/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.providers;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGenerator;
import org.laoruga.dtogenerator.api.rules.ArrayRule;
import org.laoruga.dtogenerator.api.rules.CollectionRule;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.api.rules.datetime.DateTimeRule;
import org.laoruga.dtogenerator.config.ConfigurationHolder;
import org.laoruga.dtogenerator.config.types.TypeGeneratorsDefaultConfigSupplier;
import org.laoruga.dtogenerator.constants.GeneratedTypes;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.GeneratorConfigurator;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.providers.suppliers.GeneratorSupplierInfo;
import org.laoruga.dtogenerator.generator.providers.suppliers.GeneratorSuppliers;
import org.laoruga.dtogenerator.generator.providers.suppliers.GeneratorSuppliersDefault;
import org.laoruga.dtogenerator.generator.providers.suppliers.UserGeneratorSuppliers;
import org.laoruga.dtogenerator.util.ConcreteClasses;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorsProviderByType {
    private static final Logger log = LoggerFactory.getLogger(GeneratorsProviderByType.class);
    private final ConfigurationHolder configuration;
    private final GeneratorConfigurator generatorConfigurator;
    private final UserGeneratorSuppliers userGeneratorSuppliers;
    private final GeneratorSuppliers defaultGeneratorSuppliers = GeneratorSuppliersDefault.getInstance();

    public GeneratorsProviderByType(ConfigurationHolder configuration, GeneratorConfigurator generatorConfigurator, UserGeneratorSuppliers userGeneratorSuppliers) {
        this.configuration = configuration;
        this.generatorConfigurator = generatorConfigurator;
        this.userGeneratorSuppliers = userGeneratorSuppliers;
    }

    public Optional<Generator<?>> getUserGenerator(Field field, Class<?> generatedType) {
        Generator<?> generator;
        Optional<Generator<?>> maybeUserGenerator = this.userGeneratorSuppliers.getGenerator(generatedType);
        if (maybeUserGenerator.isPresent() && (generator = maybeUserGenerator.get()) instanceof CustomGenerator) {
            this.configuration.getCustomGeneratorsConfigurators().getBuilder(field.getName(), generator.getClass()).build().configure((CustomGenerator)generator);
        }
        return maybeUserGenerator;
    }

    public Optional<Generator<?>> getGenerator(Field field, Class<?> generatedType) {
        Optional<Generator<?>> maybeUserGenerator = this.getUserGenerator(field, generatedType = Primitives.wrap(generatedType));
        if (maybeUserGenerator.isPresent()) {
            return maybeUserGenerator;
        }
        Optional<GeneratorSupplierInfo> maybeDefaultGeneratorSupplier = this.defaultGeneratorSuppliers.getGeneratorSupplierInfo(generatedType);
        if (!maybeDefaultGeneratorSupplier.isPresent()) {
            log.debug("Generator supplier not found for field type: " + generatedType);
            return Optional.empty();
        }
        Optional<ConfigDto> generatorConfig = this.getGeneratorConfig(field, generatedType);
        if (!generatorConfig.isPresent()) {
            if (this.configuration.getDtoGeneratorConfig().getGenerateAllKnownTypes().booleanValue()) {
                return Optional.empty();
            }
            throw new DtoGeneratorException("Unexpected state.");
        }
        return Optional.of(maybeDefaultGeneratorSupplier.get().getGeneratorSupplier().apply(generatorConfig.get()));
    }

    private Optional<ConfigDto> getGeneratorConfig(Field field, Class<?> generatedType) {
        Consumer<ConfigDto> specificConfig;
        if (CollectionRule.GENERATED_TYPE.isAssignableFrom(generatedType)) {
            Optional<Consumer<ConfigDto>> maybeCollectionSpecificConfig = this.getCollectionSpecificConfigWithElementGenerator(field, generatedType);
            if (!maybeCollectionSpecificConfig.isPresent()) {
                return Optional.empty();
            }
            specificConfig = maybeCollectionSpecificConfig.get();
        } else if (MapRule.GENERATED_TYPE.isAssignableFrom(generatedType)) {
            Optional<Consumer<ConfigDto>> maybeMapSpecificConfig = this.getMapSpecificConfigWithKeyValueGenerators(field, generatedType);
            if (!maybeMapSpecificConfig.isPresent()) {
                return Optional.empty();
            }
            specificConfig = maybeMapSpecificConfig.get();
        } else if (DateTimeRule.GENERATED_TYPE.isAssignableFrom(generatedType)) {
            specificConfig = GeneratorConfigurator.getTemporalGeneratorSpecificConfig(generatedType);
        } else if (generatedType.isEnum() || field.getType() == Enum.class) {
            specificConfig = GeneratorConfigurator.getEnumGeneratorSpecificConfig(generatedType);
        } else if (GeneratedTypes.isAssignableFrom(ArrayRule.GENERATED_TYPES, generatedType)) {
            Class<?> elementType = ReflectionUtils.getArrayElementType(generatedType);
            Generator<?> elementGenerator = this.getGenerator(field, elementType).orElseThrow(() -> new DtoGeneratorException("Array element generator not found, for type: '" + elementType + "'"));
            specificConfig = GeneratorConfigurator.getArrayGeneratorSpecificConfig(elementType, elementGenerator);
        } else {
            specificConfig = GeneratorConfigurator.EMPTY_SPECIFIC_CONFIG;
        }
        Optional<Supplier<ConfigDto>> maybeDefaultConfigSupplier = TypeGeneratorsDefaultConfigSupplier.getDefaultConfigSupplier(Primitives.wrap(generatedType));
        return maybeDefaultConfigSupplier.map(configDtoSupplier -> this.generatorConfigurator.mergeGeneratorConfigurations((Supplier<ConfigDto>)configDtoSupplier, specificConfig, generatedType, field.getName()));
    }

    private Optional<Consumer<ConfigDto>> getCollectionSpecificConfigWithElementGenerator(Field field, Class<?> generatedType) {
        Class<?> generatedTypeCollection = generatedType;
        Class<?> concreteCollectionClass = ConcreteClasses.getConcreteCollectionClass(generatedTypeCollection);
        Class<?> elementType = ReflectionUtils.getSingleGenericType(field);
        Optional<Generator<?>> maybeGenerator = this.getGenerator(field, elementType);
        if (!maybeGenerator.isPresent()) {
            if (this.configuration.getDtoGeneratorConfig().getGenerateAllKnownTypes().booleanValue()) {
                return Optional.empty();
            }
            throw new DtoGeneratorException("Collection element generator not found, for type: '" + elementType + "'");
        }
        Generator<?> elementGenerator = maybeGenerator.get();
        return Optional.of(GeneratorConfigurator.getCollectionGeneratorSpecificConfig(concreteCollectionClass, elementGenerator));
    }

    private Optional<Consumer<ConfigDto>> getMapSpecificConfigWithKeyValueGenerators(Field field, Class<?> generatedType) {
        Class<?> generatedTypeMap = generatedType;
        Class<?> concreteMapClass = ConcreteClasses.getConcreteMapClass(generatedTypeMap);
        Class[] keyValueTypes = ReflectionUtils.getPairedGenericType(field);
        Optional<Generator<?>> maybeKeyGenerator = this.getGenerator(field, keyValueTypes[0]);
        Optional<Generator<?>> maybeValueGenerator = this.getGenerator(field, keyValueTypes[1]);
        if (!maybeKeyGenerator.isPresent() || !maybeValueGenerator.isPresent()) {
            if (this.configuration.getDtoGeneratorConfig().getGenerateAllKnownTypes().booleanValue()) {
                return Optional.empty();
            }
            throw new DtoGeneratorException("Map key or value generator not found, for key type: '" + keyValueTypes[1] + "' and value type: '" + keyValueTypes[1] + "'");
        }
        Generator<?> keyGenerator = maybeKeyGenerator.orElseThrow(() -> new DtoGeneratorException("Map key generator not found, for type: '" + keyValueTypes[0] + "'"));
        Generator<?> valueGenerator = this.getGenerator(field, keyValueTypes[1]).orElseThrow(() -> new DtoGeneratorException("Map value generator not found, for type: '" + keyValueTypes[1] + "'"));
        return Optional.of(GeneratorConfigurator.getMapGeneratorSpecificConfig(concreteMapClass, keyGenerator, valueGenerator));
    }

    public void setGenerator(Class<?> generatedType, Generator<?> generator) {
        this.userGeneratorSuppliers.setGenerator(generatedType, () -> generator);
    }
}

