/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.providers.suppliers;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.GeneratedTypes;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;

public class GeneratorSupplierInfo {
    private Class<? extends Annotation> rules;
    private Class<?> generatedType;
    private Function<ConfigDto, Generator<?>> generatorSupplier;

    static GeneratorSupplierInfo createInstance(Class<? extends Annotation> rules, Class<?> generatedType, Function<ConfigDto, Generator<?>> builderSupplier) {
        GeneratorSupplierInfo genBuilderInfo = new GeneratorSupplierInfo();
        genBuilderInfo.rules = rules;
        genBuilderInfo.generatedType = generatedType;
        genBuilderInfo.generatorSupplier = builderSupplier;
        return genBuilderInfo;
    }

    static List<GeneratorSupplierInfo> createInstances(Class<? extends Annotation> rules, Function<ConfigDto, Generator<?>> builderSupplier) {
        return Arrays.stream(GeneratedTypes.get(rules)).map(type -> GeneratorSupplierInfo.createInstance(rules, type, builderSupplier)).collect(Collectors.toList());
    }

    public Class<? extends Annotation> getRules() {
        return this.rules;
    }

    public Class<?> getGeneratedType() {
        return this.generatedType;
    }

    public Function<ConfigDto, Generator<?>> getGeneratorSupplier() {
        return this.generatorSupplier;
    }
}

