/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.providers.suppliers;

import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.laoruga.dtogenerator.api.rules.ArrayRule;
import org.laoruga.dtogenerator.api.rules.CollectionRule;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.api.rules.datetime.DateTimeRule;
import org.laoruga.dtogenerator.constants.GeneratedTypes;
import org.laoruga.dtogenerator.generator.providers.suppliers.GeneratorSupplierInfo;

public final class GeneratorSuppliers {
    private final Map<Class<? extends Annotation>, GeneratorSupplierInfo> rulesClassGeneratorInfoMap = new HashMap<Class<? extends Annotation>, GeneratorSupplierInfo>();
    private final Map<Class<?>, GeneratorSupplierInfo> generatedTypeGeneratorInfoMap = new HashMap();

    public Optional<GeneratorSupplierInfo> getGeneratorSupplierInfo(Class<?> generatedType) {
        GeneratorSupplierInfo foundInfo = this.generatedTypeGeneratorInfoMap.get(generatedType = generatedType.isPrimitive() ? Primitives.wrap(generatedType) : generatedType);
        if (foundInfo == null) {
            if (generatedType.isEnum()) {
                foundInfo = this.generatedTypeGeneratorInfoMap.get(EnumRule.GENERATED_TYPE);
            } else if (CollectionRule.GENERATED_TYPE.isAssignableFrom(generatedType)) {
                foundInfo = this.generatedTypeGeneratorInfoMap.get(CollectionRule.GENERATED_TYPE);
            } else if (GeneratedTypes.isAssignableFrom(ArrayRule.GENERATED_TYPES, generatedType)) {
                foundInfo = this.generatedTypeGeneratorInfoMap.get(GeneratedTypes.getAssignableType(ArrayRule.GENERATED_TYPES, generatedType));
            } else if (DateTimeRule.GENERATED_TYPE.isAssignableFrom(generatedType)) {
                foundInfo = this.generatedTypeGeneratorInfoMap.get(DateTimeRule.GENERATED_TYPE);
            } else if (MapRule.GENERATED_TYPE.isAssignableFrom(generatedType)) {
                foundInfo = this.generatedTypeGeneratorInfoMap.get(MapRule.GENERATED_TYPE);
            }
            if (foundInfo == null) {
                return Optional.empty();
            }
        }
        return Optional.of(foundInfo);
    }

    public Optional<GeneratorSupplierInfo> getGeneratorSupplierInfo(Annotation rulesAnnotation) {
        return Optional.ofNullable(this.rulesClassGeneratorInfoMap.get(rulesAnnotation.annotationType()));
    }

    public void addSuppliersInfo(GeneratorSupplierInfo info) {
        if (info.getGeneratedType() == Object.class) {
            if (this.rulesClassGeneratorInfoMap.containsKey(info.getRules())) {
                throw new IllegalArgumentException("Generator info for next rules already exists: '" + info.getRules() + "'");
            }
            this.rulesClassGeneratorInfoMap.put(info.getRules(), info);
        } else {
            if (this.generatedTypeGeneratorInfoMap.containsKey(info.getGeneratedType())) {
                throw new IllegalArgumentException("Generator info for next type already exists: '" + info.getGeneratedType() + "'");
            }
            this.generatedTypeGeneratorInfoMap.put(info.getGeneratedType(), info);
        }
    }

    void addSuppliersInfo(List<GeneratorSupplierInfo> infoList) {
        for (GeneratorSupplierInfo info : infoList) {
            this.addSuppliersInfo(info);
        }
    }
}

