/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rule;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Objects;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.rule.RuleInfo;
import org.laoruga.dtogenerator.rule.RuleInfoSimple;

public class RuleInfoList
implements RuleInfo {
    private RuleInfoSimple collectionRuleInfo;
    private RuleInfoSimple elementRuleInfo;
    private Field field;
    private Class<?> elementType;
    private String group;

    public RuleInfo getElementRuleInfo() {
        return Objects.requireNonNull(this.elementRuleInfo, "Element rule wasn't set.");
    }

    @Override
    public Annotation getRule() {
        return this.collectionRuleInfo.getRule();
    }

    @Override
    public Class<?> getRequiredType() {
        return this.field.getType();
    }

    @Override
    public boolean isTypesEqual(RuleType type) {
        return this.collectionRuleInfo.isTypesEqual(type);
    }

    public boolean isElementRulesExist() {
        return this.elementRuleInfo != null;
    }

    RuleInfoList(RuleInfoSimple collectionRuleInfo, RuleInfoSimple elementRuleInfo, Field field, Class<?> elementType, String group) {
        this.collectionRuleInfo = collectionRuleInfo;
        this.elementRuleInfo = elementRuleInfo;
        this.field = field;
        this.elementType = elementType;
        this.group = group;
    }

    public static RuleInfoListBuilder builder() {
        return new RuleInfoListBuilder();
    }

    void setCollectionRuleInfo(RuleInfoSimple collectionRuleInfo) {
        this.collectionRuleInfo = collectionRuleInfo;
    }

    void setElementRuleInfo(RuleInfoSimple elementRuleInfo) {
        this.elementRuleInfo = elementRuleInfo;
    }

    void setField(Field field) {
        this.field = field;
    }

    void setElementType(Class<?> elementType) {
        this.elementType = elementType;
    }

    void setGroup(String group) {
        this.group = group;
    }

    public RuleInfoSimple getCollectionRuleInfo() {
        return this.collectionRuleInfo;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public static class RuleInfoListBuilder {
        private RuleInfoSimple collectionRuleInfo;
        private RuleInfoSimple elementRuleInfo;
        private Field field;
        private Class<?> elementType;
        private String group;

        RuleInfoListBuilder() {
        }

        public RuleInfoListBuilder collectionRuleInfo(RuleInfoSimple collectionRuleInfo) {
            this.collectionRuleInfo = collectionRuleInfo;
            return this;
        }

        public RuleInfoListBuilder elementRuleInfo(RuleInfoSimple elementRuleInfo) {
            this.elementRuleInfo = elementRuleInfo;
            return this;
        }

        public RuleInfoListBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public RuleInfoListBuilder elementType(Class<?> elementType) {
            this.elementType = elementType;
            return this;
        }

        public RuleInfoListBuilder group(String group) {
            this.group = group;
            return this;
        }

        public RuleInfoList build() {
            return new RuleInfoList(this.collectionRuleInfo, this.elementRuleInfo, this.field, this.elementType, this.group);
        }

        public String toString() {
            return "RuleInfoList.RuleInfoListBuilder(collectionRuleInfo=" + this.collectionRuleInfo + ", elementRuleInfo=" + this.elementRuleInfo + ", field=" + this.field + ", elementType=" + this.elementType + ", group=" + this.group + ")";
        }
    }
}

