/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rule;

import java.lang.reflect.Field;
import java.util.Objects;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.rule.RuleInfo;
import org.laoruga.dtogenerator.rule.RuleInfoSimple;

public class RuleInfoMap
implements RuleInfo {
    private RuleInfoSimple mapRule;
    private RuleInfoSimple keyRule;
    private RuleInfoSimple valueRule;
    private Field field;
    private String group;

    public RuleInfo getValueRule() {
        return Objects.requireNonNull(this.valueRule, "Value rule wasn't set.");
    }

    public RuleInfo getKeyRule() {
        return Objects.requireNonNull(this.keyRule, "Key rule wasn't set.");
    }

    @Override
    public MapRule getRule() {
        return (MapRule)this.mapRule.getRule();
    }

    @Override
    public Class<?> getRequiredType() {
        return this.field.getType();
    }

    @Override
    public boolean isTypesEqual(RuleType type) {
        return this.mapRule.isTypesEqual(type);
    }

    public boolean isKeyRulesExist() {
        return this.keyRule != null;
    }

    public boolean isValueRulesExist() {
        return this.valueRule != null;
    }

    RuleInfoMap(RuleInfoSimple mapRule, RuleInfoSimple keyRule, RuleInfoSimple valueRule, Field field, String group) {
        this.mapRule = mapRule;
        this.keyRule = keyRule;
        this.valueRule = valueRule;
        this.field = field;
        this.group = group;
    }

    public static RuleInfoMapBuilder builder() {
        return new RuleInfoMapBuilder();
    }

    void setMapRule(RuleInfoSimple mapRule) {
        this.mapRule = mapRule;
    }

    void setKeyRule(RuleInfoSimple keyRule) {
        this.keyRule = keyRule;
    }

    void setValueRule(RuleInfoSimple valueRule) {
        this.valueRule = valueRule;
    }

    void setField(Field field) {
        this.field = field;
    }

    void setGroup(String group) {
        this.group = group;
    }

    public RuleInfoSimple getMapRule() {
        return this.mapRule;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public static class RuleInfoMapBuilder {
        private RuleInfoSimple mapRule;
        private RuleInfoSimple keyRule;
        private RuleInfoSimple valueRule;
        private Field field;
        private String group;

        RuleInfoMapBuilder() {
        }

        public RuleInfoMapBuilder mapRule(RuleInfoSimple mapRule) {
            this.mapRule = mapRule;
            return this;
        }

        public RuleInfoMapBuilder keyRule(RuleInfoSimple keyRule) {
            this.keyRule = keyRule;
            return this;
        }

        public RuleInfoMapBuilder valueRule(RuleInfoSimple valueRule) {
            this.valueRule = valueRule;
            return this;
        }

        public RuleInfoMapBuilder field(Field field) {
            this.field = field;
            return this;
        }

        public RuleInfoMapBuilder group(String group) {
            this.group = group;
            return this;
        }

        public RuleInfoMap build() {
            return new RuleInfoMap(this.mapRule, this.keyRule, this.valueRule, this.field, this.group);
        }

        public String toString() {
            return "RuleInfoMap.RuleInfoMapBuilder(mapRule=" + this.mapRule + ", keyRule=" + this.keyRule + ", valueRule=" + this.valueRule + ", field=" + this.field + ", group=" + this.group + ")";
        }
    }
}

