/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rule;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.math3.util.Pair;
import org.laoruga.dtogenerator.FieldFilter;
import org.laoruga.dtogenerator.api.rules.ArrayRule;
import org.laoruga.dtogenerator.api.rules.CollectionRule;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorValidationException;
import org.laoruga.dtogenerator.rule.RuleInfo;
import org.laoruga.dtogenerator.rule.RuleInfoList;
import org.laoruga.dtogenerator.rule.RuleInfoMap;
import org.laoruga.dtogenerator.rule.RuleInfoSimple;
import org.laoruga.dtogenerator.rule.RulesInfoHelper;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesInfoExtractor {
    private static final Logger log = LoggerFactory.getLogger(RulesInfoExtractor.class);
    private final FieldFilter fieldsGroupFilter;
    private Field field;

    public synchronized Optional<RuleInfo> extractRulesInfo(Field fieldToInspect) throws DtoGeneratorValidationException {
        this.field = fieldToInspect;
        Annotation annotation = RulesInfoHelper.getSingleRulesOrNull(this.field.getAnnotations());
        if (annotation == null) {
            log.debug("No rule annotations found on the field: '" + this.field);
            return Optional.empty();
        }
        RuleInfo ruleInfo = null;
        switch (RulesInfoHelper.getHelperType(annotation)) {
            case RULE: 
            case NESTED_DTO_RULE: 
            case CUSTOM_RULE: {
                String groupName = RulesInfoHelper.getGroupNameFromRuleAnnotation(annotation);
                if (this.skipByGroup(groupName)) break;
                ruleInfo = this.buildRuleInfo(annotation, this.field.getType(), groupName, false);
                break;
            }
            case RULE_FOR_COLLECTION: {
                String groupName = RulesInfoHelper.getGroupNameFromRuleAnnotation(annotation);
                if (this.skipByGroup(groupName)) break;
                ruleInfo = this.buildCollectionRuleInfo((CollectionRule)annotation, groupName, false);
                break;
            }
            case RULE_FOR_ARRAY: {
                String groupName = RulesInfoHelper.getGroupNameFromRuleAnnotation(annotation);
                if (this.skipByGroup(groupName)) break;
                ruleInfo = this.buildArrayRuleInfo((ArrayRule)annotation, groupName, false);
                break;
            }
            case RULE_FOR_MAP: {
                String groupName = RulesInfoHelper.getGroupNameFromRuleAnnotation(annotation);
                ruleInfo = this.buildMapRuleInfo((MapRule)annotation, groupName, false);
                break;
            }
            case RULES: {
                Optional<Pair<String, Annotation>> maybeGroupAndRules = this.selectRuleByGroup(annotation);
                if (!maybeGroupAndRules.isPresent()) break;
                Pair<String, Annotation> groupAndRule = maybeGroupAndRules.get();
                ruleInfo = this.buildRuleInfo((Annotation)groupAndRule.getSecond(), this.field.getType(), (String)groupAndRule.getFirst(), true);
                break;
            }
            case RULES_FOR_COLLECTION: {
                Optional<Pair<String, Annotation>> maybeGroupAndRules = this.selectRuleByGroup(annotation);
                if (!maybeGroupAndRules.isPresent()) break;
                Pair<String, Annotation> groupAndRule = maybeGroupAndRules.get();
                ruleInfo = this.buildCollectionRuleInfo((CollectionRule)groupAndRule.getSecond(), (String)groupAndRule.getFirst(), true);
                break;
            }
            case RULES_FOR_ARRAY: {
                Optional<Pair<String, Annotation>> maybeGroupAndRules = this.selectRuleByGroup(annotation);
                if (!maybeGroupAndRules.isPresent()) break;
                Pair<String, Annotation> groupAndRule = maybeGroupAndRules.get();
                ruleInfo = this.buildArrayRuleInfo((ArrayRule)groupAndRule.getSecond(), (String)groupAndRule.getFirst(), true);
                break;
            }
            case RULES_FOR_MAP: {
                Optional<Pair<String, Annotation>> maybeGroupAndRules = this.selectRuleByGroup(annotation);
                if (!maybeGroupAndRules.isPresent()) break;
                Pair<String, Annotation> groupAndRule = maybeGroupAndRules.get();
                ruleInfo = this.buildMapRuleInfo((MapRule)groupAndRule.getSecond(), (String)groupAndRule.getFirst(), true);
                break;
            }
            case UNKNOWN: {
                log.debug("Unknown annotation: '" + annotation.annotationType().getName() + "' of field: '" + this.field.getType() + " " + this.field.getName() + "'");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected helper rule type: " + (Object)((Object)RulesInfoHelper.getHelperType(annotation)));
            }
        }
        return Optional.ofNullable(ruleInfo);
    }

    private RuleInfoSimple buildRuleInfo(Annotation rule, Class<?> requiredType, String groupName, boolean isMultipleRules) {
        RulesInfoHelper.validateType(requiredType, rule);
        return RuleInfoSimple.builder().field(this.field).requiredType(requiredType).rule(rule).ruleType(RuleType.getType(rule)).multipleRules(isMultipleRules).group(groupName).build();
    }

    private RuleInfoList buildCollectionRuleInfo(CollectionRule collectionRule, String groupName, boolean isMultipleRules) {
        Class<?> elementType = ReflectionUtils.getSingleGenericType(this.field);
        Annotation elementRule = ReflectionUtils.getSingleRuleFromEntryOrDefaultForType(collectionRule.element(), elementType);
        RulesInfoHelper.validateType(elementType, elementRule);
        RulesInfoHelper.validateType(this.field.getType(), collectionRule);
        RuleInfoSimple collectionElementInfo = this.buildRuleInfo(elementRule, elementType, groupName, false);
        RuleInfoSimple collectionInfo = RuleInfoSimple.builder().rule(collectionRule).ruleType(RuleType.getType(collectionRule)).multipleRules(isMultipleRules).group(groupName).build();
        return RuleInfoList.builder().collectionRuleInfo(collectionInfo).elementRuleInfo(collectionElementInfo).field(this.field).elementType(elementType).group(groupName).build();
    }

    private RuleInfo buildArrayRuleInfo(ArrayRule arrayRule, String groupName, boolean isMultipleRules) {
        Class<?> elementType = ReflectionUtils.getArrayElementType(this.field.getType());
        Annotation elementRule = ReflectionUtils.getSingleRuleFromEntryOrDefaultForType(arrayRule.element(), elementType);
        RulesInfoHelper.validateType(elementType, elementRule);
        RulesInfoHelper.validateType(this.field.getType(), arrayRule);
        RuleInfoSimple arrayElementInfo = this.buildRuleInfo(elementRule, elementType, groupName, false);
        RuleInfoSimple arrayInfo = RuleInfoSimple.builder().rule(arrayRule).ruleType(RuleType.getType(arrayRule)).multipleRules(isMultipleRules).group(groupName).build();
        return RuleInfoList.builder().collectionRuleInfo(arrayInfo).elementRuleInfo(arrayElementInfo).field(this.field).elementType(elementType).group(groupName).build();
    }

    private RuleInfoMap buildMapRuleInfo(MapRule mapRule, String groupName, boolean isMultipleRules) {
        Class<?>[] keyValueTypes = ReflectionUtils.getPairedGenericType(this.field);
        Annotation keyRule = ReflectionUtils.getSingleRuleFromEntryOrDefaultForType(mapRule.key(), keyValueTypes[0]);
        Annotation valueRule = ReflectionUtils.getSingleRuleFromEntryOrDefaultForType(mapRule.value(), keyValueTypes[1]);
        RulesInfoHelper.validateType(this.field.getType(), mapRule);
        RulesInfoHelper.validateType(keyValueTypes[0], keyRule);
        RulesInfoHelper.validateType(keyValueTypes[1], valueRule);
        RuleInfoSimple mapKeyRuleInfo = this.buildRuleInfo(keyRule, keyValueTypes[0], groupName, false);
        RuleInfoSimple mapValueRuleInfo = this.buildRuleInfo(valueRule, keyValueTypes[1], groupName, false);
        RuleInfoSimple mapRuleInfo = RuleInfoSimple.builder().rule(mapRule).ruleType(RuleType.getType(mapRule)).multipleRules(isMultipleRules).group(groupName).build();
        return RuleInfoMap.builder().field(this.field).mapRule(mapRuleInfo).keyRule(mapKeyRuleInfo).valueRule(mapValueRuleInfo).group(groupName).build();
    }

    private boolean skipByGroup(String groupName) {
        return !this.fieldsGroupFilter.isContainsIncludeGroup(groupName);
    }

    private Optional<Pair<String, Annotation>> selectRuleByGroup(Annotation rules) {
        try {
            HashSet<Annotation> uniqueGroups = new HashSet<Annotation>();
            Object ruleAnnotationsArray = rules.getClass().getMethod("value", new Class[0]).invoke((Object)rules, new Object[0]);
            Optional<Pair<String, Annotation>> matched = Optional.empty();
            for (int i = 0; i < Array.getLength(ruleAnnotationsArray); ++i) {
                Annotation rule = (Annotation)Array.get(ruleAnnotationsArray, i);
                String checkedGroup = RulesInfoHelper.getGroupNameFromRuleAnnotation(rule);
                if (uniqueGroups.contains(rule)) {
                    throw new DtoGeneratorException("Rule group '" + checkedGroup + "' is repeating for field.");
                }
                uniqueGroups.add(rule);
                if (!this.getFieldsGroupFilter().isContainsIncludeGroup(checkedGroup)) continue;
                if (!matched.isPresent()) {
                    matched = Optional.of(Pair.create((Object)checkedGroup, (Object)rule));
                    continue;
                }
                throw new DtoGeneratorException("Ambiguous grouping of the field. Check generators groups and include filters.");
            }
            return matched;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DtoGeneratorException("Unexpected exception. Can't get 'group' from rules annotation", e);
        }
    }

    public FieldFilter getFieldsGroupFilter() {
        return this.fieldsGroupFilter;
    }

    public Field getField() {
        return this.field;
    }

    public RulesInfoExtractor(FieldFilter fieldsGroupFilter) {
        this.fieldsGroupFilter = fieldsGroupFilter;
    }
}

