/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rule;

import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.laoruga.dtogenerator.api.rules.CustomRule;
import org.laoruga.dtogenerator.api.rules.NestedDtoRule;
import org.laoruga.dtogenerator.api.rules.meta.Rule;
import org.laoruga.dtogenerator.api.rules.meta.Rules;
import org.laoruga.dtogenerator.constants.GeneratedTypes;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorValidationException;

public final class RulesInfoHelper {
    public static RuleTypeHelper getHelperType(Annotation ruleAnnotation) {
        if (ruleAnnotation.annotationType() == CustomRule.class) {
            return RuleTypeHelper.CUSTOM_RULE;
        }
        if (ruleAnnotation.annotationType() == NestedDtoRule.class) {
            return RuleTypeHelper.NESTED_DTO_RULE;
        }
        Rule rule = ruleAnnotation.annotationType().getDeclaredAnnotation(Rule.class);
        if (rule != null) {
            RuleType type = rule.value();
            if (type == RuleType.COLLECTION) {
                return RuleTypeHelper.RULE_FOR_COLLECTION;
            }
            if (type == RuleType.ARRAY) {
                return RuleTypeHelper.RULE_FOR_ARRAY;
            }
            if (type == RuleType.MAP) {
                return RuleTypeHelper.RULE_FOR_MAP;
            }
            return RuleTypeHelper.RULE;
        }
        Rules rules = ruleAnnotation.annotationType().getDeclaredAnnotation(Rules.class);
        if (rules != null) {
            RuleType type = rules.value();
            if (type == RuleType.COLLECTION) {
                return RuleTypeHelper.RULES_FOR_COLLECTION;
            }
            if (type == RuleType.ARRAY) {
                return RuleTypeHelper.RULES_FOR_ARRAY;
            }
            if (type == RuleType.MAP) {
                return RuleTypeHelper.RULES_FOR_MAP;
            }
            return RuleTypeHelper.RULES;
        }
        return RuleTypeHelper.UNKNOWN;
    }

    public static void validateType(Class<?> generatedType, Annotation rulesAnnotation) {
        generatedType = Primitives.wrap(generatedType);
        Class<?>[] possibleGeneratedTypes = GeneratedTypes.get(rulesAnnotation.annotationType());
        boolean match = false;
        for (Class<?> knownElementType : possibleGeneratedTypes) {
            if (!knownElementType.isAssignableFrom(generatedType)) continue;
            match = true;
            break;
        }
        if (!match) {
            throw new DtoGeneratorException("Field type or generic type: '" + generatedType + "' does not match to rules annotation: '@" + rulesAnnotation.annotationType().getSimpleName() + "' Expected types of the field:\n" + Arrays.asList(possibleGeneratedTypes));
        }
    }

    public static Annotation getSingleRulesOrNull(Annotation[] annotations) {
        Annotation selected = null;
        for (Annotation annotation : annotations) {
            RuleTypeHelper helperType = RulesInfoHelper.getHelperType(annotation);
            if (helperType == RuleTypeHelper.UNKNOWN) continue;
            if (selected != null) {
                throw new DtoGeneratorValidationException("Found @Rule annotations at least for 2 different types: '" + selected.annotationType().getSimpleName() + "''" + annotation.annotationType().getSimpleName() + "'");
            }
            selected = annotation;
        }
        return selected;
    }

    static String getGroupNameFromRuleAnnotation(Annotation rule) {
        try {
            return (String)rule.annotationType().getMethod("group", new Class[0]).invoke((Object)rule, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DtoGeneratorException("Unexpected exception. Can't get 'group' from rules annotation", e);
        }
    }

    private RulesInfoHelper() {
    }

    public static enum RuleTypeHelper {
        RULE,
        RULE_FOR_COLLECTION,
        RULE_FOR_MAP,
        RULE_FOR_ARRAY,
        RULES,
        RULES_FOR_COLLECTION,
        RULES_FOR_MAP,
        RULES_FOR_ARRAY,
        CUSTOM_RULE,
        NESTED_DTO_RULE,
        UNKNOWN;

    }
}

