/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public final class ConcreteClasses {
    public static Class<?> getConcreteCollectionClass(Class<? extends Collection<?>> fieldType) {
        if (!Modifier.isInterface(fieldType.getModifiers()) && !Modifier.isAbstract(fieldType.getModifiers())) {
            return fieldType;
        }
        if (List.class.isAssignableFrom(fieldType)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(fieldType)) {
            return HashSet.class;
        }
        if (Queue.class.isAssignableFrom(fieldType)) {
            return PriorityQueue.class;
        }
        if (Collection.class.isAssignableFrom(fieldType)) {
            return ArrayList.class;
        }
        throw new DtoGeneratorException("Unsupported collection type: '" + fieldType.getTypeName() + "'");
    }

    public static Class<?> getConcreteMapClass(Class<? extends Map<?, ?>> fieldType) {
        if (!Modifier.isInterface(fieldType.getModifiers()) && !Modifier.isAbstract(fieldType.getModifiers())) {
            return fieldType;
        }
        if (SortedMap.class.isAssignableFrom(fieldType)) {
            return TreeMap.class;
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return HashMap.class;
        }
        throw new DtoGeneratorException("Unsupported map type: '" + fieldType.getTypeName() + "'");
    }
}

