/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.util.Precision;
import org.apache.commons.text.RandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomUtils {
    private static final Logger log = LoggerFactory.getLogger(RandomUtils.class);
    private static final RandomStringGenerator DEFAULT_STRING_GENERATOR = new RandomStringGenerator.Builder().selectFrom("1234567890qwertzuiopasdfghjklyxcvbnQWERTZUIOPASDFGHJKLYXCVBNM~\"`'.,!?@#\u2116$%^-+=*(){}[]/|\\_:; ".toCharArray()).build();
    public static final Random RANDOM = new Random();
    private static final RandomDataGenerator RANDOM_DATA_GENERATOR = new RandomDataGenerator();

    public static double nextDouble(double minValue, double maxValue, int precision) {
        double generated = minValue + RANDOM.nextDouble() * (maxValue - minValue);
        return Precision.round((double)generated, (int)precision);
    }

    public static float nextFloat(float minValue, float maxValue, int precision) {
        float generated = minValue + RANDOM.nextFloat() * (maxValue - minValue);
        return BigDecimal.valueOf(generated).setScale(precision, RoundingMode.HALF_UP).floatValue();
    }

    public static synchronized int nextInt(int minNumber, int maxNumber) {
        if (minNumber == maxNumber) {
            return minNumber;
        }
        return RANDOM_DATA_GENERATOR.nextInt(minNumber, maxNumber);
    }

    public static Short nextShort(short minNumber, short maxNumber) {
        return (short)RandomUtils.nextInt(minNumber, maxNumber);
    }

    public static byte nextByte(byte minNumber, byte maxNumber) {
        return (byte)RandomUtils.nextInt(minNumber, maxNumber);
    }

    public static Integer nextInt(String minNumber, String maxNumber) {
        return RandomUtils.nextInt(Integer.parseInt(minNumber), Integer.parseInt(maxNumber));
    }

    public static boolean nextBoolean() {
        return RANDOM.nextInt(2) == 1;
    }

    public static <T> T getRandomItem(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        int randomIdx = RandomUtils.nextInt(0, collection.size() - 1);
        T result = iterator.next();
        for (int idx = 0; iterator.hasNext() && randomIdx != idx; ++idx) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T getRandomItem(T ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Empty array passed");
        }
        return items[RandomUtils.nextInt(0, items.length - 1)];
    }

    public static int getRandomItem(int ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Empty int array passed");
        }
        return items[RandomUtils.nextInt(0, items.length - 1)];
    }

    public static synchronized long nextLong(long minNumber, long maxNumber) {
        if (minNumber == maxNumber) {
            return minNumber;
        }
        return RANDOM_DATA_GENERATOR.nextLong(minNumber, maxNumber);
    }

    public static synchronized long nextLong() {
        return RANDOM.nextLong();
    }

    public static Number nextNumber(Number minNumber, Number maxNumber) {
        if (minNumber.equals(maxNumber)) {
            return minNumber;
        }
        if (minNumber.getClass() == Integer.class && maxNumber.getClass() == Integer.class) {
            return RandomUtils.nextInt((Integer)minNumber, (Integer)maxNumber);
        }
        if (minNumber.getClass() == Long.class && maxNumber.getClass() == Long.class) {
            return RandomUtils.nextLong((Long)minNumber, (Long)maxNumber);
        }
        if (minNumber.getClass() == Short.class && maxNumber.getClass() == Short.class) {
            return RandomUtils.nextShort((Short)minNumber, (Short)maxNumber);
        }
        if (minNumber.getClass() == Byte.class && maxNumber.getClass() == Byte.class) {
            return RandomUtils.nextByte((Byte)minNumber, (Byte)maxNumber);
        }
        if (minNumber.getClass() == BigInteger.class && maxNumber.getClass() == BigInteger.class) {
            return RandomUtils.nextBigInteger((BigInteger)minNumber, (BigInteger)maxNumber);
        }
        throw new IllegalArgumentException("Unexpected number instances of classes: '" + minNumber.getClass() + "' and '" + maxNumber.getClass() + "'");
    }

    public static Number nextNumberDecimal(Number minNumber, Number maxNumber, int precision) {
        if (minNumber.equals(maxNumber)) {
            return minNumber;
        }
        if (minNumber.getClass() == Double.class && maxNumber.getClass() == Double.class) {
            return RandomUtils.nextDouble((Double)minNumber, (Double)maxNumber, precision);
        }
        if (minNumber.getClass() == Float.class && maxNumber.getClass() == Float.class) {
            return Float.valueOf(RandomUtils.nextFloat(((Float)minNumber).floatValue(), ((Float)maxNumber).floatValue(), precision));
        }
        if (minNumber.getClass() == BigDecimal.class && maxNumber.getClass() == BigDecimal.class) {
            return RandomUtils.nextBigDecimal((BigDecimal)minNumber, (BigDecimal)maxNumber, precision);
        }
        throw new IllegalArgumentException("Unexpected decimal number instances of classes: '" + minNumber.getClass() + "' and '" + maxNumber.getClass() + "'");
    }

    public static String nextString(char[] chars, int length) {
        return new RandomStringGenerator.Builder().selectFrom(chars).build().generate(length);
    }

    public static String nextString(int length) {
        return DEFAULT_STRING_GENERATOR.generate(length);
    }

    public static BigDecimal nextBigDecimal(BigDecimal minValue, BigDecimal maxValue, int precision) {
        BigDecimal randomBigDecimal = minValue.add(BigDecimal.valueOf(Math.random()).multiply(maxValue.subtract(minValue)));
        return randomBigDecimal.setScale(precision, RoundingMode.HALF_UP);
    }

    public static BigInteger nextBigInteger(BigInteger minValue, BigInteger maxValue) {
        return RandomUtils.nextBigDecimal(new BigDecimal(minValue), new BigDecimal(maxValue), 0).toBigInteger();
    }

    private RandomUtils() {
    }
}

