/*
 * Decompiled with CFR 0.152.
 */
package org.lappsgrid.discriminator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lappsgrid.discriminator.Discriminator;
import org.lappsgrid.discriminator.core.DiscriminatorImpl;

public class DiscriminatorRegistry {
    private static long nextId = 0L;
    private static Map<String, Discriminator> nameIndex = new HashMap<String, Discriminator>();
    private static Map<String, Discriminator> uriIndex = new HashMap<String, Discriminator>();
    private static Map<Long, Discriminator> typeIndex = new HashMap<Long, Discriminator>();
    protected static final long BANK_SIZE = 1024L;

    static {
        try {
            DiscriminatorRegistry.initialize();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Discriminator getByName(String name) {
        return nameIndex.get(name);
    }

    public static Discriminator getByUri(String uri) {
        return uriIndex.get(uri);
    }

    public static Discriminator getByType(long type) {
        return typeIndex.get(type);
    }

    public static long getType(String key) {
        Discriminator d = uriIndex.get(key);
        if (d == null && (d = nameIndex.get(key)) == null) {
            return -1L;
        }
        return d.getId();
    }

    public static String getName(String uri) {
        Discriminator d = uriIndex.get(uri);
        if (d == null) {
            return null;
        }
        return d.getName();
    }

    public static String getName(long type) {
        Discriminator d = typeIndex.get(type);
        if (d == null) {
            return null;
        }
        return d.getName();
    }

    public static String getUri(String name) {
        Discriminator d = nameIndex.get(name);
        if (d == null) {
            return null;
        }
        return d.getUri();
    }

    public static String getUri(long type) {
        Discriminator d = typeIndex.get(type);
        if (d == null) {
            return null;
        }
        return d.getUri();
    }

    private static long register(String name, String uri) {
        return DiscriminatorRegistry.register(name, null, uri);
    }

    private static long register(String name, Discriminator parent, String uri) {
        Discriminator d = nameIndex.get(name = name.toLowerCase());
        if (d == null) {
            d = DiscriminatorRegistry.create(name, parent, uri);
            nameIndex.put(name, d);
            typeIndex.put(d.getId(), d);
            uriIndex.put(uri, d);
        }
        return d.getId();
    }

    private static long register(String name, List<Discriminator> parents, String uri) {
        Discriminator d = nameIndex.get(name);
        if (d == null) {
            d = DiscriminatorRegistry.create(name, parents, uri);
            nameIndex.put(name, d);
            typeIndex.put(d.getId(), d);
            uriIndex.put(uri, d);
        }
        return d.getId();
    }

    public static long[] types() {
        int i = 0;
        long[] array = new long[nameIndex.size()];
        for (Discriminator d : nameIndex.values()) {
            array[i] = d.getId();
            ++i;
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] names() {
        ArrayList<String> list = new ArrayList<String>(nameIndex.keySet());
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public static List<Discriminator> discriminators() {
        ArrayList<Discriminator> result = new ArrayList<Discriminator>(nameIndex.values());
        Comparator<Discriminator> selector = new Comparator<Discriminator>(){

            @Override
            public int compare(Discriminator d1, Discriminator d2) {
                return (int)(d1.getId() - d2.getId());
            }
        };
        Collections.sort(result, selector);
        return result;
    }

    public static long get(String name) {
        Discriminator d = nameIndex.get(name.toLowerCase());
        if (d == null && (d = uriIndex.get(name)) == null) {
            return -1L;
        }
        return d.getId();
    }

    public static String get(long type) {
        Discriminator d = typeIndex.get(type);
        if (d == null) {
            return null;
        }
        return d.getName();
    }

    public static boolean isa(String name, String parentName) {
        Discriminator d = nameIndex.get(name);
        if (d == null && (d = uriIndex.get(name)) == null) {
            return false;
        }
        Discriminator parent = nameIndex.get(parentName);
        if (parent == null && (parent = uriIndex.get(parentName)) == null) {
            return false;
        }
        return d.isa(parent);
    }

    public static boolean isa(long type, long parentType) {
        Discriminator d = DiscriminatorRegistry.getByType(type);
        Discriminator parent = DiscriminatorRegistry.getByType(parentType);
        if (d == null || parent == null) {
            return false;
        }
        return d.isa(parent);
    }

    public static long[] getAncestors(long type) {
        Discriminator d = typeIndex.get(type);
        if (d == null) {
            return new long[0];
        }
        return DiscriminatorRegistry.getAncestors(d);
    }

    public static long[] getAncestors(Discriminator d) {
        if (d == null) {
            return new long[0];
        }
        Set<Discriminator> ancestors = d.getAncestors();
        long[] result = new long[ancestors.size()];
        int index = 0;
        for (Discriminator ancestor : ancestors) {
            result[index] = ancestor.getId();
            ++index;
        }
        return result;
    }

    public static void initialize() throws IOException {
        ClassLoader loader = DiscriminatorRegistry.class.getClassLoader();
        InputStream stream = loader.getResourceAsStream("DataTypes.txt");
        if (stream == null && (stream = loader.getResourceAsStream("/DataTypes.txt")) == null) {
            throw new IOException("Could locate DataTypes.txt on the classpath.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        while (line != null) {
            if ((line = DiscriminatorRegistry.trim(line)).length() == 0) {
                line = reader.readLine();
                continue;
            }
            String[] parts = line.split("\\s+");
            if (parts.length == 1) {
                throw new IOException("Invalid input line: " + line);
            }
            if (parts.length > 1) {
                int start = 0;
                String first = parts[start];
                if (first.endsWith(":")) {
                    ++start;
                    int end = first.length() - 1;
                    String token = first.substring(0, end);
                    long value = -1L;
                    value = token.toLowerCase().startsWith("bank") ? (long)Integer.parseInt(token.substring(4)) * 1024L : (long)Integer.parseInt(token);
                    if (value < nextId) {
                        throw new IOException("Invalid ID value specified in the DataTypes configuration: " + value);
                    }
                    nextId = value;
                }
                ArrayList<Discriminator> parents = new ArrayList<Discriminator>();
                int i = start + 1;
                while (i < parts.length - 1) {
                    Discriminator parent = nameIndex.get(parts[i]);
                    if (parent == null) {
                        throw new IOException("Invalid parent type " + parts[i]);
                    }
                    parents.add(parent);
                    ++i;
                }
                String uri = parts[parts.length - 1];
                if (uri.startsWith(":")) {
                    uri = uri.substring(1);
                } else if (!uri.startsWith("http")) {
                    uri = "http://vocab.lappsgrid.org/" + uri;
                }
                DiscriminatorRegistry.register(parts[start], parents, uri);
            }
            line = reader.readLine();
        }
    }

    private static String trim(String line) {
        if (line.startsWith("#")) {
            return "";
        }
        return line.trim();
    }

    private static Discriminator create(String name, Discriminator parent, String uri) {
        return new DiscriminatorImpl(name, parent, nextId++, uri);
    }

    private static Discriminator create(String name, List<Discriminator> parents, String uri) {
        return new DiscriminatorImpl(name, parents, nextId++, uri);
    }
}

