/*
 * Decompiled with CFR 0.152.
 */
package org.lappsgrid.discriminator.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lappsgrid.discriminator.Discriminator;

public class DiscriminatorImpl
implements Discriminator {
    private static final long serialVersionUID = 2L;
    private long id;
    private String name;
    private String uri;
    private int hashCode;
    private Set<Discriminator> parents;

    protected DiscriminatorImpl(String name, long id, String uri) {
        this.id = id;
        this.name = name;
        this.uri = uri;
        this.hashCode = uri.hashCode();
        this.parents = new HashSet<Discriminator>();
    }

    public DiscriminatorImpl(Discriminator discriminator) {
        this.id = discriminator.getId();
        this.name = discriminator.getName();
        this.uri = discriminator.getUri();
        this.hashCode = this.uri.hashCode();
        this.parents = discriminator.getAncestors();
    }

    public DiscriminatorImpl(String name, Discriminator parent, long id, String uri) {
        this.id = id;
        this.name = name;
        this.uri = uri;
        this.hashCode = uri.hashCode();
        this.parents = new HashSet<Discriminator>();
        if (parent != null) {
            this.parents.add(parent);
        }
    }

    public DiscriminatorImpl(String name, List<Discriminator> parents, long id, String uri) {
        this.id = id;
        this.name = name;
        this.uri = uri;
        this.hashCode = uri.hashCode();
        this.parents = new HashSet<Discriminator>();
        for (Discriminator d : parents) {
            this.parents.add(d);
        }
    }

    public DiscriminatorImpl(String name, Discriminator[] parents, long id, String uri) {
        this.id = id;
        this.name = name;
        this.uri = uri;
        this.hashCode = uri.hashCode();
        this.parents = new HashSet<Discriminator>();
        Discriminator[] discriminatorArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            Discriminator d = discriminatorArray[n2];
            this.parents.add(d);
            ++n2;
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public boolean isa(Discriminator d) {
        if (this.id == d.getId()) {
            return true;
        }
        if (this.parents.size() == 0) {
            return false;
        }
        for (Discriminator parent : this.parents) {
            if (!parent.isa(d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Discriminator> getAncestors() {
        return new HashSet<Discriminator>(this.parents);
    }

    public boolean equals(Object d) {
        if (!(d instanceof Discriminator)) {
            return false;
        }
        return this.id == ((Discriminator)d).getId();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

