/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.ByteBasedBitPackingEncoder;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.junit.Assert;
import org.junit.Test;

public class TestByteBasedBitPackingEncoder {
    @Test
    public void testSlabBoundary() {
        for (int i = 0; i <= 32; ++i) {
            ByteBasedBitPackingEncoder encoder = new ByteBasedBitPackingEncoder(i, Packer.BIG_ENDIAN);
            int totalValues = 1564682;
            for (int j = 0; j < 1564682; ++j) {
                try {
                    encoder.writeInt(j);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(i + ": error writing " + j, e);
                }
            }
            Assert.assertEquals((long)BytesUtils.paddedByteCountFromBits((int)(1564682 * i)), (long)encoder.getBufferSize());
            Assert.assertEquals((long)(i == 0 ? 1L : 9L), (long)encoder.getNumSlabs());
        }
    }
}

