/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.Util;
import org.junit.Test;

public class TestUtil {
    @Test
    public void testReadFileMetadata() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileMetaData md = new FileMetaData(1, Arrays.asList(new SchemaElement("foo")), 10L, Arrays.asList(new RowGroup(Arrays.asList(new ColumnChunk(0L), new ColumnChunk(1L)), 10L, 5L), new RowGroup(Arrays.asList(new ColumnChunk(2L), new ColumnChunk(3L)), 11L, 5L)));
        Util.writeFileMetaData((FileMetaData)md, (OutputStream)baos);
        FileMetaData md2 = Util.readFileMetaData((InputStream)this.in(baos));
        FileMetaData md3 = new FileMetaData();
        Util.readFileMetaData((InputStream)this.in(baos), (Util.FileMetaDataConsumer)new Util.DefaultFileMetaDataConsumer(md3));
        FileMetaData md4 = new FileMetaData();
        Util.readFileMetaData((InputStream)this.in(baos), (Util.FileMetaDataConsumer)new Util.DefaultFileMetaDataConsumer(md4), (boolean)true);
        FileMetaData md5 = Util.readFileMetaData((InputStream)this.in(baos), (boolean)true);
        FileMetaData md6 = Util.readFileMetaData((InputStream)this.in(baos), (boolean)false);
        Assert.assertEquals((Object)md, (Object)md2);
        Assert.assertEquals((Object)md, (Object)md3);
        Assert.assertNull((Object)md4.getRow_groups());
        Assert.assertNull((Object)md5.getRow_groups());
        Assert.assertEquals((Object)md4, (Object)md5);
        md4.setRow_groups(md.getRow_groups());
        md5.setRow_groups(md.getRow_groups());
        Assert.assertEquals((Object)md, (Object)md4);
        Assert.assertEquals((Object)md, (Object)md5);
        Assert.assertEquals((Object)md4, (Object)md5);
        Assert.assertEquals((Object)md, (Object)md6);
    }

    private ByteArrayInputStream in(ByteArrayOutputStream baos) {
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

