/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudStorageConfigurationTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBuilder() {
        CloudStorageConfiguration config = CloudStorageConfiguration.builder().workingDirectory("/omg").permitEmptyPathComponents(true).stripPrefixSlash(false).usePseudoDirectories(false).blockSize(666).build();
        Truth.assertThat((String)config.workingDirectory()).isEqualTo((Object)"/omg");
        Truth.assertThat((Boolean)config.permitEmptyPathComponents()).isTrue();
        Truth.assertThat((Boolean)config.stripPrefixSlash()).isFalse();
        Truth.assertThat((Boolean)config.usePseudoDirectories()).isFalse();
        Truth.assertThat((Integer)config.blockSize()).isEqualTo((Object)666);
    }

    @Test
    public void testFromMap() {
        CloudStorageConfiguration config = CloudStorageConfiguration.fromMap((Map)new ImmutableMap.Builder().put((Object)"workingDirectory", (Object)"/omg").put((Object)"permitEmptyPathComponents", (Object)true).put((Object)"stripPrefixSlash", (Object)false).put((Object)"usePseudoDirectories", (Object)false).put((Object)"blockSize", (Object)666).build());
        Truth.assertThat((String)config.workingDirectory()).isEqualTo((Object)"/omg");
        Truth.assertThat((Boolean)config.permitEmptyPathComponents()).isTrue();
        Truth.assertThat((Boolean)config.stripPrefixSlash()).isFalse();
        Truth.assertThat((Boolean)config.usePseudoDirectories()).isFalse();
        Truth.assertThat((Integer)config.blockSize()).isEqualTo((Object)666);
    }

    @Test
    public void testFromMap_badKey_throwsIae() {
        this.thrown.expect(IllegalArgumentException.class);
        CloudStorageConfiguration.fromMap((Map)ImmutableMap.of((Object)"lol", (Object)"/omg"));
    }
}

