/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributeView;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import com.google.cloud.storage.contrib.nio.CloudStorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStoragePseudoDirectoryAttributes;
import com.google.cloud.storage.contrib.nio.testing.LocalStorageHelper;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudStorageFileAttributeViewTest {
    private static final byte[] HAPPY = "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private Path path;

    @Before
    public void before() {
        CloudStorageFileSystemProvider.setStorageOptions((StorageOptions)LocalStorageHelper.getOptions());
        this.path = Paths.get(URI.create("gs://red/water"));
    }

    @Test
    public void testReadAttributes() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withCacheControl((String)"potato")});
        CloudStorageFileAttributeView lazyAttributes = Files.getFileAttributeView(this.path, CloudStorageFileAttributeView.class, new LinkOption[0]);
        Truth.assertThat((String)((String)lazyAttributes.readAttributes().cacheControl().get())).isEqualTo((Object)"potato");
    }

    @Test
    public void testReadAttributes_notFound_throwsNoSuchFileException() throws IOException {
        CloudStorageFileAttributeView lazyAttributes = Files.getFileAttributeView(this.path, CloudStorageFileAttributeView.class, new LinkOption[0]);
        this.thrown.expect(NoSuchFileException.class);
        lazyAttributes.readAttributes();
    }

    @Test
    public void testReadAttributes_pseudoDirectory() throws IOException {
        Path dir = Paths.get(URI.create("gs://red/rum/"));
        CloudStorageFileAttributeView lazyAttributes = Files.getFileAttributeView(dir, CloudStorageFileAttributeView.class, new LinkOption[0]);
        Truth.assertThat((Object)lazyAttributes.readAttributes()).isInstanceOf(CloudStoragePseudoDirectoryAttributes.class);
    }

    @Test
    public void testName() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withCacheControl((String)"potato")});
        CloudStorageFileAttributeView lazyAttributes = Files.getFileAttributeView(this.path, CloudStorageFileAttributeView.class, new LinkOption[0]);
        Truth.assertThat((String)lazyAttributes.name()).isEqualTo((Object)"gcs");
    }

    @Test
    public void testEquals_equalsTester() {
        new EqualsTester().addEqualityGroup(new Object[]{Files.getFileAttributeView(Paths.get(URI.create("gs://red/rum")), CloudStorageFileAttributeView.class, new LinkOption[0]), Files.getFileAttributeView(Paths.get(URI.create("gs://red/rum")), CloudStorageFileAttributeView.class, new LinkOption[0])}).addEqualityGroup(new Object[]{Files.getFileAttributeView(Paths.get(URI.create("gs://red/lol/dog")), CloudStorageFileAttributeView.class, new LinkOption[0])}).testEquals();
    }

    @Test
    public void testNullness() throws NoSuchMethodException, SecurityException {
        new NullPointerTester().ignore(CloudStorageFileAttributeView.class.getMethod("equals", Object.class)).setDefault(FileTime.class, (Object)FileTime.fromMillis(0L)).testAllPublicInstanceMethods((Object)Files.getFileAttributeView(this.path, CloudStorageFileAttributeView.class, new LinkOption[0]));
    }
}

