/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import com.google.cloud.storage.contrib.nio.CloudStorageObjectAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageOptions;
import com.google.cloud.storage.contrib.nio.testing.LocalStorageHelper;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudStorageFileAttributesTest {
    private static final byte[] HAPPY = "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8);
    private Path path;
    private Path dir;

    @Before
    public void before() {
        CloudStorageFileSystemProvider.setStorageOptions((StorageOptions)LocalStorageHelper.getOptions());
        this.path = Paths.get(URI.create("gs://bucket/randompath"));
        this.dir = Paths.get(URI.create("gs://bucket/randompath/"));
    }

    @Test
    public void testCacheControl() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withCacheControl((String)"potato")});
        Truth.assertThat((String)((String)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).cacheControl().get())).isEqualTo((Object)"potato");
    }

    @Test
    public void testMimeType() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withMimeType((String)"text/potato")});
        Truth.assertThat((String)((String)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).mimeType().get())).isEqualTo((Object)"text/potato");
    }

    @Test
    public void testAcl() throws IOException {
        Acl acl = Acl.of((Acl.Entity)new Acl.User("serf@example.com"), (Acl.Role)Acl.Role.READER);
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withAcl((Acl)acl)});
        Truth.assertThat((Iterable)((Iterable)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).acl().get())).contains((Object)acl);
    }

    @Test
    public void testContentDisposition() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withContentDisposition((String)"crash call")});
        Truth.assertThat((String)((String)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).contentDisposition().get())).isEqualTo((Object)"crash call");
    }

    @Test
    public void testContentEncoding() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withContentEncoding((String)"my content encoding")});
        Truth.assertThat((String)((String)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).contentEncoding().get())).isEqualTo((Object)"my content encoding");
    }

    @Test
    public void testUserMetadata() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withUserMetadata((String)"green", (String)"bean")});
        Truth.assertThat((String)((String)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).userMetadata().get("green"))).isEqualTo((Object)"bean");
    }

    @Test
    public void testIsDirectory() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[0]);
        Truth.assertThat((Boolean)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).isDirectory()).isFalse();
        Truth.assertThat((Boolean)Files.readAttributes(this.dir, CloudStorageFileAttributes.class, new LinkOption[0]).isDirectory()).isTrue();
    }

    @Test
    public void testIsRegularFile() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[0]);
        Truth.assertThat((Boolean)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).isRegularFile()).isTrue();
        Truth.assertThat((Boolean)Files.readAttributes(this.dir, CloudStorageFileAttributes.class, new LinkOption[0]).isRegularFile()).isFalse();
    }

    @Test
    public void testIsOther() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[0]);
        Truth.assertThat((Boolean)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).isOther()).isFalse();
        Truth.assertThat((Boolean)Files.readAttributes(this.dir, CloudStorageFileAttributes.class, new LinkOption[0]).isOther()).isFalse();
    }

    @Test
    public void testIsSymbolicLink() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[0]);
        Truth.assertThat((Boolean)Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]).isSymbolicLink()).isFalse();
        Truth.assertThat((Boolean)Files.readAttributes(this.dir, CloudStorageFileAttributes.class, new LinkOption[0]).isSymbolicLink()).isFalse();
    }

    @Test
    public void testEquals_equalsTester() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withMimeType((String)"text/plain")});
        CloudStorageFileAttributes a1 = Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]);
        CloudStorageFileAttributes a2 = Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]);
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withMimeType((String)"text/potato")});
        CloudStorageFileAttributes b1 = Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]);
        CloudStorageFileAttributes b2 = Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]);
        new EqualsTester().addEqualityGroup(new Object[]{a1, a2}).addEqualityGroup(new Object[]{b1, b2}).testEquals();
    }

    @Test
    public void testFilekey() throws IOException {
        Files.write(this.path, HAPPY, new OpenOption[]{CloudStorageOptions.withMimeType((String)"text/plain")});
        Path path2 = Paths.get(URI.create("gs://bucket/anotherrandompath"));
        Files.write(path2, HAPPY, new OpenOption[]{CloudStorageOptions.withMimeType((String)"text/plain")});
        CloudStorageFileAttributes a1 = Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]);
        CloudStorageFileAttributes a2 = Files.readAttributes(path2, CloudStorageFileAttributes.class, new LinkOption[0]);
        Truth.assertThat((Object)a1.fileKey()).isNotEqualTo(a2.fileKey());
        CloudStorageFileAttributes b1 = Files.readAttributes(this.dir, CloudStorageFileAttributes.class, new LinkOption[0]);
        CloudStorageFileAttributes b2 = Files.readAttributes(Paths.get(URI.create("gs://bucket/jacket/")), CloudStorageFileAttributes.class, new LinkOption[0]);
        Truth.assertThat((Object)a1.fileKey()).isNotEqualTo(b1.fileKey());
        Truth.assertThat((Object)b1.fileKey()).isNotEqualTo(b2.fileKey());
    }

    @Test
    public void testNullness() throws IOException, NoSuchMethodException, SecurityException {
        Files.write(this.path, HAPPY, new OpenOption[0]);
        CloudStorageFileAttributes pathAttributes = Files.readAttributes(this.path, CloudStorageFileAttributes.class, new LinkOption[0]);
        CloudStorageFileAttributes dirAttributes = Files.readAttributes(this.dir, CloudStorageFileAttributes.class, new LinkOption[0]);
        NullPointerTester tester = new NullPointerTester();
        tester.ignore(CloudStorageObjectAttributes.class.getMethod("equals", Object.class));
        tester.testAllPublicInstanceMethods((Object)pathAttributes);
        tester.testAllPublicInstanceMethods((Object)dirAttributes);
    }
}

