/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import java.net.URI;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class CloudStorageLateInitializationTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private StorageOptions mockOptions;

    @Before
    public void before() {
        this.mockOptions = (StorageOptions)Mockito.mock(StorageOptions.class);
        Storage mockStorage = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)this.mockOptions.getService()).thenReturn((Object)mockStorage);
        CloudStorageFileSystemProvider.setStorageOptions((StorageOptions)this.mockOptions);
    }

    @Test
    public void ctorDoesNotCreateStorage() {
        new CloudStorageFileSystemProvider();
        ((StorageOptions)Mockito.verify((Object)this.mockOptions, (VerificationMode)Mockito.never())).getService();
    }

    @Test
    public void getPathCreatesStorageOnce() {
        CloudStorageFileSystemProvider provider = new CloudStorageFileSystemProvider();
        provider.getPath(URI.create("gs://bucket1/wat"));
        provider.getPath(URI.create("gs://bucket2/wat"));
        ((StorageOptions)Mockito.verify((Object)this.mockOptions, (VerificationMode)Mockito.times((int)1))).getService();
    }

    @Test
    public void getFileSystemCreatesStorageOnce() {
        CloudStorageFileSystemProvider provider = new CloudStorageFileSystemProvider();
        provider.getFileSystem(URI.create("gs://bucket1"));
        provider.getFileSystem(URI.create("gs://bucket2"));
        ((StorageOptions)Mockito.verify((Object)this.mockOptions, (VerificationMode)Mockito.times((int)1))).getService();
    }
}

