/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import com.google.cloud.storage.contrib.nio.CloudStorageOptions;
import com.google.cloud.storage.contrib.nio.testing.LocalStorageHelper;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudStorageOptionsTest {
    @Before
    public void before() {
        CloudStorageFileSystemProvider.setStorageOptions((StorageOptions)LocalStorageHelper.getOptions());
    }

    @Test
    public void testWithoutCaching() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withoutCaching()});
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).cacheControl().get())).isEqualTo((Object)"no-cache");
    }

    @Test
    public void testCacheControl() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withCacheControl((String)"potato")});
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).cacheControl().get())).isEqualTo((Object)"potato");
    }

    @Test
    public void testWithAcl() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Acl acl = Acl.of((Acl.Entity)new Acl.User("king@example.com"), (Acl.Role)Acl.Role.OWNER);
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withAcl((Acl)acl)});
        Truth.assertThat((Iterable)((Iterable)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).acl().get())).contains((Object)acl);
    }

    @Test
    public void testWithContentDisposition() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withContentDisposition((String)"bubbly fun")});
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).contentDisposition().get())).isEqualTo((Object)"bubbly fun");
    }

    @Test
    public void testWithContentEncoding() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withContentEncoding((String)"gzip")});
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).contentEncoding().get())).isEqualTo((Object)"gzip");
    }

    @Test
    public void testWithUserMetadata() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withUserMetadata((String)"nolo", (String)"contendere"), CloudStorageOptions.withUserMetadata((String)"eternal", (String)"sadness")});
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).userMetadata().get("nolo"))).isEqualTo((Object)"contendere");
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).userMetadata().get("eternal"))).isEqualTo((Object)"sadness");
    }

    @Test
    public void testWithMimeType_string() throws IOException {
        Path path = Paths.get(URI.create("gs://bucket/path"));
        Files.write(path, "(\u273f\u25d5 \u203f\u25d5 )\u30ce".getBytes(StandardCharsets.UTF_8), new OpenOption[]{CloudStorageOptions.withMimeType((String)"text/plain")});
        Truth.assertThat((String)((String)Files.readAttributes(path, CloudStorageFileAttributes.class, new LinkOption[0]).mimeType().get())).isEqualTo((Object)"text/plain");
    }

    @Test
    public void testNullness() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(CloudStorageOptions.class);
    }
}

