/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.contrib.nio.CloudStorageReadChannel;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class CloudStorageReadChannelTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private CloudStorageReadChannel chan;
    private final Storage gcsStorage = (Storage)Mockito.mock(Storage.class);
    private final BlobId file = BlobId.of((String)"blob", (String)"attack");
    private final Blob metadata = (Blob)Mockito.mock(Blob.class);
    private final ReadChannel gcsChannel = (ReadChannel)Mockito.mock(ReadChannel.class);

    @Before
    public void before() throws IOException {
        Mockito.when((Object)this.metadata.getSize()).thenReturn((Object)42L);
        Mockito.when((Object)this.metadata.getGeneration()).thenReturn((Object)2L);
        Mockito.when((Object)this.gcsStorage.get(this.file, new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.GENERATION, Storage.BlobField.SIZE})})).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.gcsStorage.reader(this.file, new Storage.BlobSourceOption[]{Storage.BlobSourceOption.generationMatch((long)2L)})).thenReturn((Object)this.gcsChannel);
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)true);
        this.chan = CloudStorageReadChannel.create((Storage)this.gcsStorage, (BlobId)this.file, (long)0L, (int)1, (String)"", (Storage.BlobSourceOption[])new Storage.BlobSourceOption[0]);
        ((Storage)Mockito.verify((Object)this.gcsStorage)).get((BlobId)Matchers.eq((Object)this.file), new Storage.BlobGetOption[]{(Storage.BlobGetOption)Matchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.GENERATION, Storage.BlobField.SIZE}))});
        ((Storage)Mockito.verify((Object)this.gcsStorage)).reader((BlobId)Matchers.eq((Object)this.file), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)Matchers.eq((Object)Storage.BlobSourceOption.generationMatch((long)2L))});
    }

    @Test
    public void testRead() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        Mockito.when((Object)this.gcsChannel.read((ByteBuffer)Matchers.eq((Object)buffer))).thenReturn((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)0L);
        Truth.assertThat((Integer)this.chan.read(buffer)).isEqualTo((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)1L);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel)).read((ByteBuffer)Matchers.any(ByteBuffer.class));
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)3))).isOpen();
    }

    @Test
    public void testReadRetry() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        Mockito.when((Object)this.gcsChannel.read((ByteBuffer)Matchers.eq((Object)buffer))).thenThrow(new Throwable[]{new StorageException(new IOException("outer", new IOException("Connection closed prematurely: bytesRead = 33554432, Content-Length = 41943040")))}).thenReturn((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)0L);
        Truth.assertThat((Integer)this.chan.read(buffer)).isEqualTo((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)1L);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)Matchers.any(ByteBuffer.class));
    }

    @Test
    public void testReadRetrySSLHandshake() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        Mockito.when((Object)this.gcsChannel.read((ByteBuffer)Matchers.eq((Object)buffer))).thenThrow(new Throwable[]{new StorageException(new IOException("something", new IOException("thing", new SSLHandshakeException("connection closed due to throttling"))))}).thenReturn((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)0L);
        Truth.assertThat((Integer)this.chan.read(buffer)).isEqualTo((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)1L);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)Matchers.any(ByteBuffer.class));
    }

    @Test
    public void testReadRetryEventuallyGivesUp() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        Mockito.when((Object)this.gcsChannel.read((ByteBuffer)Matchers.eq((Object)buffer))).thenThrow(new Throwable[]{new StorageException(new IOException("Connection closed prematurely: bytesRead = 33554432, Content-Length = 41943040"))}).thenThrow(new Throwable[]{new StorageException(new IOException("Connection closed prematurely: bytesRead = 33554432, Content-Length = 41943040"))}).thenReturn((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)0L);
        this.thrown.expect(StorageException.class);
        this.chan.read(buffer);
    }

    @Test
    public void testRead_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.read(ByteBuffer.allocate(1));
    }

    @Test
    public void testWrite_throwsNonWritableChannelException() throws IOException {
        this.thrown.expect(NonWritableChannelException.class);
        this.chan.write(ByteBuffer.allocate(1));
    }

    @Test
    public void testTruncate_throwsNonWritableChannelException() throws IOException {
        this.thrown.expect(NonWritableChannelException.class);
        this.chan.truncate(0L);
    }

    @Test
    public void testIsOpen() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)true).thenReturn((Object)false);
        Truth.assertThat((Boolean)this.chan.isOpen()).isTrue();
        this.chan.close();
        Truth.assertThat((Boolean)this.chan.isOpen()).isFalse();
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)2))).isOpen();
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel)).close();
    }

    @Test
    public void testSize() throws IOException {
        Truth.assertThat((Long)this.chan.size()).isEqualTo((Object)42L);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel)).isOpen();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.gcsChannel});
    }

    @Test
    public void testSize_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.size();
    }

    @Test
    public void testPosition_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.position();
    }

    @Test
    public void testSetPosition_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.position(0L);
    }

    @Test
    public void testClose_calledMultipleTimes_doesntThrowAnError() throws IOException {
        this.chan.close();
        this.chan.close();
        this.chan.close();
    }

    @Test
    public void testSetPosition() throws IOException {
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)0L);
        Truth.assertThat((Long)this.chan.size()).isEqualTo((Object)42L);
        this.chan.position(1L);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)1L);
        Truth.assertThat((Long)this.chan.size()).isEqualTo((Object)42L);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel)).seek(1L);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)5))).isOpen();
    }

    @Test
    public void testChannelPositionDoesNotGetTruncatedToInt() throws IOException {
        long startPosition = 11918483280L;
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        CloudStorageReadChannel.create((Storage)this.gcsStorage, (BlobId)this.file, (long)startPosition, (int)1, (String)"", (Storage.BlobSourceOption[])new Storage.BlobSourceOption[0]);
        ((ReadChannel)Mockito.verify((Object)this.gcsChannel)).seek(((Long)captor.capture()).longValue());
        Truth.assertThat((Long)((Long)captor.getValue())).isEqualTo((Object)startPosition);
    }
}

