/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import com.google.cloud.storage.contrib.nio.testing.LocalStorageHelper;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudStorageReadTest {
    private static final String ALONE = "To be, or not to be, that is the question\u2014\nWhether 'tis Nobler in the mind to suffer\nThe Slings and Arrows of outrageous Fortune,\nOr to take Arms against a Sea of troubles,\nAnd by opposing, end them? To die, to sleep\u2014\nNo more; and by a sleep, to say we end\nThe Heart-ache, and the thousand Natural shocks\nThat Flesh is heir to? 'Tis a consummation\n";
    private static final int repeat = 10000;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() {
        CloudStorageFileSystemProvider.setStorageOptions((StorageOptions)LocalStorageHelper.getOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputStreamReads() throws IOException, InterruptedException {
        byte[] bytes = ALONE.getBytes(StandardCharsets.UTF_8);
        try (CloudStorageFileSystem fs = CloudStorageFileSystem.forBucket((String)"bucket");){
            Path p = this.fillFile((FileSystem)fs, bytes, 10000);
            try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                byte[] buf = new byte[bytes.length];
                for (int i = 0; i < 10000; ++i) {
                    int delta;
                    Arrays.fill(buf, (byte)0);
                    for (int off = 0; off < bytes.length && (delta = is.read(buf, off, bytes.length - off)) >= 0; off += delta) {
                    }
                    Truth.assertWithMessage((String)("Wrong bytes from input stream at repeat " + i)).that(new String(buf, StandardCharsets.UTF_8)).isEqualTo((Object)ALONE);
                }
                int eof = is.read(buf, 0, 1);
                Truth.assertWithMessage((String)"EOF should return -1").that(Integer.valueOf(eof)).isEqualTo((Object)-1);
            }
            finally {
                Files.delete(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelReads() throws IOException, InterruptedException {
        byte[] bytes = ALONE.getBytes(StandardCharsets.UTF_8);
        try (CloudStorageFileSystem fs = CloudStorageFileSystem.forBucket((String)"bucket");){
            Path p = this.fillFile((FileSystem)fs, bytes, 10000);
            try (SeekableByteChannel chan = Files.newByteChannel(p, StandardOpenOption.READ);){
                ByteBuffer buf = ByteBuffer.allocate(bytes.length);
                for (int i = 0; i < 10000; ++i) {
                    int read;
                    buf.clear();
                    for (int off = 0; off < bytes.length && (read = chan.read(buf)) >= 0; off += read) {
                    }
                    Truth.assertWithMessage((String)("Wrong bytes from channel at repeat " + i)).that(new String(buf.array(), StandardCharsets.UTF_8)).isEqualTo((Object)ALONE);
                }
                buf.clear();
                int eof = chan.read(buf);
                Truth.assertWithMessage((String)"EOF should return -1").that(Integer.valueOf(eof)).isEqualTo((Object)-1);
            }
            finally {
                Files.delete(p);
            }
        }
    }

    private Path fillFile(FileSystem fs, byte[] bytes, int repeat) throws IOException {
        Path p = fs.getPath("/alone", new String[0]);
        try (OutputStream os = Files.newOutputStream(p, new OpenOption[0]);){
            for (int i = 0; i < repeat; ++i) {
                os.write(bytes);
            }
        }
        Truth.assertThat((Boolean)(Files.size(p) == (long)(repeat * bytes.length) ? 1 : 0));
        return p;
    }
}

