/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.contrib.nio.CloudStorageWriteChannel;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class CloudStorageWriteChannelTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final WriteChannel gcsChannel = (WriteChannel)Mockito.mock(WriteChannel.class);
    private final CloudStorageWriteChannel chan = new CloudStorageWriteChannel(this.gcsChannel);

    @Before
    public void before() {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)true);
    }

    @Test
    public void testRead_throwsNonReadableChannelException() throws IOException {
        this.thrown.expect(NonReadableChannelException.class);
        this.chan.read(ByteBuffer.allocate(1));
    }

    @Test
    public void testWrite() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)66);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)0L);
        Truth.assertThat((Long)this.chan.size()).isEqualTo((Object)0L);
        Mockito.when((Object)this.gcsChannel.write((ByteBuffer)Matchers.eq((Object)buffer))).thenReturn((Object)1);
        Truth.assertThat((Integer)this.chan.write(buffer)).isEqualTo((Object)1);
        Truth.assertThat((Long)this.chan.position()).isEqualTo((Object)1L);
        Truth.assertThat((Long)this.chan.size()).isEqualTo((Object)1L);
        ((WriteChannel)Mockito.verify((Object)this.gcsChannel)).write((ByteBuffer)Matchers.any(ByteBuffer.class));
        ((WriteChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)5))).isOpen();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.gcsChannel});
    }

    @Test
    public void testWrite_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.write(ByteBuffer.allocate(1));
    }

    @Test
    public void testIsOpen() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)true).thenReturn((Object)false);
        Truth.assertThat((Boolean)this.chan.isOpen()).isTrue();
        this.chan.close();
        Truth.assertThat((Boolean)this.chan.isOpen()).isFalse();
        ((WriteChannel)Mockito.verify((Object)this.gcsChannel, (VerificationMode)Mockito.times((int)2))).isOpen();
        ((WriteChannel)Mockito.verify((Object)this.gcsChannel)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.gcsChannel});
    }

    @Test
    public void testSize() throws IOException {
        Truth.assertThat((Long)this.chan.size()).isEqualTo((Object)0L);
        ((WriteChannel)Mockito.verify((Object)this.gcsChannel)).isOpen();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.gcsChannel});
    }

    @Test
    public void testSize_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.size();
    }

    @Test
    public void testPosition_whenClosed_throwsCce() throws IOException {
        Mockito.when((Object)this.gcsChannel.isOpen()).thenReturn((Object)false);
        this.thrown.expect(ClosedChannelException.class);
        this.chan.position();
    }

    @Test
    public void testClose_calledMultipleTimes_doesntThrowAnError() throws IOException {
        this.chan.close();
        this.chan.close();
        this.chan.close();
    }
}

