/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.contrib.nio.SeekableByteChannelPrefetcher;
import com.google.common.truth.Truth;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SeekableByteChannelPrefetcherTest {
    private static Path input;

    @BeforeClass
    public static void setUp() throws IOException {
        input = Files.createTempFile("tmp_big_file", ".tmp", new FileAttribute[0]);
        try (BufferedOutputStream writer = new BufferedOutputStream(Files.newOutputStream(input, new OpenOption[0]));){
            int i;
            byte[] buffer = new byte[1024];
            for (i = 0; i < buffer.length; ++i) {
                buffer[i] = (byte)i;
            }
            for (i = 0; i < 1024; ++i) {
                writer.write(buffer);
            }
        }
    }

    @AfterClass
    public static void tearDown() throws IOException {
        Files.delete(input);
    }

    @Test
    public void testRead() throws Exception {
        SeekableByteChannel chan1 = Files.newByteChannel(input, new OpenOption[0]);
        SeekableByteChannel chan2 = SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)Files.newByteChannel(input, new OpenOption[0]));
        this.testReading(chan1, chan2, 0);
        this.testReading(chan1, chan2, 128);
        this.testReading(chan1, chan2, 1024);
        this.testReading(chan1, chan2, 1500);
        this.testReading(chan1, chan2, 2048);
        this.testReading(chan1, chan2, 3000);
        this.testReading(chan1, chan2, 6000);
    }

    @Test
    public void testSeek() throws Exception {
        SeekableByteChannel chan1 = Files.newByteChannel(input, new OpenOption[0]);
        SeekableByteChannel chan2 = SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)Files.newByteChannel(input, new OpenOption[0]));
        this.testSeeking(chan1, chan2, 1024);
        this.testSeeking(chan1, chan2, 1500);
        this.testSeeking(chan1, chan2, 128);
        this.testSeeking(chan1, chan2, 256);
        this.testSeeking(chan1, chan2, 128);
        this.testReading(chan1, chan2, 1500);
        this.testSeeking(chan1, chan2, 2048);
        this.testSeeking(chan1, chan2, 0);
        this.testSeeking(chan1, chan2, 3000);
        this.testSeeking(chan1, chan2, 6000);
        this.testSeeking(chan1, chan2, (int)chan1.size() - 127);
        this.testSeeking(chan1, chan2, (int)chan1.size() - 128);
        this.testSeeking(chan1, chan2, (int)chan1.size() - 129);
    }

    @Test
    public void testPartialBuffers() throws Exception {
        int i;
        SeekableByteChannel chan1 = Files.newByteChannel(input, new OpenOption[0]);
        SeekableByteChannel chan2 = SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)Files.newByteChannel(input, new OpenOption[0]));
        this.testSeeking(chan1, chan2, (int)chan1.size() - 127);
        for (i = 0; i < 2; ++i) {
            this.testSeeking(chan1, chan2, i * 1024);
        }
        this.testSeeking(chan1, chan2, (int)chan1.size() - 127);
        for (i = 0; i < 2; ++i) {
            this.testSeeking(chan1, chan2, i * 1024);
        }
    }

    @Test
    public void testEOF() throws Exception {
        SeekableByteChannel chan1 = Files.newByteChannel(input, new OpenOption[0]);
        SeekableByteChannel chan2 = SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)Files.newByteChannel(input, new OpenOption[0]));
        this.testSeeking(chan1, chan2, (int)chan1.size() - 128);
        this.testSeeking(chan1, chan2, (int)chan1.size() - 64);
        this.testSeeking(chan1, chan2, (int)chan1.size() + 128);
        this.testSeeking(chan1, chan2, (int)chan1.size() + 2048);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleWrapping() throws IOException {
        SeekableByteChannel chan1 = SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)Files.newByteChannel(input, new OpenOption[0]));
        SeekableByteChannelPrefetcher.addPrefetcher((int)1, (SeekableByteChannel)chan1);
    }

    @Test
    public void testCloseWhilePrefetching() throws Exception {
        SeekableByteChannel chan = SeekableByteChannelPrefetcher.addPrefetcher((int)10, (SeekableByteChannel)Files.newByteChannel(input, new OpenOption[0]));
        ByteBuffer one = ByteBuffer.allocate(1);
        this.readFully(chan, one);
        chan.close();
    }

    private void testReading(SeekableByteChannel chan1, SeekableByteChannel chan2, int howMuch) throws IOException {
        ByteBuffer one = ByteBuffer.allocate(howMuch);
        ByteBuffer two = ByteBuffer.allocate(howMuch);
        this.readFully(chan1, one);
        this.readFully(chan2, two);
        Truth.assertThat((Integer)one.position()).isEqualTo((Object)two.position());
        Truth.assertThat((byte[])one.array()).isEqualTo((Object)two.array());
    }

    private void testSeeking(SeekableByteChannel chan1, SeekableByteChannel chan2, int position) throws IOException {
        ByteBuffer one = ByteBuffer.allocate(128);
        ByteBuffer two = ByteBuffer.allocate(128);
        chan1.position(position);
        chan2.position(position);
        this.readFully(chan1, one);
        this.readFully(chan2, two);
        Truth.assertThat((Integer)one.position()).isEqualTo((Object)two.position());
        Truth.assertThat((byte[])one.array()).isEqualTo((Object)two.array());
    }

    private void readFully(ReadableByteChannel chan, ByteBuffer buf) throws IOException {
        for (int countdown = buf.capacity(); chan.read(buf) > 0 && countdown > 0; --countdown) {
        }
    }
}

