/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.contrib.nio.UnixPath;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UnixPathTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNormalize() {
        Truth.assertThat((Object)UnixPathTest.p(".").normalize()).isEqualTo((Object)UnixPathTest.p(""));
        Truth.assertThat((Object)UnixPathTest.p("/").normalize()).isEqualTo((Object)UnixPathTest.p("/"));
        Truth.assertThat((Object)UnixPathTest.p("/.").normalize()).isEqualTo((Object)UnixPathTest.p("/"));
        Truth.assertThat((Object)UnixPathTest.p("/a/b/../c").normalize()).isEqualTo((Object)UnixPathTest.p("/a/c"));
        Truth.assertThat((Object)UnixPathTest.p("/a/b/./c").normalize()).isEqualTo((Object)UnixPathTest.p("/a/b/c"));
        Truth.assertThat((Object)UnixPathTest.p("a/b/../c").normalize()).isEqualTo((Object)UnixPathTest.p("a/c"));
        Truth.assertThat((Object)UnixPathTest.p("a/b/./c").normalize()).isEqualTo((Object)UnixPathTest.p("a/b/c"));
        Truth.assertThat((Object)UnixPathTest.p("/a/b/../../c").normalize()).isEqualTo((Object)UnixPathTest.p("/c"));
        Truth.assertThat((Object)UnixPathTest.p("/a/b/./.././.././c").normalize()).isEqualTo((Object)UnixPathTest.p("/c"));
    }

    @Test
    public void testNormalize_empty_returnsEmpty() {
        Truth.assertThat((Object)UnixPathTest.p("").normalize()).isEqualTo((Object)UnixPathTest.p(""));
    }

    @Test
    public void testNormalize_underflow_isAllowed() {
        Truth.assertThat((Object)UnixPathTest.p("../").normalize()).isEqualTo((Object)UnixPathTest.p(""));
    }

    @Test
    public void testNormalize_extraSlashes_getRemoved() {
        Truth.assertThat((Object)UnixPathTest.p("///").normalize()).isEqualTo((Object)UnixPathTest.p("/"));
        Truth.assertThat((Object)UnixPathTest.p("/hi//there").normalize()).isEqualTo((Object)UnixPathTest.p("/hi/there"));
        Truth.assertThat((Object)UnixPathTest.p("/hi////.///there").normalize()).isEqualTo((Object)UnixPathTest.p("/hi/there"));
    }

    @Test
    public void testNormalize_trailingSlash() {
        Truth.assertThat((Object)UnixPathTest.p("/hi/there/").normalize()).isEqualTo((Object)UnixPathTest.p("/hi/there/"));
        Truth.assertThat((Object)UnixPathTest.p("/hi/there/../").normalize()).isEqualTo((Object)UnixPathTest.p("/hi/"));
        Truth.assertThat((Object)UnixPathTest.p("/hi/there/..").normalize()).isEqualTo((Object)UnixPathTest.p("/hi/"));
        Truth.assertThat((Object)UnixPathTest.p("hi/../").normalize()).isEqualTo((Object)UnixPathTest.p(""));
        Truth.assertThat((Object)UnixPathTest.p("/hi/../").normalize()).isEqualTo((Object)UnixPathTest.p("/"));
        Truth.assertThat((Object)UnixPathTest.p("hi/..").normalize()).isEqualTo((Object)UnixPathTest.p(""));
        Truth.assertThat((Object)UnixPathTest.p("/hi/..").normalize()).isEqualTo((Object)UnixPathTest.p("/"));
    }

    @Test
    public void testNormalize_sameObjectOptimization() {
        UnixPath path = UnixPathTest.p("/hi/there");
        Truth.assertThat((Object)path.normalize()).isSameAs((Object)path);
        path = UnixPathTest.p("/hi/there/");
        Truth.assertThat((Object)path.normalize()).isSameAs((Object)path);
    }

    @Test
    public void testResolve() {
        Truth.assertThat((Object)UnixPathTest.p("/hello").resolve(UnixPathTest.p("cat"))).isEqualTo((Object)UnixPathTest.p("/hello/cat"));
        Truth.assertThat((Object)UnixPathTest.p("/hello/").resolve(UnixPathTest.p("cat"))).isEqualTo((Object)UnixPathTest.p("/hello/cat"));
        Truth.assertThat((Object)UnixPathTest.p("hello/").resolve(UnixPathTest.p("cat"))).isEqualTo((Object)UnixPathTest.p("hello/cat"));
        Truth.assertThat((Object)UnixPathTest.p("hello/").resolve(UnixPathTest.p("cat/"))).isEqualTo((Object)UnixPathTest.p("hello/cat/"));
        Truth.assertThat((Object)UnixPathTest.p("hello/").resolve(UnixPathTest.p(""))).isEqualTo((Object)UnixPathTest.p("hello/"));
        Truth.assertThat((Object)UnixPathTest.p("hello/").resolve(UnixPathTest.p("/hi/there"))).isEqualTo((Object)UnixPathTest.p("/hi/there"));
    }

    @Test
    public void testResolve_sameObjectOptimization() {
        UnixPath path = UnixPathTest.p("/hi/there");
        Truth.assertThat((Object)path.resolve(UnixPathTest.p(""))).isSameAs((Object)path);
        Truth.assertThat((Object)UnixPathTest.p("hello").resolve(path)).isSameAs((Object)path);
    }

    @Test
    public void testGetPath() {
        Truth.assertThat((Object)UnixPath.getPath((boolean)false, (String)"hello")).isEqualTo((Object)UnixPathTest.p("hello"));
        Truth.assertThat((Object)UnixPath.getPath((boolean)false, (String)"hello", (String[])new String[]{"cat"})).isEqualTo((Object)UnixPathTest.p("hello/cat"));
        Truth.assertThat((Object)UnixPath.getPath((boolean)false, (String)"/hello", (String[])new String[]{"cat"})).isEqualTo((Object)UnixPathTest.p("/hello/cat"));
        Truth.assertThat((Object)UnixPath.getPath((boolean)false, (String)"/hello", (String[])new String[]{"cat", "inc."})).isEqualTo((Object)UnixPathTest.p("/hello/cat/inc."));
        Truth.assertThat((Object)UnixPath.getPath((boolean)false, (String)"hello/", (String[])new String[]{"/hi/there"})).isEqualTo((Object)UnixPathTest.p("/hi/there"));
    }

    @Test
    public void testResolveSibling() {
        Truth.assertThat((Object)UnixPathTest.p("/hello/cat").resolveSibling(UnixPathTest.p("dog"))).isEqualTo((Object)UnixPathTest.p("/hello/dog"));
        Truth.assertThat((Object)UnixPathTest.p("/").resolveSibling(UnixPathTest.p("dog"))).isEqualTo((Object)UnixPathTest.p("dog"));
    }

    @Test
    public void testResolveSibling_preservesTrailingSlash() {
        Truth.assertThat((Object)UnixPathTest.p("/hello/cat").resolveSibling(UnixPathTest.p("dog/"))).isEqualTo((Object)UnixPathTest.p("/hello/dog/"));
        Truth.assertThat((Object)UnixPathTest.p("/").resolveSibling(UnixPathTest.p("dog/"))).isEqualTo((Object)UnixPathTest.p("dog/"));
    }

    @Test
    public void testRelativize() {
        Truth.assertThat((Object)UnixPathTest.p("/foo/bar/hop/dog").relativize(UnixPathTest.p("/foo/mop/top"))).isEqualTo((Object)UnixPathTest.p("../../../mop/top"));
        Truth.assertThat((Object)UnixPathTest.p("/foo/bar/dog").relativize(UnixPathTest.p("/foo/mop/top"))).isEqualTo((Object)UnixPathTest.p("../../mop/top"));
        Truth.assertThat((Object)UnixPathTest.p("/foo/bar/hop/dog").relativize(UnixPathTest.p("/foo/mop/top/../../mog"))).isEqualTo((Object)UnixPathTest.p("../../../mop/top/../../mog"));
        Truth.assertThat((Object)UnixPathTest.p("/foo/bar/hop/dog").relativize(UnixPathTest.p("/foo/../mog"))).isEqualTo((Object)UnixPathTest.p("../../../../mog"));
        Truth.assertThat((Object)UnixPathTest.p("").relativize(UnixPathTest.p("foo/mop/top/"))).isEqualTo((Object)UnixPathTest.p("foo/mop/top/"));
    }

    @Test
    public void testRelativize_absoluteMismatch_notAllowed() {
        this.thrown.expect(IllegalArgumentException.class);
        UnixPathTest.p("/a/b/").relativize(UnixPathTest.p(""));
    }

    @Test
    public void testRelativize_preservesTrailingSlash() {
        Truth.assertThat((Object)UnixPathTest.p("/foo/bar/hop/dog").relativize(UnixPathTest.p("/foo/../mog/"))).isEqualTo((Object)UnixPathTest.p("../../../../mog/"));
        Truth.assertThat((Object)UnixPathTest.p("/a/b/").relativize(UnixPathTest.p("/etc/"))).isEqualTo((Object)UnixPathTest.p("../../etc/"));
    }

    @Test
    public void testStartsWith() {
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p("/hi/there"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p("/hi/therf"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p("/hi"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p("/hi/"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p("hi"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p("/"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p(""))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/a/b").startsWith(UnixPathTest.p("a/b/"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/a/b/").startsWith(UnixPathTest.p("a/b/"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").startsWith(UnixPathTest.p(""))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("").startsWith(UnixPathTest.p(""))).isTrue();
    }

    @Test
    public void testStartsWith_comparesComponentsIndividually() {
        Truth.assertThat((Boolean)UnixPathTest.p("/hello").startsWith(UnixPathTest.p("/hell"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hello").startsWith(UnixPathTest.p("/hello"))).isTrue();
    }

    @Test
    public void testEndsWith() {
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").endsWith(UnixPathTest.p("there"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").endsWith(UnixPathTest.p("therf"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").endsWith(UnixPathTest.p("/blag/therf"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").endsWith(UnixPathTest.p("/hi/there"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").endsWith(UnixPathTest.p("/there"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/human/that/you/cry").endsWith(UnixPathTest.p("that/you/cry"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/human/that/you/cry").endsWith(UnixPathTest.p("that/you/cry/"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there/").endsWith(UnixPathTest.p("/"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hi/there").endsWith(UnixPathTest.p(""))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("").endsWith(UnixPathTest.p(""))).isTrue();
    }

    @Test
    public void testEndsWith_comparesComponentsIndividually() {
        Truth.assertThat((Boolean)UnixPathTest.p("/hello").endsWith(UnixPathTest.p("lo"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/hello").endsWith(UnixPathTest.p("hello"))).isTrue();
    }

    @Test
    public void testGetParent() {
        Truth.assertThat((Object)UnixPathTest.p("").getParent()).isNull();
        Truth.assertThat((Object)UnixPathTest.p("/").getParent()).isNull();
        Truth.assertThat((Object)UnixPathTest.p("aaa/").getParent()).isNull();
        Truth.assertThat((Object)UnixPathTest.p("aaa").getParent()).isNull();
        Truth.assertThat((Object)UnixPathTest.p("/aaa/").getParent()).isEqualTo((Object)UnixPathTest.p("/"));
        Truth.assertThat((Object)UnixPathTest.p("a/b/c").getParent()).isEqualTo((Object)UnixPathTest.p("a/b/"));
        Truth.assertThat((Object)UnixPathTest.p("a/b/c/").getParent()).isEqualTo((Object)UnixPathTest.p("a/b/"));
        Truth.assertThat((Object)UnixPathTest.p("a/b/").getParent()).isEqualTo((Object)UnixPathTest.p("a/"));
    }

    @Test
    public void testGetRoot() {
        Truth.assertThat((Object)UnixPathTest.p("/hello").getRoot()).isEqualTo((Object)UnixPathTest.p("/"));
        Truth.assertThat((Object)UnixPathTest.p("hello").getRoot()).isNull();
    }

    @Test
    public void testGetFileName() {
        Truth.assertThat((Object)UnixPathTest.p("").getFileName()).isEqualTo((Object)UnixPathTest.p(""));
        Truth.assertThat((Object)UnixPathTest.p("/").getFileName()).isNull();
        Truth.assertThat((Object)UnixPathTest.p("/dark").getFileName()).isEqualTo((Object)UnixPathTest.p("dark"));
        Truth.assertThat((Object)UnixPathTest.p("/angels/").getFileName()).isEqualTo((Object)UnixPathTest.p("angels"));
    }

    @Test
    public void testEquals() {
        Truth.assertThat((Boolean)UnixPathTest.p("/a/").equals((Object)UnixPathTest.p("/a/"))).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/a/").equals((Object)UnixPathTest.p("/b/"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/b/").equals((Object)UnixPathTest.p("/b"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("/b").equals((Object)UnixPathTest.p("/b/"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("b").equals((Object)UnixPathTest.p("/b"))).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("b").equals((Object)UnixPathTest.p("b"))).isTrue();
    }

    @Test
    public void testSplit() {
        Truth.assertThat((Boolean)UnixPathTest.p("").split().hasNext()).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("hi/there").split().hasNext()).isTrue();
        Truth.assertThat((Object)UnixPathTest.p((String)UnixPathTest.p("hi/there").split().next())).isEqualTo((Object)UnixPathTest.p("hi"));
    }

    @Test
    public void testToAbsolute() {
        Truth.assertThat((Object)UnixPathTest.p("lol").toAbsolutePath(UnixPath.ROOT_PATH)).isEqualTo((Object)UnixPathTest.p("/lol"));
        Truth.assertThat((Object)UnixPathTest.p("lol/cat").toAbsolutePath(UnixPath.ROOT_PATH)).isEqualTo((Object)UnixPathTest.p("/lol/cat"));
    }

    @Test
    public void testToAbsolute_withCurrentDirectory() {
        Truth.assertThat((Object)UnixPathTest.p("cat").toAbsolutePath(UnixPathTest.p("/lol"))).isEqualTo((Object)UnixPathTest.p("/lol/cat"));
        Truth.assertThat((Object)UnixPathTest.p("cat").toAbsolutePath(UnixPathTest.p("/lol/"))).isEqualTo((Object)UnixPathTest.p("/lol/cat"));
        Truth.assertThat((Object)UnixPathTest.p("/hi/there").toAbsolutePath(UnixPathTest.p("/lol"))).isEqualTo((Object)UnixPathTest.p("/hi/there"));
    }

    @Test
    public void testToAbsolute_preservesTrailingSlash() {
        Truth.assertThat((Object)UnixPathTest.p("cat/").toAbsolutePath(UnixPathTest.p("/lol"))).isEqualTo((Object)UnixPathTest.p("/lol/cat/"));
    }

    @Test
    public void testSubpath() {
        Truth.assertThat((Object)UnixPathTest.p("/eins/zwei/drei/vier").subpath(0, 1)).isEqualTo((Object)UnixPathTest.p("eins"));
        Truth.assertThat((Object)UnixPathTest.p("/eins/zwei/drei/vier").subpath(0, 2)).isEqualTo((Object)UnixPathTest.p("eins/zwei"));
        Truth.assertThat((Object)UnixPathTest.p("eins/zwei/drei/vier/").subpath(1, 4)).isEqualTo((Object)UnixPathTest.p("zwei/drei/vier"));
        Truth.assertThat((Object)UnixPathTest.p("eins/zwei/drei/vier/").subpath(2, 4)).isEqualTo((Object)UnixPathTest.p("drei/vier"));
    }

    @Test
    public void testSubpath_empty_returnsEmpty() {
        Truth.assertThat((Object)UnixPathTest.p("").subpath(0, 1)).isEqualTo((Object)UnixPathTest.p(""));
    }

    @Test
    public void testSubpath_root_throwsIae() {
        this.thrown.expect(IllegalArgumentException.class);
        UnixPathTest.p("/").subpath(0, 1);
    }

    @Test
    public void testSubpath_negativeIndex_throwsIae() {
        this.thrown.expect(IllegalArgumentException.class);
        UnixPathTest.p("/eins/zwei/drei/vier").subpath(-1, 1);
    }

    @Test
    public void testSubpath_notEnoughElements_throwsIae() {
        this.thrown.expect(IllegalArgumentException.class);
        UnixPathTest.p("/eins/zwei/drei/vier").subpath(0, 5);
    }

    @Test
    public void testSubpath_beginAboveEnd_throwsIae() {
        this.thrown.expect(IllegalArgumentException.class);
        UnixPathTest.p("/eins/zwei/drei/vier").subpath(1, 0);
    }

    @Test
    public void testSubpath_beginAndEndEqual_throwsIae() {
        this.thrown.expect(IllegalArgumentException.class);
        UnixPathTest.p("/eins/zwei/drei/vier").subpath(0, 0);
    }

    @Test
    public void testNameCount() {
        Truth.assertThat((Integer)UnixPathTest.p("").getNameCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)UnixPathTest.p("/").getNameCount()).isEqualTo((Object)0);
        Truth.assertThat((Integer)UnixPathTest.p("/hi/").getNameCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)UnixPathTest.p("/hi/yo").getNameCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)UnixPathTest.p("hi/yo").getNameCount()).isEqualTo((Object)2);
    }

    @Test
    public void testNameCount_dontPermitEmptyComponents_emptiesGetIgnored() {
        Truth.assertThat((Integer)UnixPathTest.p("hi//yo").getNameCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)UnixPathTest.p("//hi//yo//").getNameCount()).isEqualTo((Object)2);
    }

    @Test
    public void testNameCount_permitEmptyComponents_emptiesGetCounted() {
        Truth.assertThat((Integer)UnixPathTest.pp("hi//yo").getNameCount()).isEqualTo((Object)3);
        Truth.assertThat((Integer)UnixPathTest.pp("hi//yo/").getNameCount()).isEqualTo((Object)4);
        Truth.assertThat((Integer)UnixPathTest.pp("hi//yo//").getNameCount()).isEqualTo((Object)5);
    }

    @Test
    public void testNameCount_permitEmptyComponents_rootComponentDoesntCount() {
        Truth.assertThat((Integer)UnixPathTest.pp("hi/yo").getNameCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)UnixPathTest.pp("/hi/yo").getNameCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)UnixPathTest.pp("//hi/yo").getNameCount()).isEqualTo((Object)3);
    }

    @Test
    public void testGetName() {
        Truth.assertThat((Object)UnixPathTest.p("").getName(0)).isEqualTo((Object)UnixPathTest.p(""));
        Truth.assertThat((Object)UnixPathTest.p("/hi").getName(0)).isEqualTo((Object)UnixPathTest.p("hi"));
        Truth.assertThat((Object)UnixPathTest.p("hi/there").getName(1)).isEqualTo((Object)UnixPathTest.p("there"));
    }

    @Test
    public void testCompareTo() {
        Truth.assertThat((Integer)UnixPathTest.p("/hi/there").compareTo(UnixPathTest.p("/hi/there"))).isEqualTo((Object)0);
        Truth.assertThat((Integer)UnixPathTest.p("/hi/there").compareTo(UnixPathTest.p("/hi/therf"))).isEqualTo((Object)-1);
        Truth.assertThat((Integer)UnixPathTest.p("/hi/there").compareTo(UnixPathTest.p("/hi/therd"))).isEqualTo((Object)1);
    }

    @Test
    public void testCompareTo_dontPermitEmptyComponents_emptiesGetIgnored() {
        Truth.assertThat((Integer)UnixPathTest.p("a/b").compareTo(UnixPathTest.p("a//b"))).isEqualTo((Object)0);
    }

    @Test
    public void testCompareTo_permitEmptyComponents_behaviorChanges() {
        Truth.assertThat((Integer)UnixPathTest.p("a/b").compareTo(UnixPathTest.pp("a//b"))).isEqualTo((Object)1);
        Truth.assertThat((Integer)UnixPathTest.pp("a/b").compareTo(UnixPathTest.pp("a//b"))).isEqualTo((Object)1);
    }

    @Test
    public void testCompareTo_comparesComponentsIndividually() {
        Assume.assumeTrue((boolean)true);
        Truth.assertThat((Integer)"hi./there".compareTo("hi/there")).isEqualTo((Object)-1);
        Truth.assertThat((Integer)"hi.".compareTo("hi")).isEqualTo((Object)1);
        Truth.assertThat((Integer)UnixPathTest.p("hi./there").compareTo(UnixPathTest.p("hi/there"))).isEqualTo((Object)1);
        Truth.assertThat((Integer)UnixPathTest.p("hi./there").compareTo(UnixPathTest.p("hi/there"))).isEqualTo((Object)1);
        Assume.assumeTrue((boolean)true);
        Truth.assertThat((Integer)"hi0/there".compareTo("hi/there")).isEqualTo((Object)1);
        Truth.assertThat((Integer)"hi0".compareTo("hi")).isEqualTo((Object)1);
        Truth.assertThat((Integer)UnixPathTest.p("hi0/there").compareTo(UnixPathTest.p("hi/there"))).isEqualTo((Object)1);
    }

    @Test
    public void testSeemsLikeADirectory() {
        Truth.assertThat((Boolean)UnixPathTest.p("a").seemsLikeADirectory()).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("a.").seemsLikeADirectory()).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("a..").seemsLikeADirectory()).isFalse();
        Truth.assertThat((Boolean)UnixPathTest.p("").seemsLikeADirectory()).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/").seemsLikeADirectory()).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p(".").seemsLikeADirectory()).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/.").seemsLikeADirectory()).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("..").seemsLikeADirectory()).isTrue();
        Truth.assertThat((Boolean)UnixPathTest.p("/..").seemsLikeADirectory()).isTrue();
    }

    @Test
    public void testEquals_equalsTester() {
        new EqualsTester().addEqualityGroup(new Object[]{UnixPathTest.p("/lol"), UnixPathTest.p("/lol")}).addEqualityGroup(new Object[]{UnixPathTest.p("/lol//"), UnixPathTest.p("/lol//")}).addEqualityGroup(new Object[]{UnixPathTest.p("dust")}).testEquals();
    }

    @Test
    public void testNullness() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.ignore(UnixPath.class.getMethod("equals", Object.class));
        tester.testAllPublicStaticMethods(UnixPath.class);
        tester.testAllPublicInstanceMethods((Object)UnixPathTest.p("solo"));
    }

    private static UnixPath p(String path) {
        return UnixPath.getPath((boolean)false, (String)path);
    }

    private static UnixPath pp(String path) {
        return UnixPath.getPath((boolean)true, (String)path);
    }
}

