/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio.it;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITGcsNio {
    private static final List<String> FILE_CONTENTS = ImmutableList.of((Object)"Tous les \u00eatres humains naissent libres et \u00e9gaux en dignit\u00e9 et en droits.", (Object)"Ils sont dou\u00e9s de raison et de conscience et doivent agir ", (Object)"les uns envers les autres dans un esprit de fraternit\u00e9.");
    private static final Logger log = Logger.getLogger(ITGcsNio.class.getName());
    private static final String BUCKET = RemoteStorageHelper.generateBucketName();
    private static final String REQUESTER_PAYS_BUCKET = RemoteStorageHelper.generateBucketName() + "_rp";
    private static final String SML_FILE = "tmp-test-small-file.txt";
    private static final String TMP_FILE = "tmp/tmp-test-rnd-file.txt";
    private static final int SML_SIZE = 100;
    private static final String BIG_FILE = "tmp-test-big-file.txt";
    private static final int BIG_SIZE = 2097102;
    private static final String PREFIX = "tmp-test-file";
    private static String project;
    private static Storage storage;
    private static StorageOptions storageOptions;
    private final Random rnd = new Random();

    @BeforeClass
    public static void beforeClass() throws IOException {
        RemoteStorageHelper gcsHelper = RemoteStorageHelper.create();
        storageOptions = gcsHelper.getOptions();
        project = storageOptions.getProjectId();
        storage = (Storage)storageOptions.getService();
        storage.create(BucketInfo.of((String)BUCKET), new Storage.BucketTargetOption[0]);
        ITGcsNio.fillFile(storage, BUCKET, SML_FILE, 100);
        ITGcsNio.fillFile(storage, BUCKET, BIG_FILE, 2097102);
        BucketInfo requesterPaysBucket = BucketInfo.newBuilder((String)REQUESTER_PAYS_BUCKET).setRequesterPays(Boolean.valueOf(true)).build();
        storage.create(requesterPaysBucket, new Storage.BucketTargetOption[0]);
        ITGcsNio.fillRequesterPaysFile(storage, SML_FILE, 100);
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        if (storage != null && !RemoteStorageHelper.forceDelete((Storage)storage, (String)BUCKET, (long)5L, (TimeUnit)TimeUnit.SECONDS).booleanValue() && log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Deletion of bucket {0} timed out, bucket is not empty", BUCKET);
        }
    }

    private static byte[] randomContents(int size) {
        byte[] bytes = new byte[size];
        new Random(size).nextBytes(bytes);
        return bytes;
    }

    private static void fillFile(Storage storage, String bucket, String fname, int size) throws IOException {
        storage.create(BlobInfo.newBuilder((String)bucket, (String)fname).build(), ITGcsNio.randomContents(size), new Storage.BlobTargetOption[0]);
    }

    private static void fillRequesterPaysFile(Storage storage, String fname, int size) throws IOException {
        storage.create(BlobInfo.newBuilder((String)REQUESTER_PAYS_BUCKET, (String)fname).build(), ITGcsNio.randomContents(size), new Storage.BlobTargetOption[]{Storage.BlobTargetOption.userProject((String)project)});
    }

    @Ignore(value="blocked by #3448")
    @Test
    public void testFileExistsRequesterPaysNoUserProject() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(false, "");
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        try {
            Files.exists((Path)path, new LinkOption[0]);
            Assert.fail((String)"It should have thrown an exception.");
        }
        catch (StorageException sex) {
            this.assertIsRequesterPaysException("testFileExistsRequesterPaysNoUserProject", sex);
        }
    }

    @Test
    public void testFileExistsRequesterPays() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(false, project);
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        Files.exists((Path)path, new LinkOption[0]);
    }

    @Test
    public void testFileExistsRequesterPaysWithAutodetect() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(true, project);
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        Files.exists((Path)path, new LinkOption[0]);
    }

    @Ignore(value="blocked by #3448")
    @Test
    public void testCantCreateWithoutUserProject() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(false, "");
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        try {
            Files.write((Path)path, "I would like to write".getBytes(), new OpenOption[0]);
            Assert.fail((String)"It should have thrown an exception.");
        }
        catch (StorageException sex) {
            this.assertIsRequesterPaysException("testCantCreateWithoutUserProject", sex);
        }
    }

    @Test
    public void testCanCreateWithUserProject() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(false, project);
        CloudStoragePath path = testBucket.getPath(TMP_FILE, new String[0]);
        Files.write((Path)path, "I would like to write, please?".getBytes(), new OpenOption[0]);
    }

    @Ignore(value="blocked by #3448")
    @Test
    public void testCantReadWithoutUserProject() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(false, "");
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        try {
            Files.readAllBytes((Path)path);
            Assert.fail((String)"It should have thrown an exception.");
        }
        catch (StorageException sex) {
            this.assertIsRequesterPaysException("testCantReadWithoutUserProject", sex);
        }
    }

    @Test
    public void testCanReadWithUserProject() throws IOException {
        CloudStorageFileSystem testBucket = this.getRequesterPaysBucket(false, project);
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        Files.readAllBytes((Path)path);
    }

    @Ignore(value="blocked by #3448")
    @Test
    public void testCantCopyWithoutUserProject() throws IOException {
        CloudStorageFileSystem testRPBucket = this.getRequesterPaysBucket(false, "");
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath[] sources = new CloudStoragePath[]{testBucket.getPath(SML_FILE, new String[0]), testRPBucket.getPath(SML_FILE, new String[0])};
        CloudStoragePath[] dests = new CloudStoragePath[]{testBucket.getPath(TMP_FILE, new String[0]), testRPBucket.getPath(TMP_FILE, new String[0])};
        for (int s = 0; s < 2; ++s) {
            for (int d = 0; d < 2; ++d) {
                if (s == 0 && d == 0) continue;
                this.innerTestCantCopyWithoutUserProject(s == 0, d == 0, (Path)sources[s], (Path)dests[d]);
            }
        }
    }

    private void innerTestCantCopyWithoutUserProject(boolean sourceNormal, boolean destNormal, Path source, Path dest) throws IOException {
        String sdesc = sourceNormal ? "normal bucket" : "requester-pays bucket";
        String ddesc = destNormal ? "normal bucket" : "requester-pays bucket";
        String description = "Copying from " + sdesc + " to " + ddesc;
        try {
            Files.copy(source, dest, new CopyOption[0]);
            Assert.fail((String)("Shouldn't have been able to copy from " + sdesc + " to " + ddesc));
        }
        catch (HttpResponseException hex) {
            Assert.assertEquals((String)description, (long)hex.getStatusCode(), (long)400L);
            Assert.assertTrue((String)description, (boolean)hex.getMessage().contains("Bucket is requester pays bucket but no user project provided"));
        }
        catch (StorageException sex) {
            this.assertIsRequesterPaysException(description, sex);
        }
    }

    @Test
    public void testCanCopyWithUserProject() throws IOException {
        CloudStorageFileSystem testRPBucket = this.getRequesterPaysBucket(false, project);
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath[] sources = new CloudStoragePath[]{testBucket.getPath(SML_FILE, new String[0]), testRPBucket.getPath(SML_FILE, new String[0])};
        CloudStoragePath[] dests = new CloudStoragePath[]{testBucket.getPath(TMP_FILE, new String[0]), testRPBucket.getPath(TMP_FILE, new String[0])};
        for (int s = 0; s < 2; ++s) {
            for (int d = 0; d < 2; ++d) {
                if (s == 0 && d == 0) continue;
                Files.copy((Path)sources[s], (Path)dests[d], StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    @Test
    public void testAutodetectWhenRequesterPays() throws IOException {
        CloudStorageFileSystem testRPBucket = this.getRequesterPaysBucket(true, project);
        Assert.assertEquals((String)"Autodetect should have detected the RP bucket", (Object)testRPBucket.config().userProject(), (Object)project);
    }

    @Test
    public void testAutodetectWhenNotRequesterPays() throws IOException {
        CloudStorageConfiguration config = CloudStorageConfiguration.builder().autoDetectRequesterPays(true).userProject(project).build();
        CloudStorageFileSystem testBucket = CloudStorageFileSystem.forBucket((String)BUCKET, (CloudStorageConfiguration)config, (StorageOptions)storageOptions);
        Assert.assertEquals((String)"Autodetect should have detected the bucket is not RP", (Object)testBucket.config().userProject(), (Object)"");
    }

    private void assertIsRequesterPaysException(String message, StorageException sex) {
        Assert.assertEquals((String)message, (long)sex.getCode(), (long)400L);
        Assert.assertTrue((String)message, (boolean)sex.getMessage().contains("Bucket is requester pays bucket but no user project provided"));
    }

    @Test
    public void testFileExists() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isTrue();
    }

    @Test
    public void testFileSize() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        Truth.assertThat((Long)Files.size((Path)path)).isEqualTo((Object)100);
    }

    @Test(timeout=60000L)
    public void testReadByteChannel() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(SML_FILE, new String[0]);
        long size = Files.size((Path)path);
        SeekableByteChannel chan = Files.newByteChannel((Path)path, StandardOpenOption.READ);
        Truth.assertThat((Long)chan.size()).isEqualTo((Object)size);
        ByteBuffer buf = ByteBuffer.allocate(100);
        int read = 0;
        while (chan.isOpen()) {
            int rc = chan.read(buf);
            Truth.assertThat((Long)chan.size()).isEqualTo((Object)size);
            if (rc < 0) break;
            Truth.assertThat((Integer)rc).isGreaterThan((Comparable)Integer.valueOf(0));
            Truth.assertThat((Long)chan.position()).isEqualTo((Object)(read += rc));
        }
        Truth.assertThat((Integer)read).isEqualTo((Object)size);
        byte[] expected = new byte[100];
        new Random(100L).nextBytes(expected);
        Truth.assertThat((Boolean)Arrays.equals(buf.array(), expected)).isTrue();
    }

    @Test
    public void testSeek() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(BIG_FILE, new String[0]);
        int size = 2097102;
        byte[] contents = ITGcsNio.randomContents(size);
        byte[] sample = new byte[100];
        SeekableByteChannel chan = Files.newByteChannel((Path)path, StandardOpenOption.READ);
        Truth.assertThat((Long)chan.size()).isEqualTo((Object)size);
        int dest = size / 2;
        chan.position(dest);
        this.readFully(chan, sample);
        byte[] wanted = Arrays.copyOfRange(contents, dest, dest + 100);
        Truth.assertThat((byte[])wanted).isEqualTo((Object)sample);
        chan.position(0L);
        this.readFully(chan, sample);
        byte[] wanted2 = Arrays.copyOf(contents, 100);
        Truth.assertThat((byte[])wanted2).isEqualTo((Object)sample);
        Truth.assertThat((byte[])wanted).isNotEqualTo((Object)wanted2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreate() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(PREFIX + this.randomSuffix(), new String[0]);
        Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isFalse();
        try {
            Files.createFile((Path)path, new FileAttribute[0]);
            Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isTrue();
            long size = Files.size((Path)path);
            Truth.assertThat((Long)size).isEqualTo((Object)0);
        }
        finally {
            Files.deleteIfExists((Path)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrite() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(PREFIX + this.randomSuffix(), new String[0]);
        Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isFalse();
        try {
            Files.write((Path)path, FILE_CONTENTS, StandardCharsets.UTF_8, new OpenOption[0]);
            Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isTrue();
            ByteArrayOutputStream wantBytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)wantBytes, StandardCharsets.UTF_8));
            for (String content : FILE_CONTENTS) {
                writer.println(content);
            }
            writer.close();
            SeekableByteChannel chan = Files.newByteChannel((Path)path, StandardOpenOption.READ);
            byte[] gotBytes = new byte[(int)chan.size()];
            this.readFully(chan, gotBytes);
            Truth.assertThat((byte[])gotBytes).isEqualTo((Object)wantBytes.toByteArray());
        }
        finally {
            Files.deleteIfExists((Path)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndWrite() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(PREFIX + this.randomSuffix(), new String[0]);
        Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isFalse();
        try {
            Files.createFile((Path)path, new FileAttribute[0]);
            Files.write((Path)path, FILE_CONTENTS, StandardCharsets.UTF_8, new OpenOption[0]);
            Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isTrue();
            ByteArrayOutputStream wantBytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)wantBytes, StandardCharsets.UTF_8));
            for (String content : FILE_CONTENTS) {
                writer.println(content);
            }
            writer.close();
            SeekableByteChannel chan = Files.newByteChannel((Path)path, StandardOpenOption.READ);
            byte[] gotBytes = new byte[(int)chan.size()];
            this.readFully(chan, gotBytes);
            Truth.assertThat((byte[])gotBytes).isEqualTo((Object)wantBytes.toByteArray());
        }
        finally {
            Files.deleteIfExists((Path)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteOnClose() throws Exception {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath path = testBucket.getPath(PREFIX + this.randomSuffix(), new String[0]);
        Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isFalse();
        try {
            long expectedSize = 0L;
            try (SeekableByteChannel chan = Files.newByteChannel((Path)path, StandardOpenOption.WRITE);){
                for (String s : FILE_CONTENTS) {
                    byte[] sBytes = s.getBytes(StandardCharsets.UTF_8);
                    expectedSize += (long)(sBytes.length * 9999);
                    for (int i = 0; i < 9999; ++i) {
                        chan.write(ByteBuffer.wrap(sBytes));
                    }
                }
                try {
                    Files.size((Path)path);
                    Assert.fail((String)"Files.size should have thrown an exception");
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            Truth.assertThat((Boolean)Files.exists((Path)path, new LinkOption[0])).isTrue();
            Truth.assertThat((Long)Files.size((Path)path)).isEqualTo((Object)expectedSize);
        }
        finally {
            Files.deleteIfExists((Path)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopy() throws IOException {
        CloudStorageFileSystem testBucket = this.getTestBucket();
        CloudStoragePath src = testBucket.getPath(SML_FILE, new String[0]);
        CloudStoragePath dst = testBucket.getPath(PREFIX + this.randomSuffix(), new String[0]);
        Truth.assertThat((Boolean)Files.exists((Path)dst, new LinkOption[0])).isFalse();
        try {
            Files.copy((Path)src, (Path)dst, new CopyOption[0]);
            Truth.assertThat((Boolean)Files.exists((Path)dst, new LinkOption[0])).isTrue();
            Truth.assertThat((Long)Files.size((Path)dst)).isEqualTo((Object)100);
            byte[] got = new byte[100];
            this.readFully(Files.newByteChannel((Path)dst, new OpenOption[0]), got);
            Truth.assertThat((byte[])got).isEqualTo((Object)ITGcsNio.randomContents(100));
        }
        finally {
            Files.deleteIfExists((Path)dst);
        }
    }

    @Test
    public void testListFiles() throws IOException {
        try (CloudStorageFileSystem fs = this.getTestBucket();){
            ArrayList<Path> goodPaths = new ArrayList<Path>();
            ArrayList<Path> paths = new ArrayList<Path>();
            goodPaths.add(fs.getPath("dir/angel", new String[0]));
            goodPaths.add(fs.getPath("dir/alone", new String[0]));
            paths.add(fs.getPath("dir/dir2/another_angel", new String[0]));
            paths.add(fs.getPath("atroot", new String[0]));
            paths.addAll(goodPaths);
            goodPaths.add(fs.getPath("dir/dir2/", new String[0]));
            for (Path path : paths) {
                ITGcsNio.fillFile(storage, BUCKET, path.toString(), 100);
            }
            ArrayList<Path> got = new ArrayList<Path>();
            for (Path path : Files.newDirectoryStream(fs.getPath("/dir/", new String[0]))) {
                got.add(path);
            }
            Truth.assertThat(got).containsExactlyElementsIn(goodPaths);
            got.clear();
            for (Path path : Files.newDirectoryStream(fs.getPath("dir/", new String[0]))) {
                got.add(path);
            }
            Truth.assertThat(got).containsExactlyElementsIn(goodPaths);
            for (Path path : paths) {
                Files.delete(path);
            }
        }
    }

    @Test
    public void testDeleteRecursive() throws IOException {
        try (CloudStorageFileSystem fs = this.getTestBucket();){
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.add(fs.getPath("Racine", new String[0]));
            paths.add(fs.getPath("playwrights/Moliere", new String[0]));
            paths.add(fs.getPath("playwrights/French/Corneille", new String[0]));
            for (Path path : paths) {
                Files.write(path, FILE_CONTENTS, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            ITGcsNio.deleteRecursive(fs.getPath("playwrights/", new String[0]));
            Truth.assertThat((Boolean)Files.exists(fs.getPath("playwrights/Moliere", new String[0]), new LinkOption[0])).isFalse();
            Truth.assertThat((Boolean)Files.exists(fs.getPath("playwrights/French/Corneille", new String[0]), new LinkOption[0])).isFalse();
            Truth.assertThat((Boolean)Files.exists(fs.getPath("Racine", new String[0]), new LinkOption[0])).isTrue();
            Files.deleteIfExists(fs.getPath("Racine", new String[0]));
            Truth.assertThat((Boolean)Files.exists(fs.getPath("Racine", new String[0]), new LinkOption[0])).isFalse();
        }
    }

    @Test
    public void testListFilesInRootDirectory() throws IOException {
        CloudStorageFileSystem fs = CloudStorageFileSystem.forBucket((String)BUCKET, (CloudStorageConfiguration)CloudStorageConfiguration.builder().permitEmptyPathComponents(true).build(), (StorageOptions)storageOptions);
        CloudStoragePath rootPath = fs.getPath("", new String[0]);
        ArrayList<String> objectNames = new ArrayList<String>();
        for (Path path : Files.newDirectoryStream((Path)rootPath)) {
            objectNames.add(path.toString());
        }
        Truth.assertThat(objectNames).containsExactly(new Object[]{BIG_FILE, SML_FILE});
        rootPath = fs.getPath(".", new String[0]);
        for (Path path : Files.newDirectoryStream((Path)rootPath)) {
            objectNames.add(path.toString());
        }
        Truth.assertThat(objectNames).containsExactly(new Object[]{BIG_FILE, SML_FILE});
    }

    private static void deleteRecursive(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private int readFully(ReadableByteChannel chan, byte[] outputBuf) throws IOException {
        int sofar;
        int read;
        ByteBuffer buf = ByteBuffer.wrap(outputBuf);
        int bytes = buf.remaining();
        for (sofar = 0; sofar < bytes; sofar += read) {
            read = chan.read(buf);
            if (read >= 0) continue;
            throw new EOFException("channel EOF");
        }
        return sofar;
    }

    private String randomSuffix() {
        return "-" + this.rnd.nextInt(99999);
    }

    private CloudStorageFileSystem getTestBucket() throws IOException {
        return CloudStorageFileSystem.forBucket((String)BUCKET, (CloudStorageConfiguration)CloudStorageConfiguration.DEFAULT, (StorageOptions)storageOptions);
    }

    private CloudStorageFileSystem getRequesterPaysBucket(boolean autodetect, String userProject) throws IOException {
        CloudStorageConfiguration config = CloudStorageConfiguration.builder().autoDetectRequesterPays(autodetect).userProject(userProject).build();
        return CloudStorageFileSystem.forBucket((String)REQUESTER_PAYS_BUCKET, (CloudStorageConfiguration)config, (StorageOptions)storageOptions);
    }
}

