/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.upplication.s3fs.S3Path;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class S3ReadOnlySeekableByteChannel
implements SeekableByteChannel {
    private static final int DEFAULT_BUFFER_SIZE = 64000;
    private S3Path path;
    private Set<? extends OpenOption> options;
    private long length;
    private ExtBufferedInputStream bufferedStream;
    private ReadableByteChannel rbc;
    private long position = 0L;

    public S3ReadOnlySeekableByteChannel(S3Path path, Set<? extends OpenOption> options) throws IOException {
        this.path = path;
        this.options = Collections.unmodifiableSet(new HashSet<OpenOption>(options));
        String key = path.getKey();
        boolean exists = path.getFileSystem().provider().exists(path);
        if (!exists) {
            throw new NoSuchFileException(String.format("target not exists: %s", path));
        }
        if (this.options.contains(StandardOpenOption.WRITE) || this.options.contains(StandardOpenOption.CREATE) || this.options.contains(StandardOpenOption.CREATE_NEW) || this.options.contains(StandardOpenOption.APPEND)) {
            throw new ReadOnlyFileSystemException();
        }
        this.length = path.getFileSystem().getClient().getObjectMetadata(path.getFileStore().name(), key).getContentLength();
        this.openStreamAt(0L);
    }

    private void openStreamAt(long position) throws IOException {
        if (this.rbc != null) {
            this.rbc.close();
        }
        GetObjectRequest rangeObjectRequest = new GetObjectRequest(this.path.getFileStore().name(), this.path.getKey()).withRange(position);
        S3Object s3Object = this.path.getFileSystem().getClient().getObject(rangeObjectRequest);
        this.bufferedStream = new ExtBufferedInputStream((InputStream)s3Object.getObjectContent(), 64000);
        this.rbc = Channels.newChannel(this.bufferedStream);
        this.position = position;
    }

    @Override
    public boolean isOpen() {
        return this.rbc.isOpen();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long targetPosition) throws IOException {
        long offset = targetPosition - this.position();
        if (offset > 0L && offset < (long)this.bufferedStream.getBytesInBufferAvailable()) {
            long skipped = this.bufferedStream.skip(offset);
            if (skipped != offset) {
                throw new IOException("Could not seek to " + targetPosition);
            }
            this.position += offset;
        } else if (offset != 0L) {
            this.openStreamAt(targetPosition);
        }
        return this;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.rbc.read(dst);
        if (n > 0) {
            this.position += (long)n;
        }
        return n;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new NonWritableChannelException();
    }

    @Override
    public int write(ByteBuffer src) {
        throw new NonWritableChannelException();
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }

    private class ExtBufferedInputStream
    extends BufferedInputStream {
        private ExtBufferedInputStream(InputStream inputStream, int size) {
            super(inputStream, size);
        }

        int getBytesInBufferAvailable() {
            if (this.count == this.pos) {
                return 0;
            }
            return this.buf.length - this.pos;
        }
    }
}

