/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs.util;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Sets;
import com.upplication.s3fs.S3Path;
import com.upplication.s3fs.attribute.S3BasicFileAttributes;
import com.upplication.s3fs.attribute.S3PosixFileAttributes;
import com.upplication.s3fs.attribute.S3UserPrincipal;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class S3Utils {
    public S3ObjectSummary getS3ObjectSummary(S3Path s3Path) throws NoSuchFileException {
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        AmazonS3 client = s3Path.getFileSystem().getClient();
        try {
            S3ObjectSummary result;
            block9: {
                ObjectMetadata metadata = client.getObjectMetadata(bucketName, key);
                result = new S3ObjectSummary();
                result.setBucketName(bucketName);
                result.setETag(metadata.getETag());
                result.setKey(key);
                result.setLastModified(metadata.getLastModified());
                result.setSize(metadata.getContentLength());
                try {
                    AccessControlList objectAcl = client.getObjectAcl(bucketName, key);
                    result.setOwner(objectAcl.getOwner());
                }
                catch (AmazonS3Exception e) {
                    if (e.getStatusCode() == 403) break block9;
                    throw e;
                }
            }
            return result;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            try {
                ListObjectsRequest request = new ListObjectsRequest();
                request.setBucketName(bucketName);
                String keyFolder = key;
                if (!keyFolder.endsWith("/")) {
                    keyFolder = keyFolder + "/";
                }
                request.setPrefix(keyFolder);
                request.setMaxKeys(Integer.valueOf(1));
                ObjectListing current = client.listObjects(request);
                if (!current.getObjectSummaries().isEmpty()) {
                    return (S3ObjectSummary)current.getObjectSummaries().get(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NoSuchFileException(bucketName + "/" + key);
        }
    }

    public S3BasicFileAttributes getS3FileAttributes(S3Path s3Path) throws NoSuchFileException {
        S3ObjectSummary objectSummary = this.getS3ObjectSummary(s3Path);
        return this.toS3FileAttributes(objectSummary, s3Path.getKey());
    }

    public S3PosixFileAttributes getS3PosixFileAttributes(S3Path s3Path) throws NoSuchFileException {
        S3ObjectSummary objectSummary = this.getS3ObjectSummary(s3Path);
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        S3BasicFileAttributes attrs = this.toS3FileAttributes(objectSummary, key);
        S3UserPrincipal userPrincipal = null;
        Set<PosixFilePermission> permissions = null;
        if (!attrs.isDirectory()) {
            AmazonS3 client = s3Path.getFileSystem().getClient();
            AccessControlList acl = client.getObjectAcl(bucketName, key);
            Owner owner = acl.getOwner();
            userPrincipal = new S3UserPrincipal(owner.getId() + ":" + owner.getDisplayName());
            permissions = this.toPosixFilePermissions(acl.getGrantsAsList());
        }
        return new S3PosixFileAttributes((String)attrs.fileKey(), attrs.lastModifiedTime(), attrs.size(), attrs.isDirectory(), attrs.isRegularFile(), userPrincipal, null, permissions);
    }

    public Set<PosixFilePermission> toPosixFilePermissions(List<Grant> grants) {
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        for (Grant grant : grants) {
            filePermissions.addAll(this.toPosixFilePermission(grant.getPermission()));
        }
        return filePermissions;
    }

    public Set<PosixFilePermission> toPosixFilePermission(Permission permission) {
        switch (permission) {
            case FullControl: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});
            }
            case Write: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE});
            }
            case Read: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ});
            }
            case ReadAcp: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ});
            }
            case WriteAcp: {
                return Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE});
            }
        }
        throw new IllegalStateException("Unknown Permission: " + permission);
    }

    public S3BasicFileAttributes toS3FileAttributes(S3ObjectSummary objectSummary, String key) {
        FileTime lastModifiedTime = null;
        if (objectSummary.getLastModified() != null) {
            lastModifiedTime = FileTime.from(objectSummary.getLastModified().getTime(), TimeUnit.MILLISECONDS);
        }
        long size = objectSummary.getSize();
        boolean directory = false;
        boolean regularFile = false;
        String resolvedKey = objectSummary.getKey();
        if (key.endsWith("/") && resolvedKey.equals(key) || resolvedKey.equals(key + "/")) {
            directory = true;
        } else if (key.isEmpty()) {
            directory = true;
            resolvedKey = "/";
        } else if (!resolvedKey.equals(key) && resolvedKey.startsWith(key)) {
            directory = true;
            size = 0L;
            resolvedKey = key + "/";
        } else {
            regularFile = true;
        }
        return new S3BasicFileAttributes(resolvedKey, lastModifiedTime, size, directory, regularFile);
    }
}

