/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.reflector;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.doc.reflector.JavaparserSourceParserReflector;
import org.lastaflute.doc.reflector.SourceParserReflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceParserReflectorFactory {
    private static final Logger _log = LoggerFactory.getLogger(SourceParserReflectorFactory.class);
    private static final String JAVA_PARSER_CLASS_NAME = "com.github.javaparser.JavaParser";
    private static final float JAVA_PARSER_VERSION = 3.1f;

    public OptionalThing<SourceParserReflector> reflector(List<String> srcDirList) {
        String className = JAVA_PARSER_CLASS_NAME;
        JavaparserSourceParserReflector reflector = null;
        try {
            DfReflectionUtil.forName((String)JAVA_PARSER_CLASS_NAME);
            _log.debug("...Loading java parser for document: {}", (Object)JAVA_PARSER_CLASS_NAME);
            this.validateVersion(3.1f);
            reflector = this.createJavaparserSourceParserReflector(srcDirList);
        }
        catch (DfReflectionUtil.ReflectionFailureException ignored) {
            reflector = null;
        }
        return OptionalThing.ofNullable(reflector, () -> {
            throw new IllegalStateException("Not found the java parser: com.github.javaparser.JavaParser");
        });
    }

    public void validateVersion(float leastVersion) {
        this.getVersion("com.github.javaparser", "javaparser-core").ifPresent(version -> {
            _log.debug("...Loading java parser for version: {}", version);
            String majorMinorVersionStr = version.replaceAll("[^\\d.]", "").replaceAll("(\\d+(\\.\\d+)?).*", "$1");
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)majorMinorVersionStr)) {
                float majorMinorVersion = Float.parseFloat(majorMinorVersionStr);
                if (majorMinorVersion < leastVersion) {
                    String msg = "Upgrade javaparser-core version to (at least) 3.1 for rich LastaDoc.";
                    throw new PleaseUpgradeJavaParserVersion(msg);
                }
            } else {
                _log.debug("...Loading java parser for version: Could not analyze.");
            }
        }).orElse(() -> _log.debug("...Loading java parser for version: Not found."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OptionalThing<String> getVersion(String groupId, String artifactId) {
        try {
            String name = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(name);
            if (!urls.hasMoreElements()) return OptionalThing.empty();
            URL url = urls.nextElement();
            try (InputStream is = url.openStream();){
                Properties props = new Properties();
                props.load(is);
                String version = props.getProperty("version");
                OptionalThing optionalThing = OptionalThing.of((Object)version);
                return optionalThing;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OptionalThing.empty();
    }

    protected JavaparserSourceParserReflector createJavaparserSourceParserReflector(List<String> srcDirList) {
        return new JavaparserSourceParserReflector(srcDirList);
    }

    protected static class PleaseUpgradeJavaParserVersion
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PleaseUpgradeJavaParserVersion(String msg) {
            super(msg);
        }
    }
}

