/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.generator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.di.core.exception.ComponentNotFoundException;
import org.lastaflute.doc.generator.BaseDocumentGenerator;
import org.lastaflute.doc.meta.JobDocMeta;
import org.lastaflute.doc.meta.TypeDocMeta;
import org.lastaflute.doc.reflector.SourceParserReflector;
import org.lastaflute.job.JobManager;

public class JobDocumentGenerator
extends BaseDocumentGenerator {
    protected final List<String> srcDirList;
    protected int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;

    protected JobDocumentGenerator(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        this.srcDirList = srcDirList;
        this.depth = depth;
        this.sourceParserReflector = sourceParserReflector;
    }

    public List<JobDocMeta> generateJobDocMetaList() {
        JobManager jobManager = this.getJobManager();
        List<JobDocMeta> metaList = jobManager.getJobList().stream().map(job -> {
            JobDocMeta jobDocMeta = new JobDocMeta();
            jobDocMeta.setJobKey(this.getNoException(() -> job.getJobKey().value()));
            jobDocMeta.setJobUnique(this.getNoException(() -> (String)job.getJobUnique().map(jobUnique -> jobUnique.value()).orElse(null)));
            jobDocMeta.setJobTitle(this.getNoException(() -> (String)job.getJobNote().flatMap(jobNote -> jobNote.getTitle()).orElse(null)));
            jobDocMeta.setJobDescription(this.getNoException(() -> (String)job.getJobNote().flatMap(jobNote -> jobNote.getDesc()).orElse(null)));
            jobDocMeta.setCronExp(this.getNoException(() -> (String)job.getCronExp().orElse(null)));
            Class jobClass = this.getNoException(() -> job.getJobType());
            if (jobClass != null) {
                jobDocMeta.setTypeName(jobClass.getName());
                jobDocMeta.setSimpleTypeName(jobClass.getSimpleName());
                jobDocMeta.setFieldTypeDocMetaList(Arrays.stream(jobClass.getDeclaredFields()).map(field -> {
                    TypeDocMeta typeDocMeta = new TypeDocMeta();
                    typeDocMeta.setName(field.getName());
                    typeDocMeta.setType(field.getType());
                    typeDocMeta.setTypeName(this.adjustTypeName(field.getGenericType()));
                    typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(field.getGenericType()));
                    typeDocMeta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
                    typeDocMeta.setAnnotationList(this.analyzeAnnotationList(typeDocMeta.getAnnotationTypeList()));
                    this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(typeDocMeta, field.getType()));
                    return typeDocMeta;
                }).collect(Collectors.toList()));
                jobDocMeta.setMethodName("run");
                this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(jobDocMeta, jobClass));
            }
            jobDocMeta.setParams(this.getNoException(() -> (Map)job.getParamsSupplier().map(paramsSupplier -> paramsSupplier.supply()).orElse(null)));
            jobDocMeta.setNoticeLogLevel(this.getNoException(() -> job.getNoticeLogLevel().name()));
            jobDocMeta.setConcurrentExec(this.getNoException(() -> job.getConcurrentExec().name()));
            jobDocMeta.setTriggeredJobKeyList(this.getNoException(() -> job.getTriggeredJobKeySet().stream().map(triggeredJobKey -> triggeredJobKey.value()).collect(Collectors.toList())));
            return jobDocMeta;
        }).collect(Collectors.toList());
        return metaList;
    }

    protected JobManager getJobManager() {
        try {
            return (JobManager)ContainerUtil.getComponent(JobManager.class);
        }
        catch (ComponentNotFoundException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the job manager as Lasta Di component.");
            br.addItem("Advice");
            br.addElement((Object)"LastaDoc needs JobManager to get job information.");
            br.addElement((Object)"So confirm your app.xml (or test_app.xml?)");
            br.addElement((Object)"whether the Di xml includes lasta_job.xml or not.");
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg, e);
        }
    }

    protected <T> T getNoException(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

