/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.reflector;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.doc.meta.ActionDocMeta;
import org.lastaflute.doc.meta.JobDocMeta;
import org.lastaflute.doc.meta.TypeDocMeta;
import org.lastaflute.doc.reflector.SourceParserReflector;

public class JavaparserSourceParserReflector
implements SourceParserReflector {
    protected static final Pattern CLASS_METHOD_COMMENT_END_PATTERN = Pattern.compile("(.+)[.\u3002]?.*(\r?\n)?");
    protected static final Pattern FIELD_COMMENT_END_PATTERN = Pattern.compile("([^.\u3002\\*]+).* ?\\*?");
    protected static final Pattern RETURN_STMT_PATTERN = Pattern.compile("^[^)]+\\)");
    protected final List<String> srcDirList;
    protected final Map<Class<?>, CompilationUnit> compilationUnitMap = DfCollectionUtil.newHashMap();

    public JavaparserSourceParserReflector(List<String> srcDirList) {
        this.srcDirList = srcDirList;
    }

    @Override
    public List<Method> getMethodListOrderByDefinition(Class<?> clazz) {
        final ArrayList methodDeclarationList = DfCollectionUtil.newArrayList();
        this.parseClass(clazz).ifPresent(compilationUnit -> {
            VoidVisitorAdapter<Void> adapter = new VoidVisitorAdapter<Void>(){

                public void visit(MethodDeclaration methodDeclaration, Void arg) {
                    methodDeclarationList.add(methodDeclaration.getNameAsString());
                    super.visit(methodDeclaration, (Object)arg);
                }
            };
            adapter.visit(compilationUnit, null);
        });
        List<Method> methodList = Arrays.stream(clazz.getMethods()).sorted(Comparator.comparing(method -> methodDeclarationList.indexOf(method.getName()))).collect(Collectors.toList());
        return methodList;
    }

    @Override
    public void reflect(ActionDocMeta meta, Method method) {
        this.parseClass(method.getDeclaringClass()).ifPresent(compilationUnit -> {
            LinkedHashMap returnMap = DfCollectionUtil.newLinkedHashMap();
            VoidVisitorAdapter<ActionDocMeta> adapter = this.createActionDocMetaVisitorAdapter(method, returnMap);
            adapter.visit(compilationUnit, (Object)meta);
            ArrayList descriptionList = DfCollectionUtil.newArrayList();
            Arrays.asList(meta.getTypeComment(), meta.getMethodComment()).forEach(comment -> {
                Matcher matcher;
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = CLASS_METHOD_COMMENT_END_PATTERN.matcher((CharSequence)comment)).find()) {
                    descriptionList.add(matcher.group(1));
                }
            });
            if (!descriptionList.isEmpty()) {
                meta.setDescription(String.join((CharSequence)", ", descriptionList));
            }
            List<TypeDocMeta> parameterTypeDocMetaList = meta.getParameterTypeDocMetaList();
            java.lang.reflect.Parameter[] parameters = method.getParameters();
            for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                if (parameterIndex >= parameterTypeDocMetaList.size()) continue;
                java.lang.reflect.Parameter parameter = parameters[parameterIndex];
                TypeDocMeta typeDocMeta = parameterTypeDocMetaList.get(parameterIndex);
                meta.setUrl(meta.getUrl().replace("{" + parameter.getName() + "}", "{" + typeDocMeta.getName() + "}"));
            }
            String methodName = method.getName();
            if (returnMap.containsKey(methodName) && !((List)returnMap.get(methodName)).isEmpty()) {
                meta.getReturnTypeDocMeta().setValue(String.join((CharSequence)",", (Iterable)returnMap.get(methodName)));
            }
        });
    }

    protected VoidVisitorAdapter<ActionDocMeta> createActionDocMetaVisitorAdapter(Method method, Map<String, List<String>> returnMap) {
        return new ActionDocMetaVisitorAdapter(method, returnMap);
    }

    @Override
    public void reflect(JobDocMeta jobDocMeta, Class<?> clazz) {
        this.parseClass(clazz).ifPresent(compilationUnit -> {
            VoidVisitorAdapter<JobDocMeta> adapter = this.createJobDocMetaVisitorAdapter();
            adapter.visit(compilationUnit, (Object)jobDocMeta);
            ArrayList descriptionList = DfCollectionUtil.newArrayList();
            Arrays.asList(jobDocMeta.getTypeComment(), jobDocMeta.getMethodComment()).forEach(comment -> {
                Matcher matcher;
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = CLASS_METHOD_COMMENT_END_PATTERN.matcher((CharSequence)comment)).find()) {
                    descriptionList.add(matcher.group(1));
                }
            });
            if (!descriptionList.isEmpty()) {
                jobDocMeta.setDescription(String.join((CharSequence)", ", descriptionList));
            }
        });
    }

    protected VoidVisitorAdapter<JobDocMeta> createJobDocMetaVisitorAdapter() {
        return new JobDocMetaVisitorAdapter();
    }

    @Override
    public void reflect(TypeDocMeta typeDocMeta, Class<?> clazz) {
        ArrayList classList = DfCollectionUtil.newArrayList();
        for (Class<?> targetClass2 = clazz; targetClass2 != null; targetClass2 = targetClass2.getSuperclass()) {
            classList.add(targetClass2);
        }
        Collections.reverse(classList);
        classList.forEach(targetClass -> this.parseClass((Class<?>)targetClass).ifPresent(compilationUnit -> {
            VoidVisitorAdapter<TypeDocMeta> adapter = this.createTypeDocMetaVisitorAdapter();
            adapter.visit(compilationUnit, (Object)typeDocMeta);
        }));
    }

    protected VoidVisitorAdapter<TypeDocMeta> createTypeDocMetaVisitorAdapter() {
        return new TypeDocMetaVisitorAdapter();
    }

    protected String adjustComment(NodeWithJavadoc<?> nodeWithJavadoc) {
        try {
            return nodeWithJavadoc.getJavadoc().map(javadoc -> javadoc.toText().replaceAll("(^\r?\n|\r?\n$)", "")).orElse(null);
        }
        catch (Throwable t) {
            return "javadoc parse error. error messge=" + t.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OptionalThing<CompilationUnit> parseClass(Class<?> clazz) {
        String srcDir;
        File file;
        if (this.compilationUnitMap.containsKey(clazz)) {
            return OptionalThing.of((Object)this.compilationUnitMap.get(clazz));
        }
        Iterator<String> iterator = this.srcDirList.iterator();
        do {
            if (!iterator.hasNext()) return OptionalThing.empty();
        } while (!(file = new File(srcDir = iterator.next(), clazz.getName().replace('.', File.separatorChar) + ".java")).exists() && !(file = new File(srcDir, clazz.getName().replace('.', File.separatorChar).replaceAll("\\$.*", "") + ".java")).exists());
        try (FileInputStream in = new FileInputStream(file);){
            CompilationUnit compilationUnit = JavaParser.parse((InputStream)in);
            this.compilationUnitMap.put(clazz, compilationUnit);
            OptionalThing optionalThing = OptionalThing.of((Object)compilationUnit);
            return optionalThing;
        }
        catch (IOException e) {
            return OptionalThing.empty();
        }
    }

    public class TypeDocMetaVisitorAdapter
    extends VoidVisitorAdapter<TypeDocMeta> {
        public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, TypeDocMeta typeDocMeta) {
            this.prepareClassComment(classOrInterfaceDeclaration, typeDocMeta);
            super.visit(classOrInterfaceDeclaration, (Object)typeDocMeta);
        }

        protected void prepareClassComment(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, TypeDocMeta typeDocMeta) {
            String comment;
            if (DfStringUtil.is_Null_or_Empty((String)typeDocMeta.getComment()) && classOrInterfaceDeclaration.getNameAsString().equals(typeDocMeta.getSimpleTypeName()) && DfStringUtil.is_NotNull_and_NotEmpty((String)(comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)classOrInterfaceDeclaration)))) {
                Matcher matcher;
                typeDocMeta.setComment(comment);
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = CLASS_METHOD_COMMENT_END_PATTERN.matcher(comment)).find()) {
                    typeDocMeta.setDescription(matcher.group(1));
                }
            }
        }

        public void visit(FieldDeclaration fieldDeclaration, TypeDocMeta typeDocMeta) {
            this.prepareFieldComment(fieldDeclaration, typeDocMeta);
            super.visit(fieldDeclaration, (Object)typeDocMeta);
        }

        protected void prepareFieldComment(FieldDeclaration fieldDeclaration, TypeDocMeta typeDocMeta) {
            String comment;
            if (fieldDeclaration.getVariables().stream().anyMatch(variable -> variable.getNameAsString().equals(typeDocMeta.getName())) && DfStringUtil.is_NotNull_and_NotEmpty((String)(comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)fieldDeclaration)))) {
                typeDocMeta.setComment(comment);
                Matcher matcher = FIELD_COMMENT_END_PATTERN.matcher(this.saveFieldCommentSpecialExp(comment));
                if (matcher.find()) {
                    String description = matcher.group(1).trim();
                    typeDocMeta.setDescription(this.restoreFieldCommentSpecialExp(description));
                }
            }
        }

        protected String saveFieldCommentSpecialExp(String comment) {
            return comment.replace("e.g.", "$$edotgdot$$");
        }

        protected String restoreFieldCommentSpecialExp(String comment) {
            return comment.replace("$$edotgdot$$", "e.g.");
        }
    }

    public class JobDocMetaVisitorAdapter
    extends VoidVisitorAdapter<JobDocMeta> {
        public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, JobDocMeta jobDocMeta) {
            classOrInterfaceDeclaration.getBegin().ifPresent(begin -> classOrInterfaceDeclaration.getEnd().ifPresent(end -> jobDocMeta.setFileLineCount(end.line - begin.line)));
            String comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)classOrInterfaceDeclaration);
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
                jobDocMeta.setTypeComment(comment);
            }
            super.visit(classOrInterfaceDeclaration, (Object)jobDocMeta);
        }

        public void visit(MethodDeclaration methodDeclaration, JobDocMeta jobDocMeta) {
            if (!methodDeclaration.getNameAsString().equals(jobDocMeta.getMethodName())) {
                return;
            }
            methodDeclaration.getBegin().ifPresent(begin -> methodDeclaration.getEnd().ifPresent(end -> jobDocMeta.setMethodLineCount(end.line - begin.line)));
            String comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)methodDeclaration);
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
                jobDocMeta.setMethodComment(comment);
            }
            super.visit(methodDeclaration, (Object)jobDocMeta);
        }
    }

    public class ActionDocMetaVisitorAdapter
    extends VoidVisitorAdapter<ActionDocMeta> {
        protected final Method method;
        protected final Map<String, List<String>> returnMap;

        public ActionDocMetaVisitorAdapter(Method method, Map<String, List<String>> returnMap) {
            this.method = method;
            this.returnMap = returnMap;
        }

        public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, ActionDocMeta actionDocMeta) {
            classOrInterfaceDeclaration.getBegin().ifPresent(begin -> classOrInterfaceDeclaration.getEnd().ifPresent(end -> actionDocMeta.setFileLineCount(end.line - begin.line)));
            String comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)classOrInterfaceDeclaration);
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
                actionDocMeta.setTypeComment(comment);
            }
            super.visit(classOrInterfaceDeclaration, (Object)actionDocMeta);
        }

        public void visit(final MethodDeclaration methodDeclaration, ActionDocMeta actionDocMeta) {
            if (!methodDeclaration.getNameAsString().equals(this.method.getName())) {
                return;
            }
            methodDeclaration.getBegin().ifPresent(begin -> methodDeclaration.getEnd().ifPresent(end -> actionDocMeta.setMethodLineCount(end.line - begin.line)));
            String comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)methodDeclaration);
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
                actionDocMeta.setMethodComment(comment);
            }
            IntStream.range(0, actionDocMeta.getParameterTypeDocMetaList().size()).forEach(parameterIndex -> {
                if (parameterIndex < methodDeclaration.getParameters().size()) {
                    Pattern pattern;
                    Matcher matcher;
                    TypeDocMeta typeDocMeta = actionDocMeta.getParameterTypeDocMetaList().get(parameterIndex);
                    Parameter parameter = (Parameter)methodDeclaration.getParameters().get(parameterIndex);
                    typeDocMeta.setName(parameter.getNameAsString());
                    if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = (pattern = Pattern.compile(".*@param\\s?" + parameter.getNameAsString() + "\\s?(.*)\r?\n.*", 32)).matcher(comment)).matches()) {
                        typeDocMeta.setDescription(matcher.group(1).replaceAll("\r?\n.*", ""));
                    }
                }
            });
            methodDeclaration.accept((VoidVisitor)new VoidVisitorAdapter<ActionDocMeta>(){

                public void visit(ReturnStmt returnStmt, ActionDocMeta actionDocMeta) {
                    ActionDocMetaVisitorAdapter.this.prepareReturnStmt(methodDeclaration, returnStmt);
                    super.visit(returnStmt, (Object)actionDocMeta);
                }
            }, (Object)actionDocMeta);
            super.visit(methodDeclaration, (Object)actionDocMeta);
        }

        protected void prepareReturnStmt(MethodDeclaration methodDeclaration, ReturnStmt returnStmt) {
            returnStmt.getExpression().ifPresent(expression -> {
                String returnStmtStr = expression.toString();
                Matcher matcher = RETURN_STMT_PATTERN.matcher(returnStmtStr);
                if (!this.returnMap.containsKey(methodDeclaration.getNameAsString())) {
                    this.returnMap.put(methodDeclaration.getNameAsString(), DfCollectionUtil.newArrayList());
                }
                this.returnMap.get(methodDeclaration.getNameAsString()).add(matcher.find() ? matcher.group(0) : "##unanalyzable##");
            });
        }
    }
}

