/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.dbflute.optional.OptionalThing;

public class MavenVersionFinder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OptionalThing<String> getVersion(String groupId, String artifactId) {
        try {
            String name = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(name);
            if (!urls.hasMoreElements()) return OptionalThing.empty();
            URL url = urls.nextElement();
            try (InputStream is = url.openStream();){
                Properties props = new Properties();
                props.load(is);
                String version = props.getProperty("version");
                OptionalThing optionalThing = OptionalThing.of((Object)version);
                return optionalThing;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return OptionalThing.empty();
    }
}

