/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.generator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.dbflute.util.DfReflectionUtil;

public class BaseDocumentGenerator {
    protected List<String> analyzeAnnotationList(List<Annotation> annotationList) {
        return annotationList.stream().map(annotation -> {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String typeName = this.adjustSimpleTypeName(annotationType);
            Map methodMap = Arrays.stream(annotationType.getDeclaredMethods()).filter(method -> {
                Object defaultValue;
                Object value = DfReflectionUtil.invoke((Method)method, (Object)annotation, (Object[])null);
                if (Objects.equals(value, defaultValue = method.getDefaultValue())) {
                    return false;
                }
                return !method.getReturnType().isArray() || !Arrays.equals((Object[])value, (Object[])defaultValue);
            }).collect(Collectors.toMap(key -> key.getName(), value -> {
                List data = DfReflectionUtil.invoke((Method)value, (Object)annotation, (Object[])null);
                if (data != null && data.getClass().isArray()) {
                    List<Object> dataList = Arrays.asList((Object[])data);
                    if (dataList.isEmpty()) {
                        return "";
                    }
                    data = dataList.stream().map(o -> o instanceof Class ? this.adjustSimpleTypeName((Class)o) : o).collect(Collectors.toList());
                }
                return data;
            }, (v1, v2) -> v1, TreeMap::new));
            if (methodMap.isEmpty()) {
                return typeName;
            }
            return typeName + methodMap;
        }).collect(Collectors.toList());
    }

    protected String adjustTypeName(Type type) {
        return this.adjustTypeName(type.getTypeName());
    }

    protected String adjustTypeName(String typeName) {
        return typeName;
    }

    protected String adjustSimpleTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return this.adjustSimpleTypeName(this.adjustTypeName(type));
    }

    protected String adjustSimpleTypeName(String typeName) {
        return typeName.replaceAll("[a-z0-9]+\\.", "");
    }
}

