/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.Size;
import org.dbflute.jdbc.Classification;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfStringUtil;
import org.dbflute.util.DfTypeUtil;
import org.hibernate.validator.constraints.Length;
import org.lastaflute.core.direction.AccessibleConfig;
import org.lastaflute.core.json.JsonManager;
import org.lastaflute.core.json.SimpleJsonManager;
import org.lastaflute.core.json.engine.GsonJsonEngine;
import org.lastaflute.core.time.TimeManager;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.di.util.tiger.Tuple3;
import org.lastaflute.doc.DocumentGenerator;
import org.lastaflute.doc.SwaggerOption;
import org.lastaflute.doc.generator.ActionDocumentGenerator;
import org.lastaflute.doc.meta.TypeDocMeta;
import org.lastaflute.doc.util.LaDocReflectionUtil;
import org.lastaflute.web.util.LaRequestUtil;
import org.lastaflute.web.util.LaServletContextUtil;
import org.lastaflute.web.validation.Required;

public class SwaggerGenerator {
    public void saveSwaggerMeta(Map<String, Object> swaggerMap) {
        String json = this.createJsonParser().toJson(swaggerMap);
        Path path = Paths.get(this.getLastaDocDir(), "swagger.json");
        Path parentPath = path.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory: " + parentPath, e);
            }
        }
        try (BufferedWriter bw = Files.newBufferedWriter(path, Charset.forName("UTF-8"), new OpenOption[0]);){
            bw.write(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write the json to the file: " + path, e);
        }
    }

    public Map<String, Object> generateSwaggerMap() {
        Map<String, Object> swaggerMap = this.createSwaggerMap();
        return swaggerMap;
    }

    public Map<String, Object> generateSwaggerMap(Consumer<SwaggerOption> op) {
        SwaggerOption swaggerOption = new SwaggerOption();
        op.accept(swaggerOption);
        Map<String, Object> swaggerMap = this.createSwaggerMap();
        List<Map<String, Object>> headerParameterList = swaggerOption.getHeaderParameterList();
        this.adaptHeaderParameters(swaggerMap, headerParameterList);
        List<Map<String, Object>> securityDefinitionList = swaggerOption.getSecurityDefinitionList();
        this.adaptSecurityDefinitions(swaggerMap, securityDefinitionList);
        return swaggerMap;
    }

    protected Map<String, Object> createSwaggerMap() {
        OptionalThing<Map<String, Object>> swaggerJson = this.readSwaggerJson();
        if (swaggerJson.isPresent()) {
            return (Map)swaggerJson.get();
        }
        LinkedHashMap swaggerMap = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("swagger", "2.0");
        Map<String, String> swaggerInfoMap = this.createSwaggerInfoMap();
        swaggerMap.put("info", swaggerInfoMap);
        swaggerMap.put("schemes", Arrays.asList(LaRequestUtil.getRequest().getScheme()));
        StringBuilder basePath = new StringBuilder();
        basePath.append(LaServletContextUtil.getServletContext().getContextPath() + "/");
        this.prepareApplicationVersion().ifPresent(applicationVersion -> basePath.append(applicationVersion + "/"));
        swaggerMap.put("basePath", basePath.toString());
        ArrayList swaggerTagList = DfCollectionUtil.newArrayList();
        swaggerMap.put("tags", swaggerTagList);
        LinkedHashMap swaggerPathMap = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("paths", swaggerPathMap);
        LinkedHashMap swaggerDefinitionsMap = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("definitions", swaggerDefinitionsMap);
        this.createSwaggerPathMap(swaggerTagList, swaggerPathMap, swaggerDefinitionsMap);
        return swaggerMap;
    }

    /*
     * Exception decompiling
     */
    protected OptionalThing<Map<String, Object>> readSwaggerJson() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Map<String, String> createSwaggerInfoMap() {
        LinkedHashMap swaggerInfoMap = DfCollectionUtil.newLinkedHashMap();
        String domainName = this.getAccessibleConfig().get("domain.name");
        swaggerInfoMap.put("title", domainName);
        swaggerInfoMap.put("description", domainName);
        swaggerInfoMap.put("version", "1.0.0");
        return swaggerInfoMap;
    }

    protected void createSwaggerPathMap(List<Map<String, Object>> swaggerTagList, Map<String, Map<String, Object>> swaggerPathMap, Map<String, Map<String, Object>> swaggerDefinitionsMap) {
        this.createActionDocumentGenerator().generateActionDocMetaList().stream().forEach(actiondocMeta -> {
            LinkedHashMap schema;
            Map<String, LinkedHashMap> swaggerUrlMap;
            if (!swaggerPathMap.containsKey(actiondocMeta.getUrl())) {
                swaggerUrlMap = DfCollectionUtil.newLinkedHashMap();
                swaggerPathMap.put(actiondocMeta.getUrl(), swaggerUrlMap);
            }
            swaggerUrlMap = (Map)swaggerPathMap.get(actiondocMeta.getUrl());
            LinkedHashMap swaggerHttpMethodMap = DfCollectionUtil.newLinkedHashMap();
            Pattern pattern = Pattern.compile("(.+)\\$.+");
            Matcher matcher = pattern.matcher(actiondocMeta.getMethodName());
            String httpMethod = matcher.find() ? matcher.group(1) : "post";
            swaggerUrlMap.put(httpMethod, swaggerHttpMethodMap);
            swaggerHttpMethodMap.put("summary", actiondocMeta.getDescription());
            swaggerHttpMethodMap.put("description", actiondocMeta.getDescription());
            ArrayList parameterMapList = DfCollectionUtil.newArrayList();
            parameterMapList.addAll(actiondocMeta.getParameterTypeDocMetaList().stream().map(typeDocMeta -> {
                Map<String, Object> swaggerParameterMap = this.createSwaggerParameterMap((TypeDocMeta)typeDocMeta, swaggerDefinitionsMap);
                swaggerParameterMap.put("in", "path");
                swaggerParameterMap.put("required", !OptionalThing.class.isAssignableFrom(typeDocMeta.getType()));
                return swaggerParameterMap;
            }).collect(Collectors.toList()));
            if (actiondocMeta.getFormTypeDocMeta() != null) {
                if (actiondocMeta.getFormTypeDocMeta().getTypeName().endsWith("Form")) {
                    swaggerHttpMethodMap.put("consumes", Arrays.asList("text/plain;charset=utf-8"));
                    parameterMapList.addAll(actiondocMeta.getFormTypeDocMeta().getNestTypeDocMetaList().stream().map(typeDocMeta -> {
                        Map<String, Object> swaggerParameterMap = this.createSwaggerParameterMap((TypeDocMeta)typeDocMeta, swaggerDefinitionsMap);
                        swaggerParameterMap.put("in", "get".equals(httpMethod) ? "query" : "formData");
                        return swaggerParameterMap;
                    }).collect(Collectors.toList()));
                } else {
                    swaggerHttpMethodMap.put("consumes", Arrays.asList("application/json"));
                    LinkedHashMap swaggerParameterMap = DfCollectionUtil.newLinkedHashMap();
                    swaggerParameterMap.put("name", actiondocMeta.getFormTypeDocMeta().getSimpleTypeName());
                    swaggerParameterMap.put("in", "body");
                    swaggerParameterMap.put("required", true);
                    schema = DfCollectionUtil.newLinkedHashMap();
                    schema.put("type", "object");
                    schema.put("properties", actiondocMeta.getFormTypeDocMeta().getNestTypeDocMetaList().stream().map(typeDocMeta -> this.createSwaggerParameterMap((TypeDocMeta)typeDocMeta, swaggerDefinitionsMap)).collect(Collectors.toMap(key -> key.get("name"), value -> value)));
                    swaggerDefinitionsMap.put(actiondocMeta.getFormTypeDocMeta().getTypeName(), schema);
                    swaggerParameterMap.put("schema", DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)("#/definitions/" + actiondocMeta.getFormTypeDocMeta().getTypeName())));
                    parameterMapList.add(swaggerParameterMap);
                }
            }
            swaggerHttpMethodMap.put("parameters", parameterMapList);
            swaggerHttpMethodMap.put("tags", Arrays.asList(DfStringUtil.substringFirstFront((String)actiondocMeta.getUrl().replaceAll("^/", ""), (String[])new String[]{"/"})));
            swaggerTagList.add(DfCollectionUtil.newLinkedHashMap((Object)"name", (Object)DfStringUtil.substringFirstFront((String)actiondocMeta.getUrl().replaceAll("^/", ""), (String[])new String[]{"/"})));
            LinkedHashMap responseMap = DfCollectionUtil.newLinkedHashMap();
            swaggerHttpMethodMap.put("responses", responseMap);
            swaggerHttpMethodMap.put("produces", Arrays.asList("application/json"));
            schema = DfCollectionUtil.newLinkedHashMap();
            schema.put("type", "object");
            schema.put("properties", actiondocMeta.getReturnTypeDocMeta().getNestTypeDocMetaList().stream().map(typeDocMeta -> this.createSwaggerParameterMap((TypeDocMeta)typeDocMeta, swaggerDefinitionsMap)).collect(Collectors.toMap(key -> key.get("name"), value -> value)));
            swaggerDefinitionsMap.put(actiondocMeta.getReturnTypeDocMeta().getTypeName(), schema);
            responseMap.put("200", DfCollectionUtil.newLinkedHashMap((Object)"description", (Object)"success", (Object)"schema", (Object)DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)("#/definitions/" + actiondocMeta.getReturnTypeDocMeta().getTypeName()))));
            responseMap.put("400", DfCollectionUtil.newLinkedHashMap((Object)"description", (Object)"client error"));
        });
    }

    protected Map<String, Object> createSwaggerParameterMap(TypeDocMeta typeDocMeta, Map<String, Map<String, Object>> definitionsMap) {
        Map<Class<?>, Tuple3<String, String, Function<Object, Object>>> typeMap = this.createTypeMap();
        LinkedHashMap swaggerParameterMap = DfCollectionUtil.newLinkedHashMap();
        swaggerParameterMap.put("name", typeDocMeta.getName());
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)typeDocMeta.getDescription())) {
            swaggerParameterMap.put("description", typeDocMeta.getDescription());
        }
        swaggerParameterMap.put("required", typeDocMeta.getAnnotationTypeList().stream().anyMatch(annotationType -> annotationType instanceof Required));
        if (typeMap.containsKey(typeDocMeta.getType())) {
            Tuple3<String, String, Function<Object, Object>> swaggerType = typeMap.get(typeDocMeta.getType());
            swaggerParameterMap.put("type", swaggerType.getValue1());
            String format = (String)swaggerType.getValue2();
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)format)) {
                swaggerParameterMap.put("format", format);
            }
        } else if (Iterable.class.isAssignableFrom(typeDocMeta.getType())) {
            swaggerParameterMap.put("type", "array");
            if (!typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
                String definition = this.putDefinition(definitionsMap, typeDocMeta);
                swaggerParameterMap.put("items", DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)definition));
            } else {
                Tuple3<String, String, Function<Object, Object>> swaggerType;
                LinkedHashMap items = DfCollectionUtil.newLinkedHashMap();
                Class<?> genericType = typeDocMeta.getGenericType();
                if (genericType != null && (swaggerType = typeMap.get(genericType)) != null) {
                    items.put("type", swaggerType.getValue1());
                    String format = (String)swaggerType.getValue2();
                    if (DfStringUtil.is_NotNull_and_NotEmpty((String)format)) {
                        items.put("format", format);
                    }
                }
                if (!items.containsKey("type")) {
                    items.put("type", "string");
                }
                swaggerParameterMap.put("items", items);
            }
        } else if (Map.class.isAssignableFrom(typeDocMeta.getType())) {
            swaggerParameterMap.put("type", "object");
        } else if (!typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
            String definition = this.putDefinition(definitionsMap, typeDocMeta);
            swaggerParameterMap.put("schema", DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)definition));
        } else {
            swaggerParameterMap.put("type", "string");
            try {
                Class clazz = DfReflectionUtil.forName((String)typeDocMeta.getTypeName());
                if (Enum.class.isAssignableFrom(clazz)) {
                    swaggerParameterMap.put("enum", this.buildEnumValueList(clazz));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        typeDocMeta.getAnnotationTypeList().forEach(annotation -> {
            if (annotation instanceof Size) {
                Size size = (Size)annotation;
                swaggerParameterMap.put("minimum", size.min());
                swaggerParameterMap.put("maximum", size.max());
            }
            if (annotation instanceof Length) {
                Length length = (Length)annotation;
                swaggerParameterMap.put("minLength", length.min());
                swaggerParameterMap.put("maxLength", length.max());
            }
        });
        this.deriveDefaultValue(typeDocMeta).ifPresent(defaultValue -> swaggerParameterMap.put("default", defaultValue));
        return swaggerParameterMap;
    }

    protected String putDefinition(Map<String, Map<String, Object>> definitionsMap, TypeDocMeta typeDocMeta) {
        LinkedHashMap schema = DfCollectionUtil.newLinkedHashMap();
        schema.put("type", "object");
        schema.put("properties", typeDocMeta.getNestTypeDocMetaList().stream().map(nestTypeDocMeta -> this.createSwaggerParameterMap((TypeDocMeta)nestTypeDocMeta, definitionsMap)).collect(Collectors.toMap(key -> key.get("name"), value -> value)));
        definitionsMap.put(typeDocMeta.getTypeName(), schema);
        return "#/definitions/" + typeDocMeta.getTypeName();
    }

    protected Map<Class<?>, Tuple3<String, String, Function<Object, Object>>> createTypeMap() {
        LinkedHashMap typeMap = DfCollectionUtil.newLinkedHashMap();
        typeMap.put(Integer.class, Tuple3.tuple3((Object)"integer", (Object)"int32", value -> DfTypeUtil.toInteger((Object)value)));
        typeMap.put(Long.class, Tuple3.tuple3((Object)"integer", (Object)"int64", value -> DfTypeUtil.toLong((Object)value)));
        typeMap.put(Float.class, Tuple3.tuple3((Object)"integer", (Object)"float", value -> DfTypeUtil.toFloat((Object)value)));
        typeMap.put(Double.class, Tuple3.tuple3((Object)"integer", (Object)"double", value -> DfTypeUtil.toDouble((Object)value)));
        typeMap.put(String.class, Tuple3.tuple3((Object)"string", null, value -> value));
        typeMap.put(byte[].class, Tuple3.tuple3((Object)"string", (Object)"byte", value -> value));
        typeMap.put(Boolean.class, Tuple3.tuple3((Object)"boolean", null, value -> DfTypeUtil.toBoolean((Object)value)));
        TimeManager timeManager = this.getTimeManager();
        LocalDate currentDate = timeManager.currentDate();
        typeMap.put(LocalDate.class, Tuple3.tuple3((Object)"string", (Object)"date", value -> value == null ? this.getLocalDateFormatter().format(currentDate) : value));
        typeMap.put(LocalDateTime.class, Tuple3.tuple3((Object)"string", (Object)"date-time", value -> value == null ? this.getLocalDateTimeFormatter().format(currentDate.atStartOfDay()) : value));
        typeMap.put(Integer.TYPE, Tuple3.tuple3((Object)"integer", (Object)"int32", value -> DfTypeUtil.toInteger((Object)value)));
        typeMap.put(Long.TYPE, Tuple3.tuple3((Object)"integer", (Object)"int64", value -> DfTypeUtil.toLong((Object)value)));
        typeMap.put(Float.TYPE, Tuple3.tuple3((Object)"integer", (Object)"float", value -> DfTypeUtil.toFloat((Object)value)));
        typeMap.put(Double.TYPE, Tuple3.tuple3((Object)"integer", (Object)"double", value -> DfTypeUtil.toDouble((Object)value)));
        return typeMap;
    }

    protected List<String> buildEnumValueList(Class<?> typeClass) {
        List<String> valueList;
        if (Classification.class.isAssignableFrom(typeClass)) {
            Class<?> clsType = typeClass;
            valueList = Arrays.stream(clsType.getEnumConstants()).map(constant -> constant.code()).collect(Collectors.toList());
        } else {
            Enum[] constants = (Enum[])typeClass.getEnumConstants();
            valueList = Arrays.stream(constants).map(constant -> constants.toString()).collect(Collectors.toList());
        }
        return valueList;
    }

    protected void adaptHeaderParameters(Map<String, Object> swaggerMap, List<Map<String, Object>> headerParameterList) {
        if (headerParameterList.isEmpty()) {
            return;
        }
        Object paths = swaggerMap.get("paths");
        if (!(paths instanceof Map)) {
            return;
        }
        Map pathMap = (Map)paths;
        pathMap.forEach((path, pathData) -> {
            if (!(pathData instanceof Map)) {
                return;
            }
            Map pathDataMap = (Map)pathData;
            headerParameterList.forEach(headerParameter -> {
                Object parameters;
                if (!pathDataMap.containsKey("parameters")) {
                    pathDataMap.put("parameters", DfCollectionUtil.newArrayList());
                }
                if ((parameters = pathDataMap.get("parameters")) instanceof List) {
                    List parameterList = (List)parameters;
                    parameterList.add(headerParameter);
                }
            });
        });
    }

    protected void adaptSecurityDefinitions(Map<String, Object> swaggerMap, List<Map<String, Object>> securityDefinitionList) {
        LinkedHashMap securityDefinitions = DfCollectionUtil.newLinkedHashMap();
        LinkedHashMap security = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("securityDefinitions", securityDefinitions);
        swaggerMap.put("security", security);
        securityDefinitionList.forEach(securityDefinition -> {
            securityDefinitions.put(securityDefinition.get("name"), securityDefinition);
            security.put(securityDefinition.get("name"), Arrays.asList(new Object[0]));
        });
    }

    protected DocumentGenerator createDocumentGenerator() {
        return new DocumentGenerator();
    }

    protected ActionDocumentGenerator createActionDocumentGenerator() {
        return this.createDocumentGenerator().createActionDocumentGenerator();
    }

    protected OptionalThing<String> prepareApplicationVersion() {
        return OptionalThing.empty();
    }

    protected DateTimeFormatter getLocalDateFormatter() {
        JsonManager jsonManager = this.getJsonManager();
        OptionalThing localDateFormatter = jsonManager instanceof SimpleJsonManager ? LaDocReflectionUtil.getNoException(() -> ((SimpleJsonManager)jsonManager).getJsonMappingOption().flatMap(jsonMappingOption -> jsonMappingOption.getLocalDateFormatter())) : OptionalThing.empty();
        return (DateTimeFormatter)localDateFormatter.orElseGet(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    protected DateTimeFormatter getLocalDateTimeFormatter() {
        JsonManager jsonManager = this.getJsonManager();
        OptionalThing localDateTimeFormatter = jsonManager instanceof SimpleJsonManager ? LaDocReflectionUtil.getNoException(() -> ((SimpleJsonManager)jsonManager).getJsonMappingOption().flatMap(jsonMappingOption -> jsonMappingOption.getLocalDateTimeFormatter())) : OptionalThing.empty();
        return (DateTimeFormatter)localDateTimeFormatter.orElseGet(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    }

    protected OptionalThing<Object> deriveDefaultValue(TypeDocMeta typeDocMeta) {
        Map<Class<?>, Tuple3<String, String, Function<Object, Object>>> typeMap = this.createTypeMap();
        if (typeMap.containsKey(typeDocMeta.getType())) {
            Tuple3<String, String, Function<Object, Object>> swaggerType = typeMap.get(typeDocMeta.getType());
            Object defaultValue = ((Function)swaggerType.getValue3()).apply(this.deriveDefaultValueByComment(typeDocMeta.getComment()));
            if (defaultValue != null) {
                return OptionalThing.of(defaultValue);
            }
        } else if (Iterable.class.isAssignableFrom(typeDocMeta.getType()) && typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
            Tuple3<String, String, Function<Object, Object>> swaggerType;
            Object defaultValue = this.deriveDefaultValueByComment(typeDocMeta.getComment());
            if (!(defaultValue instanceof List)) {
                return OptionalThing.empty();
            }
            List defaultValueList = (List)defaultValue;
            Class<Object> genericType = typeDocMeta.getGenericType();
            if (genericType == null) {
                genericType = String.class;
            }
            if ((swaggerType = typeMap.get(genericType)) != null) {
                return OptionalThing.of(defaultValueList.stream().map(value -> ((Function)swaggerType.getValue3()).apply(value)).collect(Collectors.toList()));
            }
        }
        return OptionalThing.empty();
    }

    protected Object deriveDefaultValueByComment(String comment) {
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
            if (comment.contains("e.g. \"")) {
                return DfStringUtil.substringFirstFront((String)DfStringUtil.substringFirstRear((String)comment, (String[])new String[]{"e.g. \""}), (String[])new String[]{"\""});
            }
            if (comment.contains("e.g. [")) {
                String defaultValue = DfStringUtil.substringFirstFront((String)DfStringUtil.substringFirstRear((String)comment, (String[])new String[]{"e.g. ["}), (String[])new String[]{"]"});
                return Arrays.stream(defaultValue.split(", *")).map(value -> {
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        return value.substring(1, value.length() - 1);
                    }
                    return value;
                }).collect(Collectors.toList());
            }
            Pattern pattern = Pattern.compile(" e\\.g\\. ([^ ]+)");
            Matcher matcher = pattern.matcher(comment);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    protected GsonJsonEngine createJsonParser() {
        return new DocumentGenerator().createJsonParser();
    }

    protected String getLastaDocDir() {
        return new DocumentGenerator().getLastaDocDir();
    }

    protected AccessibleConfig getAccessibleConfig() {
        return (AccessibleConfig)ContainerUtil.getComponent(AccessibleConfig.class);
    }

    protected TimeManager getTimeManager() {
        return (TimeManager)ContainerUtil.getComponent(TimeManager.class);
    }

    protected JsonManager getJsonManager() {
        return (JsonManager)ContainerUtil.getComponent(JsonManager.class);
    }
}

