/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;

public class SwaggerOption {
    protected Function<String, String> basePathLamda = null;
    protected List<Map<String, Object>> headerParameterList = null;
    protected List<Map<String, Object>> securityDefinitionList = null;

    public void derivedBasePath(Function<String, String> basePathLamda) {
        this.basePathLamda = basePathLamda;
    }

    public void addHeaderParameter(String name, String value) {
        if (this.headerParameterList == null) {
            this.headerParameterList = DfCollectionUtil.newArrayList();
        }
        this.headerParameterList.add(this.createHeaderParameterMap(name, value));
    }

    public void addHeaderParameter(String name, String value, Consumer<SwaggerHeaderParameterResource> resourceLambda) {
        Map<String, Object> parameterMap = this.createHeaderParameterMap(name, value);
        resourceLambda.accept(new SwaggerHeaderParameterResource(parameterMap));
        if (this.headerParameterList == null) {
            this.headerParameterList = DfCollectionUtil.newArrayList();
        }
        this.headerParameterList.add(parameterMap);
    }

    protected Map<String, Object> createHeaderParameterMap(String name, String value) {
        LinkedHashMap parameterMap = DfCollectionUtil.newLinkedHashMap();
        parameterMap.put("in", "header");
        parameterMap.put("type", "string");
        parameterMap.put("required", true);
        parameterMap.put("name", name);
        parameterMap.put("default", value);
        return parameterMap;
    }

    public void addSecurityDefinition(String name) {
        if (this.securityDefinitionList == null) {
            this.securityDefinitionList = DfCollectionUtil.newArrayList();
        }
        this.securityDefinitionList.add(this.createSecurityDefinitionMap(name));
    }

    public void addSecurityDefinition(String name, Consumer<SwaggerSecurityDefinitionResource> resourceLambda) {
        Map<String, Object> definitionMap = this.createSecurityDefinitionMap(name);
        resourceLambda.accept(new SwaggerSecurityDefinitionResource(definitionMap));
        if (this.securityDefinitionList == null) {
            this.securityDefinitionList = DfCollectionUtil.newArrayList();
        }
        this.securityDefinitionList.add(definitionMap);
    }

    protected Map<String, Object> createSecurityDefinitionMap(String name) {
        LinkedHashMap definitionMap = DfCollectionUtil.newLinkedHashMap();
        definitionMap.put("in", "header");
        definitionMap.put("type", "apiKey");
        definitionMap.put("name", name);
        return definitionMap;
    }

    public OptionalThing<Function<String, String>> getDerivedBasePath() {
        return OptionalThing.ofNullable(this.basePathLamda, () -> {
            throw new IllegalStateException("Not set derivedBasePathLamda.");
        });
    }

    public OptionalThing<List<Map<String, Object>>> getHeaderParameterList() {
        return OptionalThing.ofNullable(this.headerParameterList, () -> {
            throw new IllegalStateException("Not set headerParameterList.");
        });
    }

    public OptionalThing<List<Map<String, Object>>> getSecurityDefinitionList() {
        return OptionalThing.ofNullable(this.securityDefinitionList, () -> {
            throw new IllegalStateException("Not set securityDefinitionList.");
        });
    }

    public static class SwaggerSecurityDefinitionResource {
        protected final Map<String, Object> securityDefinitionMap;

        public SwaggerSecurityDefinitionResource(Map<String, Object> securityDefinitionMap) {
            this.securityDefinitionMap = securityDefinitionMap;
        }

        public void registerAttribute(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("The argument 'key' should not be null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("The argument 'value' should not be null.");
            }
            if (key.equalsIgnoreCase("name")) {
                throw new IllegalArgumentException("Cannot add '" + key + "' key here: " + key + ", " + value);
            }
            this.securityDefinitionMap.put(key, value);
        }
    }

    public static class SwaggerHeaderParameterResource {
        protected final Map<String, Object> headerParameterMap;

        public SwaggerHeaderParameterResource(Map<String, Object> headerParameterMap) {
            this.headerParameterMap = headerParameterMap;
        }

        public void registerAttribute(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("The argument 'key' should not be null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("The argument 'value' should not be null.");
            }
            if (key.equalsIgnoreCase("name") || key.equalsIgnoreCase("default")) {
                throw new IllegalArgumentException("Cannot add '" + key + "' key here: " + key + ", " + value);
            }
            this.headerParameterMap.put(key, value);
        }
    }
}

