/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.generator;

import com.google.gson.FieldNamingPolicy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.dbflute.jdbc.Classification;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.core.json.JsonManager;
import org.lastaflute.core.json.JsonMappingOption;
import org.lastaflute.core.json.SimpleJsonManager;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.doc.generator.BaseDocumentGenerator;
import org.lastaflute.doc.meta.ActionDocMeta;
import org.lastaflute.doc.meta.TypeDocMeta;
import org.lastaflute.doc.reflector.SourceParserReflector;
import org.lastaflute.doc.util.LaDocReflectionUtil;
import org.lastaflute.web.Execute;
import org.lastaflute.web.UrlChain;
import org.lastaflute.web.path.ActionPathResolver;
import org.lastaflute.web.response.JsonResponse;
import org.lastaflute.web.ruts.config.ActionExecute;
import org.lastaflute.web.ruts.config.ActionFormMeta;
import org.lastaflute.web.ruts.config.ModuleConfig;
import org.lastaflute.web.util.LaModuleConfigUtil;

public class ActionDocumentGenerator
extends BaseDocumentGenerator {
    protected static final Set<String> SUPPRESSED_FIELD_SET = DfCollectionUtil.newHashSet((Object[])new String[]{"$jacocoData"});
    protected final List<String> srcDirList;
    protected int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;

    public ActionDocumentGenerator(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        this.srcDirList = srcDirList;
        this.depth = depth;
        this.sourceParserReflector = sourceParserReflector;
    }

    public List<ActionDocMeta> generateActionDocMetaList() {
        List<String> actionComponentNameList = this.findActionComponentNameList();
        ArrayList metaList = DfCollectionUtil.newArrayList();
        ModuleConfig moduleConfig = LaModuleConfigUtil.getModuleConfig();
        actionComponentNameList.forEach(componentName -> moduleConfig.findActionMapping(componentName).alwaysPresent(actionMapping -> {
            Class actionClass = actionMapping.getActionDef().getComponentClass();
            ArrayList methodList = DfCollectionUtil.newArrayList();
            this.sourceParserReflector.ifPresent(sourceParserReflector -> methodList.addAll(sourceParserReflector.getMethodListOrderByDefinition(actionClass)));
            if (methodList.isEmpty()) {
                methodList.addAll(Arrays.stream(actionClass.getMethods()).sorted(Comparator.comparing(method -> method.getName())).collect(Collectors.toList()));
            }
            methodList.forEach(method -> {
                ActionExecute actionExecute;
                if (method.getAnnotation(Execute.class) != null && (actionExecute = actionMapping.getActionExecute(method)) != null && !this.suppressActionExecute(actionExecute)) {
                    metaList.add(this.createActionDocMeta(actionMapping.getActionExecute(method)));
                }
            });
        }));
        return metaList;
    }

    protected boolean suppressActionExecute(ActionExecute actionExecute) {
        return false;
    }

    protected List<String> findActionComponentNameList() {
        ArrayList componentNameList = DfCollectionUtil.newArrayList();
        LaContainer container = SingletonLaContainerFactory.getContainer().getRoot();
        this.srcDirList.forEach(srcDir -> {
            if (Paths.get(srcDir, new String[0]).toFile().exists()) {
                try (Stream<Path> stream = Files.find(Paths.get(srcDir, new String[0]), Integer.MAX_VALUE, (path, attr) -> path.toString().endsWith("Action.java"), new FileVisitOption[0]);){
                    stream.forEach(path -> {
                        Class clazz;
                        String className = DfStringUtil.substringFirstRear((String)path.toFile().getAbsolutePath(), (String[])new String[]{new File((String)srcDir).getAbsolutePath()});
                        if (className.startsWith(File.separator)) {
                            className = className.substring(1);
                        }
                        if ((clazz = DfReflectionUtil.forName((String)(className = DfStringUtil.substringLastFront((String)className, (String[])new String[]{".java"}).replace(File.separatorChar, '.')))).isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                            return;
                        }
                        String componentName = container.getComponentDef((Object)clazz).getComponentName();
                        if (componentName != null && !componentNameList.contains(componentName)) {
                            componentNameList.add(componentName);
                        }
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to find the components: " + srcDir, e);
                }
            }
        });
        IntStream.range(0, container.getComponentDefSize()).forEach(index -> {
            ComponentDef componentDef = container.getComponentDef(index);
            String componentName = componentDef.getComponentName();
            if (componentName.endsWith("Action") && !componentNameList.contains(componentName)) {
                componentNameList.add(componentDef.getComponentName());
            }
        });
        return componentNameList;
    }

    protected ActionDocMeta createActionDocMeta(ActionExecute execute) {
        Class componentClass = execute.getActionMapping().getActionDef().getComponentClass();
        ActionDocMeta actionDocMeta = new ActionDocMeta();
        UrlChain urlChain = new UrlChain((Object)componentClass);
        String urlPattern = execute.getPreparedUrlPattern().getResolvedUrlPattern();
        if (!"index".equals(urlPattern)) {
            urlChain.moreUrl(new Object[]{urlPattern});
        }
        actionDocMeta.setUrl(this.getActionPathResolver().toActionUrl(componentClass, urlChain));
        Method method = execute.getExecuteMethod();
        actionDocMeta.setType(method.getDeclaringClass());
        actionDocMeta.setTypeName(this.adjustTypeName(method.getDeclaringClass()));
        actionDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(method.getDeclaringClass()));
        actionDocMeta.setFieldTypeDocMetaList(Arrays.stream(method.getDeclaringClass().getDeclaredFields()).map(field -> {
            TypeDocMeta typeDocMeta = new TypeDocMeta();
            typeDocMeta.setName(field.getName());
            typeDocMeta.setType(field.getType());
            typeDocMeta.setTypeName(this.adjustTypeName(field.getGenericType()));
            typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(field.getGenericType()));
            typeDocMeta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
            typeDocMeta.setAnnotationList(this.analyzeAnnotationList(typeDocMeta.getAnnotationTypeList()));
            this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(typeDocMeta, field.getType()));
            return typeDocMeta;
        }).collect(Collectors.toList()));
        actionDocMeta.setMethodName(method.getName());
        ArrayList annotationList = DfCollectionUtil.newArrayList();
        annotationList.addAll(Arrays.asList(method.getDeclaringClass().getAnnotations()));
        annotationList.addAll(Arrays.asList(method.getAnnotations()));
        actionDocMeta.setAnnotationTypeList(annotationList);
        actionDocMeta.setAnnotationList(this.analyzeAnnotationList(annotationList));
        List<TypeDocMeta> parameterTypeDocMetaList = Arrays.stream(method.getParameters()).filter(parameter -> !execute.getFormMeta().isPresent() || !((ActionFormMeta)execute.getFormMeta().get()).getFormType().equals(parameter.getType())).map(parameter -> {
            StringBuilder builder = new StringBuilder();
            builder.append("{").append(parameter.getName()).append("}");
            actionDocMeta.setUrl(actionDocMeta.getUrl().replaceFirst("\\{\\}", builder.toString()));
            TypeDocMeta typeDocMeta = new TypeDocMeta();
            typeDocMeta.setName(parameter.getName());
            typeDocMeta.setType(parameter.getType());
            if (OptionalThing.class.isAssignableFrom(parameter.getType())) {
                typeDocMeta.setGenericType(DfReflectionUtil.getGenericFirstClass((Type)parameter.getParameterizedType()));
            }
            typeDocMeta.setTypeName(this.adjustTypeName(parameter.getParameterizedType()));
            typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(parameter.getParameterizedType()));
            typeDocMeta.setNestTypeDocMetaList(Collections.emptyList());
            typeDocMeta.setAnnotationTypeList(Arrays.asList(parameter.getAnnotatedType().getAnnotations()));
            typeDocMeta.setAnnotationList(this.analyzeAnnotationList(typeDocMeta.getAnnotationTypeList()));
            this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(typeDocMeta, parameter.getType()));
            return typeDocMeta;
        }).collect(Collectors.toList());
        actionDocMeta.setParameterTypeDocMetaList(parameterTypeDocMetaList);
        execute.getFormMeta().ifPresent(actionFormMeta -> actionDocMeta.setFormTypeDocMeta(this.analyzeFormClass((ActionFormMeta)actionFormMeta)));
        actionDocMeta.setReturnTypeDocMeta(this.analyzeReturnClass(method));
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(actionDocMeta, method));
        return actionDocMeta;
    }

    protected ActionPathResolver getActionPathResolver() {
        return (ActionPathResolver)ContainerUtil.getComponent(ActionPathResolver.class);
    }

    protected TypeDocMeta analyzeFormClass(ActionFormMeta actionFormMeta) {
        TypeDocMeta typeDocMeta = new TypeDocMeta();
        actionFormMeta.getListFormParameterParameterizedType().ifPresent(type -> {
            typeDocMeta.setType(actionFormMeta.getFormType());
            typeDocMeta.setTypeName(this.adjustTypeName((Type)type));
            typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName((Type)type));
        }).orElse(() -> {
            typeDocMeta.setType(actionFormMeta.getFormType());
            typeDocMeta.setTypeName(this.adjustTypeName(actionFormMeta.getFormType()));
            typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(actionFormMeta.getFormType()));
        });
        Class formType = (Class)actionFormMeta.getListFormParameterGenericType().orElse((Object)actionFormMeta.getFormType());
        typeDocMeta.setNestTypeDocMetaList(this.prepareTypeDocMetaList(formType, DfCollectionUtil.newLinkedHashMap(), this.depth));
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(typeDocMeta, formType));
        return typeDocMeta;
    }

    protected TypeDocMeta analyzeReturnClass(Method method) {
        TypeDocMeta returnTypeDocMeta = new TypeDocMeta();
        returnTypeDocMeta.setType(method.getReturnType());
        returnTypeDocMeta.setTypeName(this.adjustTypeName(method.getGenericReturnType()));
        returnTypeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(method.getGenericReturnType()));
        returnTypeDocMeta.setGenericType(DfReflectionUtil.getGenericFirstClass((Type)method.getGenericReturnType()));
        returnTypeDocMeta.setAnnotationTypeList(Arrays.asList(method.getAnnotatedReturnType().getAnnotations()));
        returnTypeDocMeta.setAnnotationList(this.analyzeAnnotationList(returnTypeDocMeta.getAnnotationTypeList()));
        Class returnClass = returnTypeDocMeta.getGenericType();
        if (returnClass != null) {
            LinkedHashMap genericParameterTypesMap = DfCollectionUtil.newLinkedHashMap();
            Type[] parameterTypes = DfReflectionUtil.getGenericParameterTypes((Type)method.getGenericReturnType());
            TypeVariable[] typeVariables = returnClass.getTypeParameters();
            IntStream.range(0, parameterTypes.length).forEach(parameterTypesIndex -> {
                Type[] genericParameterTypes = DfReflectionUtil.getGenericParameterTypes((Type)parameterTypes[parameterTypesIndex]);
                IntStream.range(0, typeVariables.length).forEach(typeVariablesIndex -> {
                    Type type = genericParameterTypes[typeVariablesIndex];
                    genericParameterTypesMap.put(typeVariables[typeVariablesIndex].getTypeName(), type);
                });
            });
            if (Iterable.class.isAssignableFrom(returnClass)) {
                String returnClassName = returnTypeDocMeta.getTypeName().replaceAll(JsonResponse.class.getSimpleName() + "<(.*)>", "$1");
                Matcher matcher = Pattern.compile(".+<([^,]+)>").matcher(returnClassName);
                if (matcher.matches()) {
                    returnClass = DfReflectionUtil.forName((String)matcher.group(1));
                }
            }
            List<Class<?>> nativeClassList = this.getNativeClassList();
            if (returnClass != null && !nativeClassList.contains(returnClass)) {
                List<TypeDocMeta> typeDocMeta = this.prepareTypeDocMetaList(returnClass, genericParameterTypesMap, this.depth);
                returnTypeDocMeta.setNestTypeDocMetaList(typeDocMeta);
            }
            if (this.sourceParserReflector.isPresent()) {
                ((SourceParserReflector)this.sourceParserReflector.get()).reflect(returnTypeDocMeta, returnClass);
            }
        }
        return returnTypeDocMeta;
    }

    protected List<Class<?>> getNativeClassList() {
        return Arrays.asList(Void.class, Integer.class, Long.class, Byte.class, String.class, Map.class);
    }

    protected List<TypeDocMeta> prepareTypeDocMetaList(Class<?> clazz, Map<String, Type> genericParameterTypesMap, int depth) {
        if (depth < 0) {
            return DfCollectionUtil.newArrayList();
        }
        LinkedHashSet fieldSet = DfCollectionUtil.newLinkedHashSet();
        for (Class<?> targetClazz = clazz; targetClazz != Object.class && targetClazz != null; targetClazz = targetClazz.getSuperclass()) {
            fieldSet.addAll(Arrays.asList(targetClazz.getDeclaredFields()));
        }
        return fieldSet.stream().filter(field -> !this.suppressField((Field)field)).map(field -> this.createTypeDocMeta(clazz, genericParameterTypesMap, depth, (Field)field)).collect(Collectors.toList());
    }

    protected boolean suppressField(Field field) {
        return SUPPRESSED_FIELD_SET.contains(field.getName()) || Modifier.isStatic(field.getModifiers());
    }

    protected TypeDocMeta createTypeDocMeta(Class<?> clazz, Map<String, Type> genericParameterTypesMap, int depth, Field field) {
        List<String> targetTypeSuffixNameList;
        Class typeClass;
        Type genericClass = genericParameterTypesMap.get(field.getGenericType().getTypeName());
        Class type = genericClass != null ? genericClass : field.getType();
        TypeDocMeta meta = new TypeDocMeta();
        meta.setName(field.getName());
        meta.setType(field.getType());
        meta.setTypeName(this.adjustTypeName(type));
        meta.setSimpleTypeName(this.adjustSimpleTypeName(type));
        meta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
        meta.setAnnotationList(this.analyzeAnnotationList(meta.getAnnotationTypeList()));
        Class clazz2 = typeClass = type instanceof Class ? type : (Class)DfReflectionUtil.getGenericParameterTypes(type)[0];
        if (typeClass.isEnum()) {
            meta.setValue(this.buildEnumValuesExp(typeClass));
        }
        if ((targetTypeSuffixNameList = this.getTargetTypeSuffixNameList()).stream().anyMatch(suffix -> typeClass.getName().contains((CharSequence)suffix))) {
            meta.setNestTypeDocMetaList(this.prepareTypeDocMetaList(typeClass, genericParameterTypesMap, depth - 1));
        } else if (targetTypeSuffixNameList.stream().anyMatch(suffix -> field.getGenericType().getTypeName().contains((CharSequence)suffix))) {
            Class typeArgumentClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            meta.setNestTypeDocMetaList(this.prepareTypeDocMetaList(typeArgumentClass, genericParameterTypesMap, depth - 1));
            String typeName = meta.getTypeName();
            meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustTypeName(typeArgumentClass) + ">");
            meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(typeArgumentClass) + ">");
        } else if (field.getGenericType().getTypeName().matches(".*<(.*)>")) {
            String genericTypeName = field.getGenericType().getTypeName().replaceAll(".*<(.*)>", "$1");
            try {
                meta.setGenericType(DfReflectionUtil.forName((String)genericTypeName));
            }
            catch (DfReflectionUtil.ReflectionFailureException e) {
                meta.setGenericType(Object.class);
            }
            genericClass = genericParameterTypesMap.get(genericTypeName);
            if (genericClass != null) {
                meta.setNestTypeDocMetaList(this.prepareTypeDocMetaList((Class<?>)genericClass, genericParameterTypesMap, depth - 1));
                String typeName = meta.getTypeName();
                meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustTypeName(genericClass) + ">");
                meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericClass) + ">");
            } else {
                String typeName = meta.getTypeName();
                meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericTypeName) + ">");
                meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericTypeName) + ">");
            }
        }
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(meta, clazz));
        meta.setName(this.adjustFieldName(clazz, field));
        return meta;
    }

    protected String adjustFieldName(Class<?> clazz, Field field) {
        if (clazz.getSimpleName().endsWith("Form")) {
            return field.getName();
        }
        JsonManager jsonManager = (JsonManager)ContainerUtil.getComponent(JsonManager.class);
        if (!(jsonManager instanceof SimpleJsonManager)) {
            return field.getName();
        }
        String fieldName = LaDocReflectionUtil.getNoException(() -> (String)((SimpleJsonManager)jsonManager).getJsonMappingOption().flatMap(jsonMappingOption -> jsonMappingOption.getFieldNaming().map(naming -> {
            if (naming == JsonMappingOption.JsonFieldNaming.IDENTITY) {
                return FieldNamingPolicy.IDENTITY.translateName(field);
            }
            if (naming == JsonMappingOption.JsonFieldNaming.CAMEL_TO_LOWER_SNAKE) {
                return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES.translateName(field);
            }
            return field.getName();
        })).orElse(null));
        return fieldName != null ? fieldName : field.getName();
    }

    protected String buildEnumValuesExp(Class<?> typeClass) {
        String valuesExp;
        if (Classification.class.isAssignableFrom(typeClass)) {
            Class<?> clsType = typeClass;
            valuesExp = Arrays.stream(clsType.getEnumConstants()).collect(Collectors.toMap(keyMapper -> keyMapper.code(), valueMapper -> valueMapper.alias(), (u, v) -> v, LinkedHashMap::new)).toString();
        } else {
            Enum[] constants = (Enum[])typeClass.getEnumConstants();
            valuesExp = Arrays.stream(constants).collect(Collectors.toList()).toString();
        }
        return valuesExp;
    }

    protected List<String> getTargetTypeSuffixNameList() {
        return DfCollectionUtil.newArrayList((Object[])new String[]{"Form", "Body", "Bean", "Result"});
    }

    public Map<String, Map<String, String>> generateActionPropertyNameMap(List<ActionDocMeta> actionDocMetaList) {
        Map propertyNameMap = actionDocMetaList.stream().collect(Collectors.toMap(key -> key.getUrl().replaceAll("\\{.*", "").replaceAll("/$", "").replaceAll("/", "_"), value -> this.convertPropertyNameMap("", value.getFormTypeDocMeta()), (u, v) -> v, LinkedHashMap::new));
        return propertyNameMap;
    }

    protected Map<String, String> convertPropertyNameMap(String parentName, TypeDocMeta typeDocMeta) {
        if (typeDocMeta == null) {
            return DfCollectionUtil.newLinkedHashMap();
        }
        LinkedHashMap propertyNameMap = DfCollectionUtil.newLinkedHashMap();
        String name = this.calculateName(parentName, typeDocMeta.getName(), typeDocMeta.getTypeName());
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)name)) {
            propertyNameMap.put(name, "");
        }
        if (typeDocMeta.getNestTypeDocMetaList() != null) {
            typeDocMeta.getNestTypeDocMetaList().forEach(nestDocMeta -> propertyNameMap.putAll(this.convertPropertyNameMap(name, (TypeDocMeta)nestDocMeta)));
        }
        return propertyNameMap;
    }

    protected String calculateName(String parentName, String name, String type) {
        if (DfStringUtil.is_Null_or_Empty((String)name)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)parentName)) {
            builder.append(parentName + ".");
        }
        builder.append(name);
        if (name.endsWith("List")) {
            builder.append("[]");
        }
        return builder.toString();
    }
}

