/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.generator;

import java.io.File;
import java.util.List;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.core.json.JsonManager;
import org.lastaflute.core.json.JsonMappingOption;
import org.lastaflute.core.json.SimpleJsonManager;
import org.lastaflute.core.json.engine.GsonJsonEngine;
import org.lastaflute.core.json.engine.RealJsonEngine;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.doc.generator.ActionDocumentGenerator;
import org.lastaflute.doc.generator.JobDocumentGenerator;
import org.lastaflute.doc.reflector.SourceParserReflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentGeneratorFactory {
    private static final Logger _log = LoggerFactory.getLogger(DocumentGeneratorFactory.class);
    private static final String JOB_MANAGER_CLASS_NAME = "org.lastaflute.job.JobManager";

    public ActionDocumentGenerator createActionDocumentGenerator(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        return new ActionDocumentGenerator(srcDirList, depth, sourceParserReflector);
    }

    public OptionalThing<JobDocumentGenerator> createJobDocumentGenerator(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        JobDocumentGenerator generator;
        String className = JOB_MANAGER_CLASS_NAME;
        try {
            DfReflectionUtil.forName((String)JOB_MANAGER_CLASS_NAME);
            _log.debug("...Loading lasta job for document: {}", (Object)JOB_MANAGER_CLASS_NAME);
            generator = new JobDocumentGenerator(srcDirList, depth, sourceParserReflector);
        }
        catch (DfReflectionUtil.ReflectionFailureException ignored) {
            generator = null;
        }
        return OptionalThing.ofNullable(generator, () -> {
            throw new IllegalStateException("Not found the lasta job: org.lastaflute.job.JobManager");
        });
    }

    public String getLastaDocDir() {
        if (new File("./pom.xml").exists()) {
            return "./target/lastadoc/";
        }
        return "./build/lastadoc/";
    }

    public RealJsonEngine createJsonEngine() {
        return new GsonJsonEngine(builder -> builder.serializeNulls().setPrettyPrinting(), op -> {});
    }

    public OptionalThing<JsonMappingOption> getApplicationJsonMappingOption() {
        JsonManager jsonManager = (JsonManager)ContainerUtil.getComponent(JsonManager.class);
        if (jsonManager instanceof SimpleJsonManager) {
            return ((SimpleJsonManager)jsonManager).getJsonMappingOption();
        }
        return OptionalThing.empty();
    }
}

