/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dbflute.jdbc.Classification;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfStringUtil;
import org.dbflute.util.DfTypeUtil;
import org.hibernate.validator.constraints.Length;
import org.lastaflute.core.direction.AccessibleConfig;
import org.lastaflute.core.json.JsonMappingOption;
import org.lastaflute.core.json.annotation.JsonDatePattern;
import org.lastaflute.core.json.engine.RealJsonEngine;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.di.helper.misc.ParameterizedRef;
import org.lastaflute.di.util.tiger.Tuple3;
import org.lastaflute.doc.DocumentGenerator;
import org.lastaflute.doc.SwaggerOption;
import org.lastaflute.doc.agent.maven.MavenVersionFinder;
import org.lastaflute.doc.generator.ActionDocumentGenerator;
import org.lastaflute.doc.generator.DocumentGeneratorFactory;
import org.lastaflute.doc.meta.ActionDocMeta;
import org.lastaflute.doc.meta.TypeDocMeta;
import org.lastaflute.doc.web.LaActionSwaggerable;
import org.lastaflute.web.api.JsonParameter;
import org.lastaflute.web.response.ActionResponse;
import org.lastaflute.web.response.HtmlResponse;
import org.lastaflute.web.response.JsonResponse;
import org.lastaflute.web.response.StreamResponse;
import org.lastaflute.web.response.XmlResponse;
import org.lastaflute.web.ruts.multipart.MultipartFormFile;
import org.lastaflute.web.util.LaRequestUtil;
import org.lastaflute.web.validation.Required;

public class SwaggerGenerator {
    protected static final Pattern HTTP_METHOD_PATTERN = Pattern.compile("(.+)\\$.+");

    public Map<String, Object> generateSwaggerMap() {
        return this.generateSwaggerMap(op -> {});
    }

    public Map<String, Object> generateSwaggerMap(Consumer<SwaggerOption> opLambda) {
        OptionalThing<Map<String, Object>> swaggerJson = this.readSwaggerJson();
        if (swaggerJson.isPresent()) {
            Map swaggerMap = (Map)swaggerJson.get();
            swaggerMap.put("schemes", this.prepareSwaggerMapSchemes());
            return swaggerMap;
        }
        SwaggerOption swaggerOption = this.createSwaggerOption(opLambda);
        return this.createSwaggerMap(swaggerOption);
    }

    protected SwaggerOption createSwaggerOption(Consumer<SwaggerOption> opLambda) {
        SwaggerOption swaggerOption = new SwaggerOption();
        opLambda.accept(swaggerOption);
        return swaggerOption;
    }

    public void saveSwaggerMeta(LaActionSwaggerable swaggerable) {
        String json = this.createJsonEngine().toJson(swaggerable.json().getJsonResult());
        Path path = Paths.get(this.getLastaDocDir(), "swagger.json");
        Path parentPath = path.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory: " + parentPath, e);
            }
        }
        try (BufferedWriter bw = Files.newBufferedWriter(path, Charset.forName("UTF-8"), new OpenOption[0]);){
            bw.write(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write the json to the file: " + path, e);
        }
    }

    /*
     * Exception decompiling
     */
    protected OptionalThing<Map<String, Object>> readSwaggerJson() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Map<String, Object> createSwaggerMap(SwaggerOption swaggerOption) {
        LinkedHashMap swaggerMap = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("swagger", "2.0");
        swaggerMap.put("info", this.createSwaggerInfoMap());
        swaggerMap.put("schemes", this.prepareSwaggerMapSchemes());
        swaggerMap.put("basePath", this.derivedBasePath(swaggerOption));
        ArrayList swaggerTagList = DfCollectionUtil.newArrayList();
        swaggerMap.put("tags", swaggerTagList);
        swaggerOption.getSecurityDefinitionList().ifPresent(securityDefinitionList -> this.adaptSecurityDefinitions(swaggerMap, (List<Map<String, Object>>)securityDefinitionList));
        LinkedHashMap swaggerPathMap = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("paths", swaggerPathMap);
        LinkedHashMap swaggerDefinitionsMap = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("definitions", swaggerDefinitionsMap);
        this.setupSwaggerPathMap(swaggerPathMap, swaggerDefinitionsMap, swaggerTagList);
        swaggerOption.getHeaderParameterList().ifPresent(headerParameterList -> this.adaptHeaderParameters(swaggerMap, (List<Map<String, Object>>)headerParameterList));
        return swaggerMap;
    }

    protected Map<String, String> createSwaggerInfoMap() {
        LinkedHashMap swaggerInfoMap = DfCollectionUtil.newLinkedHashMap();
        String title = Objects.toString(this.getAccessibleConfig().get("domain.title"), this.getAccessibleConfig().get("domain.name"));
        swaggerInfoMap.put("title", title);
        swaggerInfoMap.put("description", this.derivedSwaggerInfoDescription(title));
        swaggerInfoMap.put("version", this.derivedSwaggerInfoVersion());
        return swaggerInfoMap;
    }

    protected String derivedSwaggerInfoDescription(String title) {
        StringBuilder description = new StringBuilder();
        description.append(title);
        description.append(". generated by lasta-doc");
        this.findLastaDocVersion().ifPresent(version -> {
            description.append("-");
            description.append((String)version);
            description.append(".");
        });
        return description.toString();
    }

    protected String derivedSwaggerInfoVersion() {
        return "1.0.0";
    }

    protected List<String> prepareSwaggerMapSchemes() {
        return Arrays.asList(this.getRequest().getScheme());
    }

    protected String derivedBasePath(SwaggerOption swaggerOption) {
        StringBuilder basePath = new StringBuilder();
        basePath.append(this.getRequest().getContextPath() + "/");
        this.prepareApplicationVersion().ifPresent(applicationVersion -> basePath.append(applicationVersion + "/"));
        return (String)swaggerOption.getDerivedBasePath().map(derivedBasePath -> (String)derivedBasePath.apply(basePath.toString())).orElse((Object)basePath.toString());
    }

    protected void setupSwaggerPathMap(Map<String, Map<String, Object>> swaggerPathMap, Map<String, Map<String, Object>> swaggerDefinitionsMap, List<Map<String, Object>> swaggerTagList) {
        this.createActionDocumentGenerator().generateActionDocMetaList().stream().forEach(actiondocMeta -> this.doSetupSwaggerPathMap(swaggerPathMap, swaggerDefinitionsMap, swaggerTagList, (ActionDocMeta)actiondocMeta));
    }

    protected void doSetupSwaggerPathMap(Map<String, Map<String, Object>> swaggerPathMap, Map<String, Map<String, Object>> swaggerDefinitionsMap, List<Map<String, Object>> swaggerTagList, ActionDocMeta actionDocMeta) {
        String actionUrl = actionDocMeta.getUrl();
        if (!swaggerPathMap.containsKey(actionUrl)) {
            LinkedHashMap swaggerUrlMap = DfCollectionUtil.newLinkedHashMap();
            swaggerPathMap.put(actionUrl, swaggerUrlMap);
        }
        String httpMethod = this.extractHttpMethod(actionDocMeta);
        LinkedHashMap swaggerHttpMethodMap = DfCollectionUtil.newLinkedHashMap();
        swaggerPathMap.get(actionUrl).put(httpMethod, swaggerHttpMethodMap);
        swaggerHttpMethodMap.put("summary", actionDocMeta.getDescription());
        swaggerHttpMethodMap.put("description", actionDocMeta.getDescription());
        ArrayList parameterMapList = DfCollectionUtil.newArrayList();
        ArrayList optionalPathNameList = DfCollectionUtil.newArrayList();
        parameterMapList.addAll(actionDocMeta.getParameterTypeDocMetaList().stream().map(typeDocMeta -> {
            Map<String, Object> parameterMap = this.toParameterMap((TypeDocMeta)typeDocMeta, swaggerDefinitionsMap);
            parameterMap.put("in", "path");
            if (parameterMap.containsKey("example")) {
                parameterMap.put("default", parameterMap.get("example"));
                parameterMap.remove("example");
            }
            parameterMap.put("required", true);
            if (OptionalThing.class.isAssignableFrom(typeDocMeta.getType())) {
                optionalPathNameList.add(typeDocMeta.getPublicName());
            }
            return parameterMap;
        }).collect(Collectors.toList()));
        if (actionDocMeta.getFormTypeDocMeta() != null) {
            if (actionDocMeta.getFormTypeDocMeta().getTypeName().endsWith("Form")) {
                parameterMapList.addAll(actionDocMeta.getFormTypeDocMeta().getNestTypeDocMetaList().stream().map(typeDocMeta -> {
                    Map<String, Object> parameterMap = this.toParameterMap((TypeDocMeta)typeDocMeta, swaggerDefinitionsMap);
                    if (parameterMap.containsKey("$ref")) {
                        parameterMap.remove("$ref");
                        parameterMap.put("type", "string");
                    }
                    if (parameterMap.containsKey("items")) {
                        Map items = (Map)parameterMap.get("items");
                        if (items.containsKey("$ref")) {
                            items.remove("$ref");
                            items.put("type", "string");
                        }
                        if ("object".equals(items.get("type"))) {
                            items.put("type", "string");
                        }
                    }
                    if ("object".equals(parameterMap.get("type"))) {
                        parameterMap.put("type", "string");
                    }
                    parameterMap.put("name", typeDocMeta.getPublicName());
                    parameterMap.put("in", Arrays.asList("get", "delete").contains(httpMethod) ? "query" : "formData");
                    if (parameterMap.containsKey("example")) {
                        parameterMap.put("default", parameterMap.get("example"));
                        parameterMap.remove("example");
                    }
                    parameterMap.put("required", typeDocMeta.getAnnotationTypeList().stream().anyMatch(annotationType -> this.getRequiredAnnotationList().stream().anyMatch(requiredAnnotation -> requiredAnnotation.isAssignableFrom(annotationType.getClass()))));
                    return parameterMap;
                }).collect(Collectors.toList()));
                if (parameterMapList.stream().anyMatch(parameterMap -> "formData".equals(parameterMap.get("in")))) {
                    if (parameterMapList.stream().anyMatch(parameterMap -> "file".equals(parameterMap.get("type")))) {
                        swaggerHttpMethodMap.put("consumes", Arrays.asList("multipart/form-data"));
                    } else {
                        swaggerHttpMethodMap.put("consumes", Arrays.asList("application/x-www-form-urlencoded"));
                    }
                }
            } else {
                swaggerHttpMethodMap.put("consumes", Arrays.asList("application/json"));
                LinkedHashMap parameterMap2 = DfCollectionUtil.newLinkedHashMap();
                parameterMap2.put("name", actionDocMeta.getFormTypeDocMeta().getSimpleTypeName());
                parameterMap2.put("in", "body");
                parameterMap2.put("required", true);
                LinkedHashMap schema = DfCollectionUtil.newLinkedHashMap();
                schema.put("type", "object");
                List<String> requiredPropertyNameList = this.derivedRequiredPropertyNameList(actionDocMeta.getFormTypeDocMeta());
                if (!requiredPropertyNameList.isEmpty()) {
                    schema.put("required", requiredPropertyNameList);
                }
                schema.put("properties", actionDocMeta.getFormTypeDocMeta().getNestTypeDocMetaList().stream().map(propertyDocMeta -> this.toParameterMap((TypeDocMeta)propertyDocMeta, swaggerDefinitionsMap)).collect(Collectors.toMap(key -> key.get("name"), value -> {
                    LinkedHashMap propertyMap = DfCollectionUtil.newLinkedHashMap((Map)value);
                    propertyMap.remove("name");
                    return propertyMap;
                }, (u, v) -> v, LinkedHashMap::new)));
                swaggerDefinitionsMap.put(this.derivedDefinitionName(actionDocMeta.getFormTypeDocMeta()), schema);
                LinkedHashMap schemaMap = DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)this.prepareSwaggerMapRefDefinitions(actionDocMeta));
                if (!Iterable.class.isAssignableFrom(actionDocMeta.getFormTypeDocMeta().getType())) {
                    parameterMap2.put("schema", schemaMap);
                } else {
                    parameterMap2.put("schema", DfCollectionUtil.newLinkedHashMap((Object)"type", (Object)"array", (Object)"items", (Object)schemaMap));
                }
                parameterMapList.add(parameterMap2);
            }
        }
        swaggerHttpMethodMap.put("parameters", parameterMapList);
        swaggerHttpMethodMap.put("tags", this.prepareSwaggerMapTags(actionDocMeta));
        String tag = DfStringUtil.substringFirstFront((String)actionUrl.replaceAll("^/", ""), (String[])new String[]{"/"});
        if (swaggerTagList.stream().noneMatch(swaggerTag -> swaggerTag.containsValue(tag))) {
            swaggerTagList.add(DfCollectionUtil.newLinkedHashMap((Object)"name", (Object)tag));
        }
        this.prepareSwaggerMapResponseMap(swaggerHttpMethodMap, actionDocMeta, swaggerDefinitionsMap);
        if (!optionalPathNameList.isEmpty()) {
            this.doSetupSwaggerPathMapForOptionalPath(swaggerPathMap, actionDocMeta, optionalPathNameList);
        }
    }

    protected void doSetupSwaggerPathMapForOptionalPath(Map<String, Map<String, Object>> swaggerPathMap, ActionDocMeta actionDocMeta, List<String> optionalPathNameList) {
        String actionUrl = actionDocMeta.getUrl();
        String httpMethod = this.extractHttpMethod(actionDocMeta);
        RealJsonEngine jsonEngine = this.createJsonEngine();
        String json = jsonEngine.toJson(swaggerPathMap.get(actionUrl).get(httpMethod));
        IntStream.range(0, optionalPathNameList.size()).forEach(index -> {
            List deleteOptionalPathNameList = optionalPathNameList.subList(index, optionalPathNameList.size());
            String deleteOptionalPathNameUrl = deleteOptionalPathNameList.stream().reduce(actionUrl, (aactionUrl, optionalPathName) -> aactionUrl.replaceAll("/\\{" + optionalPathName + "\\}", ""));
            if (!swaggerPathMap.containsKey(deleteOptionalPathNameUrl)) {
                swaggerPathMap.put(deleteOptionalPathNameUrl, DfCollectionUtil.newLinkedHashMap());
            }
            Map swaggerHttpMethodMap = (Map)jsonEngine.fromJsonParameteried(json, new ParameterizedRef<Map<String, Object>>(){}.getType());
            List parameterMapList = ((List)swaggerHttpMethodMap.get("parameters")).stream().filter(parameter -> !deleteOptionalPathNameList.contains(parameter.get("name"))).collect(Collectors.toList());
            swaggerHttpMethodMap.put("parameters", parameterMapList);
            ((Map)swaggerPathMap.get(deleteOptionalPathNameUrl)).put(httpMethod, swaggerHttpMethodMap);
        });
        Map<String, Object> swaggerUrlMap = swaggerPathMap.remove(actionUrl);
        swaggerPathMap.put(actionUrl, swaggerUrlMap);
    }

    protected String extractHttpMethod(ActionDocMeta actionDocMeta) {
        Matcher matcher = HTTP_METHOD_PATTERN.matcher(actionDocMeta.getMethodName());
        return matcher.find() ? matcher.group(1) : "post";
    }

    protected String prepareSwaggerMapRefDefinitions(ActionDocMeta actiondocMeta) {
        return "#/definitions/" + this.encode(this.derivedDefinitionName(actiondocMeta.getFormTypeDocMeta()));
    }

    protected List<String> prepareSwaggerMapTags(ActionDocMeta actiondocMeta) {
        return Arrays.asList(DfStringUtil.substringFirstFront((String)actiondocMeta.getUrl().replaceAll("^/", ""), (String[])new String[]{"/"}));
    }

    protected void prepareSwaggerMapResponseMap(Map<String, Object> swaggerHttpMethodMap, ActionDocMeta actiondocMeta, Map<String, Map<String, Object>> swaggerDefinitionsMap) {
        LinkedHashMap responseMap = DfCollectionUtil.newLinkedHashMap();
        swaggerHttpMethodMap.put("responses", responseMap);
        this.derivedProduces(actiondocMeta).ifPresent(produces -> swaggerHttpMethodMap.put("produces", produces));
        LinkedHashMap response = DfCollectionUtil.newLinkedHashMap((Object)"description", (Object)"success");
        TypeDocMeta returnTypeDocMeta = actiondocMeta.getReturnTypeDocMeta();
        if (!Arrays.asList(Void.TYPE, Void.class).contains(returnTypeDocMeta.getGenericType())) {
            Map<String, Object> parameterMap = this.toParameterMap(returnTypeDocMeta, swaggerDefinitionsMap);
            parameterMap.remove("name");
            parameterMap.remove("required");
            if (parameterMap.containsKey("schema")) {
                response.putAll(parameterMap);
            } else {
                response.put("schema", parameterMap);
            }
        }
        responseMap.put("200", response);
        responseMap.put("400", DfCollectionUtil.newLinkedHashMap((Object)"description", (Object)"client error"));
    }

    protected void adaptSecurityDefinitions(Map<String, Object> swaggerMap, List<Map<String, Object>> securityDefinitionList) {
        LinkedHashMap securityDefinitions = DfCollectionUtil.newLinkedHashMap();
        LinkedHashMap security = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("securityDefinitions", securityDefinitions);
        swaggerMap.put("security", security);
        securityDefinitionList.forEach(securityDefinition -> {
            securityDefinitions.put(securityDefinition.get("name"), securityDefinition);
            security.put(securityDefinition.get("name"), Arrays.asList(new Object[0]));
        });
    }

    protected void adaptHeaderParameters(Map<String, Object> swaggerMap, List<Map<String, Object>> headerParameterList) {
        if (headerParameterList.isEmpty()) {
            return;
        }
        Object paths = swaggerMap.get("paths");
        if (!(paths instanceof Map)) {
            return;
        }
        Map pathMap = (Map)paths;
        pathMap.forEach((path, pathData) -> {
            if (!(pathData instanceof Map)) {
                return;
            }
            Map pathDataMap = (Map)pathData;
            headerParameterList.forEach(headerParameter -> {
                Object parameters;
                if (!pathDataMap.containsKey("parameters")) {
                    pathDataMap.put("parameters", DfCollectionUtil.newArrayList());
                }
                if ((parameters = pathDataMap.get("parameters")) instanceof List) {
                    List parameterList = (List)parameters;
                    parameterList.add(headerParameter);
                }
            });
        });
    }

    protected Map<String, Object> toParameterMap(TypeDocMeta typeDocMeta, Map<String, Map<String, Object>> definitionsMap) {
        Map<Class<?>, Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>>> typeMap = this.createTypeMap();
        Class<?> keepType = typeDocMeta.getType();
        if (typeDocMeta.getGenericType() != null && (ActionResponse.class.isAssignableFrom(typeDocMeta.getType()) || OptionalThing.class.isAssignableFrom(typeDocMeta.getType()))) {
            typeDocMeta.setType(typeDocMeta.getGenericType());
        }
        LinkedHashMap parameterMap = DfCollectionUtil.newLinkedHashMap();
        parameterMap.put("name", typeDocMeta.getPublicName());
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)typeDocMeta.getDescription())) {
            parameterMap.put("description", typeDocMeta.getDescription());
        }
        if (typeMap.containsKey(typeDocMeta.getType())) {
            Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>> swaggerType = typeMap.get(typeDocMeta.getType());
            parameterMap.put("type", swaggerType.getValue1());
            String format = (String)swaggerType.getValue2();
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)format)) {
                parameterMap.put("format", format);
            }
        } else if (typeDocMeta.getAnnotationTypeList().stream().anyMatch(annotationType -> JsonParameter.class.isAssignableFrom(annotationType.getClass()))) {
            parameterMap.put("type", "string");
        } else if (Iterable.class.isAssignableFrom(typeDocMeta.getType())) {
            this.setupBeanList(typeDocMeta, definitionsMap, typeMap, parameterMap);
        } else if (typeDocMeta.getType().equals(Object.class) || Map.class.isAssignableFrom(typeDocMeta.getType())) {
            parameterMap.put("type", "object");
        } else if (!typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
            String definition = this.putDefinition(definitionsMap, typeDocMeta);
            parameterMap.clear();
            parameterMap.put("name", typeDocMeta.getPublicName());
            parameterMap.put("$ref", definition);
        } else {
            parameterMap.put("type", "object");
            try {
                Class clazz = DfReflectionUtil.forName((String)typeDocMeta.getTypeName());
                if (Enum.class.isAssignableFrom(clazz)) {
                    parameterMap.put("type", "string");
                    Class enumClass = clazz;
                    List<Map<String, String>> enumMap = this.buildEnumMapList(enumClass);
                    parameterMap.put("enum", enumMap.stream().map(e -> (String)e.get("code")).collect(Collectors.toList()));
                    String description = typeDocMeta.getDescription();
                    if (DfStringUtil.is_Null_or_Empty((String)description)) {
                        description = typeDocMeta.getPublicName();
                    }
                    description = description + ":" + enumMap.stream().map(e -> String.format(" * `%s` - %s, %s.", e.get("code"), e.get("name"), e.get("alias"))).collect(Collectors.joining());
                    parameterMap.put("description", description);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        typeDocMeta.getAnnotationTypeList().forEach(annotation -> {
            if (annotation instanceof Size) {
                Size size = (Size)annotation;
                parameterMap.put("minimum", size.min());
                parameterMap.put("maximum", size.max());
            }
            if (annotation instanceof Length) {
                Length length = (Length)annotation;
                parameterMap.put("minLength", length.min());
                parameterMap.put("maxLength", length.max());
            }
        });
        this.deriveDefaultValue(typeDocMeta).ifPresent(defaultValue -> parameterMap.put("example", defaultValue));
        typeDocMeta.setType(keepType);
        return parameterMap;
    }

    protected void setupBeanList(TypeDocMeta typeDocMeta, Map<String, Map<String, Object>> definitionsMap, Map<Class<?>, Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>>> typeMap, Map<String, Object> schemaMap) {
        schemaMap.put("type", "array");
        if (!typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
            String definition = this.putDefinition(definitionsMap, typeDocMeta);
            schemaMap.put("items", DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)definition));
        } else {
            Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>> swaggerType;
            LinkedHashMap items = DfCollectionUtil.newLinkedHashMap();
            Class<?> genericType = typeDocMeta.getGenericType();
            if (genericType != null && (swaggerType = typeMap.get(genericType)) != null) {
                items.put("type", swaggerType.getValue1());
                String format = (String)swaggerType.getValue2();
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)format)) {
                    items.put("format", format);
                }
            }
            if (!items.containsKey("type")) {
                items.put("type", "object");
            }
            schemaMap.put("items", items);
        }
        if (typeDocMeta.getSimpleTypeName().matches(".*List<.*List<.*")) {
            schemaMap.put("items", DfCollectionUtil.newLinkedHashMap((Object)"type", (Object)"array", (Object)"items", (Object)schemaMap.get("items")));
        }
    }

    protected String putDefinition(Map<String, Map<String, Object>> definitionsMap, TypeDocMeta typeDocMeta) {
        LinkedHashMap schema = DfCollectionUtil.newLinkedHashMap();
        schema.put("type", "object");
        List<String> requiredPropertyNameList = this.derivedRequiredPropertyNameList(typeDocMeta);
        if (!requiredPropertyNameList.isEmpty()) {
            schema.put("required", requiredPropertyNameList);
        }
        schema.put("properties", typeDocMeta.getNestTypeDocMetaList().stream().map(nestTypeDocMeta -> this.toParameterMap((TypeDocMeta)nestTypeDocMeta, definitionsMap)).collect(Collectors.toMap(key -> key.get("name"), value -> {
            LinkedHashMap property = DfCollectionUtil.newLinkedHashMap((Map)value);
            property.remove("name");
            return property;
        }, (u, v) -> v, LinkedHashMap::new)));
        String derivedDefinitionName = this.derivedDefinitionName(typeDocMeta);
        System.out.println("@@@: " + derivedDefinitionName);
        definitionsMap.put(derivedDefinitionName, schema);
        return "#/definitions/" + this.encode(derivedDefinitionName);
    }

    protected List<String> derivedRequiredPropertyNameList(TypeDocMeta typeDocMeta) {
        return typeDocMeta.getNestTypeDocMetaList().stream().filter(nesttypeDocMeta -> nesttypeDocMeta.getAnnotationTypeList().stream().anyMatch(annotationType -> this.getRequiredAnnotationList().stream().anyMatch(requiredAnnotation -> requiredAnnotation.isAssignableFrom(annotationType.getClass())))).map(nesttypeDocMeta -> nesttypeDocMeta.getPublicName()).collect(Collectors.toList());
    }

    protected String derivedDefinitionName(TypeDocMeta typeDocMeta) {
        if (typeDocMeta.getTypeName().matches("^[^<]+<(.+)>$")) {
            return typeDocMeta.getTypeName().replaceAll("^[^<]+<(.+)>$", "$1").replaceAll(" ", "");
        }
        return typeDocMeta.getTypeName().replaceAll(" ", "");
    }

    protected OptionalThing<List<String>> derivedProduces(ActionDocMeta actiondocMeta) {
        if (Arrays.asList(Void.TYPE, Void.class).contains(actiondocMeta.getReturnTypeDocMeta().getGenericType())) {
            return OptionalThing.empty();
        }
        if (this.createTypeMap().containsKey(actiondocMeta.getReturnTypeDocMeta().getGenericType())) {
            return OptionalThing.of(Arrays.asList("text/plain;charset=UTF-8"));
        }
        HashMap produceMap = DfCollectionUtil.newHashMap();
        produceMap.put(JsonResponse.class, Arrays.asList("application/json"));
        produceMap.put(XmlResponse.class, Arrays.asList("application/xml"));
        produceMap.put(HtmlResponse.class, Arrays.asList("text/html"));
        produceMap.put(StreamResponse.class, Arrays.asList("application/octet-stream"));
        Class<?> produceType = actiondocMeta.getReturnTypeDocMeta().getType();
        List produceList = (List)produceMap.get(produceType);
        return OptionalThing.ofNullable((Object)produceList, () -> {
            String msg = "Not found the produce: type=" + produceType + ", keys=" + produceMap.keySet();
            throw new IllegalStateException(msg);
        });
    }

    protected Map<Class<?>, Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>>> createTypeMap() {
        LinkedHashMap typeMap = DfCollectionUtil.newLinkedHashMap();
        typeMap.put(Boolean.TYPE, Tuple3.tuple3((Object)"boolean", null, (typeDocMeta, value) -> DfTypeUtil.toBoolean((Object)value)));
        typeMap.put(Byte.TYPE, Tuple3.tuple3((Object)"byte", null, (typeDocMeta, value) -> DfTypeUtil.toByte((Object)value)));
        typeMap.put(Integer.TYPE, Tuple3.tuple3((Object)"integer", (Object)"int32", (typeDocMeta, value) -> DfTypeUtil.toInteger((Object)value)));
        typeMap.put(Long.TYPE, Tuple3.tuple3((Object)"integer", (Object)"int64", (typeDocMeta, value) -> DfTypeUtil.toLong((Object)value)));
        typeMap.put(Float.TYPE, Tuple3.tuple3((Object)"integer", (Object)"float", (typeDocMeta, value) -> DfTypeUtil.toFloat((Object)value)));
        typeMap.put(Double.TYPE, Tuple3.tuple3((Object)"integer", (Object)"double", (typeDocMeta, value) -> DfTypeUtil.toDouble((Object)value)));
        typeMap.put(Boolean.class, Tuple3.tuple3((Object)"boolean", null, (typeDocMeta, value) -> DfTypeUtil.toBoolean((Object)value)));
        typeMap.put(Byte.class, Tuple3.tuple3((Object)"boolean", null, (typeDocMeta, value) -> DfTypeUtil.toByte((Object)value)));
        typeMap.put(Integer.class, Tuple3.tuple3((Object)"integer", (Object)"int32", (typeDocMeta, value) -> DfTypeUtil.toInteger((Object)value)));
        typeMap.put(Long.class, Tuple3.tuple3((Object)"integer", (Object)"int64", (typeDocMeta, value) -> DfTypeUtil.toLong((Object)value)));
        typeMap.put(Float.class, Tuple3.tuple3((Object)"number", (Object)"float", (typeDocMeta, value) -> DfTypeUtil.toFloat((Object)value)));
        typeMap.put(Double.class, Tuple3.tuple3((Object)"number", (Object)"double", (typeDocMeta, value) -> DfTypeUtil.toDouble((Object)value)));
        typeMap.put(BigDecimal.class, Tuple3.tuple3((Object)"integer", (Object)"double", (typeDocMeta, value) -> DfTypeUtil.toBigDecimal((Object)value)));
        typeMap.put(String.class, Tuple3.tuple3((Object)"string", null, (typeDocMeta, value) -> value));
        typeMap.put(byte[].class, Tuple3.tuple3((Object)"string", (Object)"byte", (typeDocMeta, value) -> value));
        typeMap.put(Byte[].class, Tuple3.tuple3((Object)"string", (Object)"byte", (typeDocMeta, value) -> value));
        typeMap.put(Date.class, Tuple3.tuple3((Object)"string", (Object)"date", (typeDocMeta, value) -> value == null ? this.getLocalDateFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalDate()) : value));
        typeMap.put(LocalDate.class, Tuple3.tuple3((Object)"string", (Object)"date", (typeDocMeta, value) -> value == null ? this.getLocalDateFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalDate()) : value));
        typeMap.put(LocalDateTime.class, Tuple3.tuple3((Object)"string", (Object)"date-time", (typeDocMeta, value) -> value == null ? this.getLocalDateTimeFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalDateTime()) : value));
        typeMap.put(LocalTime.class, Tuple3.tuple3((Object)"string", null, (typeDocMeta, value) -> value == null ? this.getLocalTimeFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalTime()) : value));
        typeMap.put(MultipartFormFile.class, Tuple3.tuple3((Object)"file", null, (typeDocMeta, value) -> value));
        return typeMap;
    }

    protected List<Class<? extends Annotation>> getRequiredAnnotationList() {
        return Arrays.asList(Required.class, NotNull.class, NotEmpty.class);
    }

    protected List<Map<String, String>> buildEnumMapList(Class<? extends Enum<?>> typeClass) {
        List<Map<String, String>> enumMapList = Arrays.stream(typeClass.getEnumConstants()).map(enumConstant -> {
            LinkedHashMap map = DfCollectionUtil.newLinkedHashMap((Object)"name", (Object)enumConstant.name());
            if (enumConstant instanceof Classification) {
                map.put("code", ((Classification)enumConstant).code());
                map.put("alias", ((Classification)enumConstant).alias());
            } else {
                map.put("code", enumConstant.name());
                map.put("alias", "");
            }
            return map;
        }).collect(Collectors.toList());
        return enumMapList;
    }

    protected DocumentGenerator createDocumentGenerator() {
        return new DocumentGenerator();
    }

    protected DocumentGeneratorFactory createDocumentGeneratorFactory() {
        return new DocumentGeneratorFactory();
    }

    protected ActionDocumentGenerator createActionDocumentGenerator() {
        return this.createDocumentGenerator().createActionDocumentGenerator();
    }

    protected OptionalThing<String> prepareApplicationVersion() {
        return OptionalThing.empty();
    }

    protected LocalDate getDefaultLocalDate() {
        return LocalDate.ofYearDay(2000, 1);
    }

    protected LocalDateTime getDefaultLocalDateTime() {
        return this.getDefaultLocalDate().atStartOfDay();
    }

    protected LocalTime getDefaultLocalTime() {
        return LocalTime.from(this.getDefaultLocalDateTime());
    }

    protected DateTimeFormatter getLocalDateFormatter(TypeDocMeta typeDocMeta) {
        Optional<DateTimeFormatter> jsonDatePatternDateTimeFormatter = this.getJsonDatePatternDateTimeFormatter(typeDocMeta);
        if (jsonDatePatternDateTimeFormatter.isPresent()) {
            return jsonDatePatternDateTimeFormatter.get();
        }
        return (DateTimeFormatter)this.getApplicationJsonMappingOption().flatMap(applicationJsonMappingOption -> applicationJsonMappingOption.getLocalDateFormatter()).orElseGet(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    protected DateTimeFormatter getLocalDateTimeFormatter(TypeDocMeta typeDocMeta) {
        Optional<DateTimeFormatter> jsonDatePatternDateTimeFormatter = this.getJsonDatePatternDateTimeFormatter(typeDocMeta);
        if (jsonDatePatternDateTimeFormatter.isPresent()) {
            return jsonDatePatternDateTimeFormatter.get();
        }
        return (DateTimeFormatter)this.getApplicationJsonMappingOption().flatMap(applicationJsonMappingOption -> applicationJsonMappingOption.getLocalDateTimeFormatter()).orElseGet(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    }

    protected DateTimeFormatter getLocalTimeFormatter(TypeDocMeta typeDocMeta) {
        Optional<DateTimeFormatter> jsonDatePatternDateTimeFormatter = this.getJsonDatePatternDateTimeFormatter(typeDocMeta);
        if (jsonDatePatternDateTimeFormatter.isPresent()) {
            return jsonDatePatternDateTimeFormatter.get();
        }
        return (DateTimeFormatter)this.getApplicationJsonMappingOption().flatMap(applicationJsonMappingOption -> applicationJsonMappingOption.getLocalTimeFormatter()).orElseGet(() -> DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
    }

    protected Optional<DateTimeFormatter> getJsonDatePatternDateTimeFormatter(TypeDocMeta typeDocMeta) {
        return typeDocMeta.getAnnotationTypeList().stream().filter(annotationType -> annotationType instanceof JsonDatePattern).findFirst().map(jsonDatePattern -> DateTimeFormatter.ofPattern(((JsonDatePattern)jsonDatePattern).value()));
    }

    protected OptionalThing<Object> deriveDefaultValue(TypeDocMeta typeDocMeta) {
        Map<Class<?>, Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>>> typeMap = this.createTypeMap();
        if (typeMap.containsKey(typeDocMeta.getType())) {
            Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>> swaggerType = typeMap.get(typeDocMeta.getType());
            Object defaultValue = ((BiFunction)swaggerType.getValue3()).apply(typeDocMeta, this.deriveDefaultValueByComment(typeDocMeta.getComment()));
            if (defaultValue != null) {
                return OptionalThing.of(defaultValue);
            }
        } else if (Iterable.class.isAssignableFrom(typeDocMeta.getType()) && typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
            Tuple3<String, String, BiFunction<TypeDocMeta, Object, Object>> swaggerType;
            Object defaultValue = this.deriveDefaultValueByComment(typeDocMeta.getComment());
            if (!(defaultValue instanceof List)) {
                return OptionalThing.empty();
            }
            List defaultValueList = (List)defaultValue;
            Class<Object> genericType = typeDocMeta.getGenericType();
            if (genericType == null) {
                genericType = String.class;
            }
            if ((swaggerType = typeMap.get(genericType)) != null) {
                return OptionalThing.of(defaultValueList.stream().map(value -> ((BiFunction)swaggerType.getValue3()).apply(typeDocMeta, value)).collect(Collectors.toList()));
            }
        } else if (Enum.class.isAssignableFrom(typeDocMeta.getType())) {
            Object defaultValue = this.deriveDefaultValueByComment(typeDocMeta.getComment());
            if (defaultValue != null) {
                return OptionalThing.of((Object)defaultValue);
            }
            Class<?> enumClass = typeDocMeta.getType();
            List<Map<String, String>> enumMapList = this.buildEnumMapList(enumClass);
            return OptionalThing.migratedFrom(enumMapList.stream().map(e -> e.get("code")).findFirst(), () -> {
                throw new IllegalStateException("not found enum value.");
            });
        }
        return OptionalThing.empty();
    }

    protected Object deriveDefaultValueByComment(String comment) {
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
            String commentWithoutLine = comment.replaceAll("\r?\n", " ");
            if (commentWithoutLine.contains(" e.g. \"")) {
                return DfStringUtil.substringFirstFront((String)DfStringUtil.substringFirstRear((String)commentWithoutLine, (String[])new String[]{" e.g. \""}), (String[])new String[]{"\""});
            }
            if (commentWithoutLine.contains(" e.g. [")) {
                String defaultValue = DfStringUtil.substringFirstFront((String)DfStringUtil.substringFirstRear((String)commentWithoutLine, (String[])new String[]{" e.g. ["}), (String[])new String[]{"]"});
                return Arrays.stream(defaultValue.split(", *")).map(value -> {
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        return value.substring(1, value.length() - 1);
                    }
                    return "null".equals(value) ? null : value;
                }).collect(Collectors.toList());
            }
            Pattern pattern = Pattern.compile(" e\\.g\\. ([^ ]+)");
            Matcher matcher = pattern.matcher(commentWithoutLine);
            if (matcher.find()) {
                String value2 = matcher.group(1);
                return "null".equals(value2) ? null : value2;
            }
        }
        return null;
    }

    protected String getLastaDocDir() {
        return this.createDocumentGeneratorFactory().getLastaDocDir();
    }

    protected AccessibleConfig getAccessibleConfig() {
        return (AccessibleConfig)ContainerUtil.getComponent(AccessibleConfig.class);
    }

    protected HttpServletRequest getRequest() {
        return LaRequestUtil.getRequest();
    }

    protected RealJsonEngine createJsonEngine() {
        return this.createDocumentGeneratorFactory().createJsonEngine();
    }

    protected OptionalThing<JsonMappingOption> getApplicationJsonMappingOption() {
        return this.createDocumentGeneratorFactory().getApplicationJsonMappingOption();
    }

    protected OptionalThing<String> findLastaDocVersion() {
        return this.createMavenVersionFinder().findVersion("org.lastaflute.doc", "lasta-doc");
    }

    protected MavenVersionFinder createMavenVersionFinder() {
        return new MavenVersionFinder();
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

