/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.generator;

import com.google.gson.FieldNamingPolicy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.dbflute.jdbc.Classification;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.core.json.JsonMappingOption;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.doc.generator.BaseDocumentGenerator;
import org.lastaflute.doc.generator.DocumentGeneratorFactory;
import org.lastaflute.doc.meta.ActionDocMeta;
import org.lastaflute.doc.meta.TypeDocMeta;
import org.lastaflute.doc.reflector.SourceParserReflector;
import org.lastaflute.doc.util.LaDocReflectionUtil;
import org.lastaflute.web.Execute;
import org.lastaflute.web.UrlChain;
import org.lastaflute.web.path.ActionPathResolver;
import org.lastaflute.web.ruts.config.ActionExecute;
import org.lastaflute.web.ruts.config.ActionFormMeta;
import org.lastaflute.web.ruts.config.ModuleConfig;
import org.lastaflute.web.ruts.multipart.MultipartFormFile;
import org.lastaflute.web.util.LaModuleConfigUtil;

public class ActionDocumentGenerator
extends BaseDocumentGenerator {
    protected static final Set<String> SUPPRESSED_FIELD_SET = DfCollectionUtil.newHashSet((Object[])new String[]{"$jacocoData"});
    protected static final List<String> TARGET_SUFFIX_LIST = Arrays.asList("Form", "Body", "Bean", "Result");
    protected static final List<Class<?>> NATIVE_TYPE_LIST = Arrays.asList(Void.TYPE, Boolean.TYPE, Byte.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.class, Byte.class, Boolean.class, Integer.class, Byte.class, Long.class, Float.class, Double.class, String.class, Map.class, byte[].class, Byte[].class, Date.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MultipartFormFile.class);
    protected final List<String> srcDirList;
    protected int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;

    public ActionDocumentGenerator(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        this.srcDirList = srcDirList;
        this.depth = depth;
        this.sourceParserReflector = sourceParserReflector;
    }

    public List<ActionDocMeta> generateActionDocMetaList() {
        List<String> actionComponentNameList = this.findActionComponentNameList();
        ArrayList metaList = DfCollectionUtil.newArrayList();
        ModuleConfig moduleConfig = LaModuleConfigUtil.getModuleConfig();
        actionComponentNameList.forEach(componentName -> moduleConfig.findActionMapping(componentName).alwaysPresent(actionMapping -> {
            Class actionClass = actionMapping.getActionDef().getComponentClass();
            ArrayList methodList = DfCollectionUtil.newArrayList();
            this.sourceParserReflector.ifPresent(sourceParserReflector -> methodList.addAll(sourceParserReflector.getMethodListOrderByDefinition(actionClass)));
            if (methodList.isEmpty()) {
                methodList.addAll(Arrays.stream(actionClass.getMethods()).sorted(Comparator.comparing(method -> method.getName())).collect(Collectors.toList()));
            }
            methodList.forEach(method -> {
                ActionExecute actionExecute;
                if (method.getAnnotation(Execute.class) != null && (actionExecute = actionMapping.getActionExecute(method)) != null && !this.exceptsActionExecute(actionExecute)) {
                    ActionDocMeta actionDocMeta = this.createActionDocMeta(actionExecute);
                    metaList.add(actionDocMeta);
                }
            });
        }));
        return metaList;
    }

    protected boolean exceptsActionExecute(ActionExecute actionExecute) {
        return this.suppressActionExecute(actionExecute);
    }

    @Deprecated
    protected boolean suppressActionExecute(ActionExecute actionExecute) {
        return false;
    }

    protected ActionDocMeta createActionDocMeta(ActionExecute execute) {
        ActionDocMeta actionDocMeta = new ActionDocMeta();
        Class actionClass = execute.getActionMapping().getActionDef().getComponentClass();
        UrlChain urlChain = new UrlChain((Object)actionClass);
        String urlPattern = execute.getPreparedUrlPattern().getResolvedUrlPattern();
        if (!"index".equals(urlPattern)) {
            urlChain.moreUrl(new Object[]{urlPattern});
        }
        actionDocMeta.setUrl(this.getActionPathResolver().toActionUrl(actionClass, urlChain));
        Method executeMethod = execute.getExecuteMethod();
        Class<?> methodDeclaringClass = executeMethod.getDeclaringClass();
        actionDocMeta.setType(methodDeclaringClass);
        actionDocMeta.setTypeName(this.adjustTypeName(methodDeclaringClass));
        actionDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(methodDeclaringClass));
        actionDocMeta.setFieldTypeDocMetaList(Arrays.stream(methodDeclaringClass.getDeclaredFields()).map(field -> {
            TypeDocMeta typeDocMeta = new TypeDocMeta();
            typeDocMeta.setName(field.getName());
            typeDocMeta.setPublicName(this.adjustPublicFieldName(null, (Field)field));
            typeDocMeta.setType(field.getType());
            typeDocMeta.setTypeName(this.adjustTypeName(field.getGenericType()));
            typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(field.getGenericType()));
            typeDocMeta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
            typeDocMeta.setAnnotationList(this.analyzeAnnotationList(typeDocMeta.getAnnotationTypeList()));
            this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(typeDocMeta, field.getType()));
            return typeDocMeta;
        }).collect(Collectors.toList()));
        actionDocMeta.setMethodName(executeMethod.getName());
        ArrayList annotationList = DfCollectionUtil.newArrayList();
        annotationList.addAll(Arrays.asList(methodDeclaringClass.getAnnotations()));
        annotationList.addAll(Arrays.asList(executeMethod.getAnnotations()));
        actionDocMeta.setAnnotationTypeList(annotationList);
        actionDocMeta.setAnnotationList(this.analyzeAnnotationList(annotationList));
        ArrayList parameterTypeDocMetaList = DfCollectionUtil.newArrayList();
        Arrays.stream(executeMethod.getParameters()).filter(parameter -> !execute.getFormMeta().isPresent() || !((ActionFormMeta)execute.getFormMeta().get()).getFormType().equals(parameter.getType())).forEach(parameter -> {
            StringBuilder builder = new StringBuilder();
            builder.append("{").append(parameter.getName()).append("}");
            actionDocMeta.setUrl(actionDocMeta.getUrl().replaceFirst("\\{\\}", builder.toString()));
            parameterTypeDocMetaList.add(this.analyzeMethodParameter((Parameter)parameter));
        });
        actionDocMeta.setParameterTypeDocMetaList(parameterTypeDocMetaList);
        this.analyzeFormClass(execute).ifPresent(formTypeDocMeta -> actionDocMeta.setFormTypeDocMeta((TypeDocMeta)formTypeDocMeta));
        actionDocMeta.setReturnTypeDocMeta(this.analyzeReturnClass(executeMethod));
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(actionDocMeta, executeMethod));
        return actionDocMeta;
    }

    protected TypeDocMeta analyzeMethodParameter(Parameter parameter) {
        TypeDocMeta parameterDocMeta = new TypeDocMeta();
        parameterDocMeta.setName(parameter.getName());
        parameterDocMeta.setPublicName(parameter.getName());
        parameterDocMeta.setType(parameter.getType());
        parameterDocMeta.setTypeName(this.adjustTypeName(parameter.getParameterizedType()));
        parameterDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(parameter.getParameterizedType()));
        if (OptionalThing.class.isAssignableFrom(parameter.getType())) {
            parameterDocMeta.setGenericType(DfReflectionUtil.getGenericFirstClass((Type)parameter.getParameterizedType()));
        }
        parameterDocMeta.setAnnotationTypeList(Arrays.asList(parameter.getAnnotatedType().getAnnotations()));
        parameterDocMeta.setAnnotationList(this.analyzeAnnotationList(parameterDocMeta.getAnnotationTypeList()));
        parameterDocMeta.setNestTypeDocMetaList(Collections.emptyList());
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(parameterDocMeta, parameter.getType()));
        return parameterDocMeta;
    }

    protected OptionalThing<TypeDocMeta> analyzeFormClass(ActionExecute execute) {
        return execute.getFormMeta().map(lastafluteFormMeta -> {
            TypeDocMeta formDocMeta = new TypeDocMeta();
            lastafluteFormMeta.getListFormParameterParameterizedType().ifPresent(type -> {
                formDocMeta.setType(lastafluteFormMeta.getFormType());
                formDocMeta.setTypeName(this.adjustTypeName((Type)type));
                formDocMeta.setSimpleTypeName(this.adjustSimpleTypeName((Type)type));
            }).orElse(() -> {
                formDocMeta.setType(lastafluteFormMeta.getFormType());
                formDocMeta.setTypeName(this.adjustTypeName(lastafluteFormMeta.getFormType()));
                formDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(lastafluteFormMeta.getFormType()));
            });
            Class formType = (Class)lastafluteFormMeta.getListFormParameterGenericType().orElse((Object)lastafluteFormMeta.getFormType());
            LinkedHashMap genericParameterTypesMap = DfCollectionUtil.newLinkedHashMap();
            List<TypeDocMeta> propertyDocMetaList = this.analyzeProperties(formType, genericParameterTypesMap, this.depth);
            formDocMeta.setNestTypeDocMetaList(propertyDocMetaList);
            this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(formDocMeta, formType));
            return formDocMeta;
        });
    }

    protected TypeDocMeta analyzeReturnClass(Method method) {
        TypeDocMeta returnDocMeta = new TypeDocMeta();
        returnDocMeta.setType(method.getReturnType());
        returnDocMeta.setTypeName(this.adjustTypeName(method.getGenericReturnType()));
        returnDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(method.getGenericReturnType()));
        returnDocMeta.setGenericType(DfReflectionUtil.getGenericFirstClass((Type)method.getGenericReturnType()));
        returnDocMeta.setAnnotationTypeList(Arrays.asList(method.getAnnotatedReturnType().getAnnotations()));
        returnDocMeta.setAnnotationList(this.analyzeAnnotationList(returnDocMeta.getAnnotationTypeList()));
        this.derivedManualReturnClass(method, returnDocMeta);
        Class<?> returnClass = returnDocMeta.getGenericType();
        if (returnClass != null) {
            LinkedHashMap genericParameterTypesMap = DfCollectionUtil.newLinkedHashMap();
            Type[] parameterTypes = DfReflectionUtil.getGenericParameterTypes((Type)method.getGenericReturnType());
            TypeVariable[] typeVariables = returnClass.getTypeParameters();
            IntStream.range(0, parameterTypes.length).forEach(parameterTypesIndex -> {
                Type[] genericParameterTypes = DfReflectionUtil.getGenericParameterTypes((Type)parameterTypes[parameterTypesIndex]);
                IntStream.range(0, typeVariables.length).forEach(typeVariablesIndex -> {
                    Type type = genericParameterTypes[typeVariablesIndex];
                    genericParameterTypesMap.put(typeVariables[typeVariablesIndex].getTypeName(), type);
                });
            });
            if (Iterable.class.isAssignableFrom(returnClass)) {
                returnClass = LaDocReflectionUtil.extractElementType(method.getGenericReturnType(), 1);
            }
            List<Class<?>> nativeClassList = this.getNativeClassList();
            if (returnClass != null && !nativeClassList.contains(returnClass)) {
                List<TypeDocMeta> propertyDocMetaList = this.analyzeProperties(returnClass, genericParameterTypesMap, this.depth);
                returnDocMeta.setNestTypeDocMetaList(propertyDocMetaList);
            }
            if (this.sourceParserReflector.isPresent()) {
                ((SourceParserReflector)this.sourceParserReflector.get()).reflect(returnDocMeta, returnClass);
            }
        }
        return returnDocMeta;
    }

    protected void derivedManualReturnClass(Method method, TypeDocMeta returnDocMeta) {
    }

    public List<Class<?>> getNativeClassList() {
        return NATIVE_TYPE_LIST;
    }

    protected List<TypeDocMeta> analyzeProperties(Class<?> propertyOwner, Map<String, Type> genericParameterTypesMap, int depth) {
        if (depth < 0) {
            return DfCollectionUtil.newArrayList();
        }
        Set<Field> fieldSet = this.extractWholeFieldSet(propertyOwner);
        return fieldSet.stream().filter(field -> !this.exceptsField((Field)field)).map(field -> this.analyzePropertyField(propertyOwner, genericParameterTypesMap, depth, (Field)field)).collect(Collectors.toList());
    }

    protected Set<Field> extractWholeFieldSet(Class<?> propertyOwner) {
        LinkedHashSet fieldSet = DfCollectionUtil.newLinkedHashSet();
        for (Class<?> targetClazz = propertyOwner; targetClazz != Object.class && targetClazz != null; targetClazz = targetClazz.getSuperclass()) {
            fieldSet.addAll(Arrays.asList(targetClazz.getDeclaredFields()));
        }
        return fieldSet;
    }

    protected boolean exceptsField(Field field) {
        return SUPPRESSED_FIELD_SET.contains(field.getName()) || Modifier.isStatic(field.getModifiers());
    }

    protected TypeDocMeta analyzePropertyField(Class<?> propertyOwner, Map<String, Type> genericParameterTypesMap, int depth, Field field) {
        TypeDocMeta meta = new TypeDocMeta();
        Type genericClass = genericParameterTypesMap.get(field.getGenericType().getTypeName());
        Class resolvedType = genericClass != null ? genericClass : field.getType();
        meta.setName(field.getName());
        meta.setPublicName(this.adjustPublicFieldName(null, field));
        meta.setType(field.getType());
        meta.setTypeName(this.adjustTypeName(resolvedType));
        meta.setSimpleTypeName(this.adjustSimpleTypeName(resolvedType));
        meta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
        meta.setAnnotationList(this.analyzeAnnotationList(meta.getAnnotationTypeList()));
        Class resolvedClass = resolvedType instanceof Class ? resolvedType : (Class)DfReflectionUtil.getGenericParameterTypes(resolvedType)[0];
        if (resolvedClass.isEnum()) {
            meta.setValue(this.buildEnumValuesExp(resolvedClass));
        }
        if (this.isTargetSuffixResolvedClass(resolvedClass)) {
            meta.setNestTypeDocMetaList(this.analyzeProperties(resolvedClass, genericParameterTypesMap, depth - 1));
        } else if (this.isTargetSuffixFieldGeneric(field)) {
            Class typeArgumentClass;
            Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (type instanceof Class) {
                typeArgumentClass = (Class)type;
                meta.setNestTypeDocMetaList(this.analyzeProperties(typeArgumentClass, genericParameterTypesMap, depth - 1));
                String currentTypeName = meta.getTypeName();
                meta.setTypeName(this.adjustTypeName(currentTypeName) + "<" + this.adjustTypeName(typeArgumentClass) + ">");
                meta.setSimpleTypeName(this.adjustSimpleTypeName(currentTypeName) + "<" + this.adjustSimpleTypeName(typeArgumentClass) + ">");
            } else if (type instanceof ParameterizedType) {
                typeArgumentClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                meta.setNestTypeDocMetaList(this.analyzeProperties(typeArgumentClass, genericParameterTypesMap, depth - 1));
                String currentTypeName = meta.getTypeName();
                meta.setTypeName(this.adjustTypeName(currentTypeName) + "<" + this.adjustTypeName(((ParameterizedType)type).getRawType()) + "<" + this.adjustTypeName(typeArgumentClass) + ">>");
                meta.setSimpleTypeName(this.adjustSimpleTypeName(currentTypeName) + "<" + this.adjustSimpleTypeName(((ParameterizedType)type).getRawType()) + "<" + this.adjustSimpleTypeName(typeArgumentClass) + ">>");
            }
        } else if (field.getGenericType().getTypeName().matches(".*<(.*)>")) {
            String genericTypeName = field.getGenericType().getTypeName().replaceAll(".*<(.*)>", "$1");
            try {
                meta.setGenericType(DfReflectionUtil.forName((String)genericTypeName));
            }
            catch (DfReflectionUtil.ReflectionFailureException ignored) {
                meta.setGenericType(Object.class);
            }
            genericClass = genericParameterTypesMap.get(genericTypeName);
            if (genericClass != null) {
                meta.setNestTypeDocMetaList(this.analyzeProperties((Class<?>)genericClass, genericParameterTypesMap, depth - 1));
                String typeName = meta.getTypeName();
                meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustTypeName(genericClass) + ">");
                meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericClass) + ">");
            } else {
                String typeName = meta.getTypeName();
                meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericTypeName) + ">");
                meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericTypeName) + ">");
            }
        }
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(meta, propertyOwner));
        meta.setName(this.adjustFieldName(propertyOwner, field));
        meta.setPublicName(this.adjustPublicFieldName(propertyOwner, field));
        return meta;
    }

    protected String buildEnumValuesExp(Class<?> typeClass) {
        String valuesExp;
        if (Classification.class.isAssignableFrom(typeClass)) {
            Class<?> clsType = typeClass;
            valuesExp = Arrays.stream(clsType.getEnumConstants()).collect(Collectors.toMap(keyMapper -> keyMapper.code(), valueMapper -> valueMapper.alias(), (u, v) -> v, LinkedHashMap::new)).toString();
        } else {
            Enum[] constants = (Enum[])typeClass.getEnumConstants();
            valuesExp = Arrays.stream(constants).collect(Collectors.toList()).toString();
        }
        return valuesExp;
    }

    protected boolean isTargetSuffixResolvedClass(Class<?> resolvedClass) {
        return this.getTargetTypeSuffixList().stream().anyMatch(suffix -> resolvedClass.getName().contains((CharSequence)suffix));
    }

    protected boolean isTargetSuffixFieldGeneric(Field field) {
        return this.getTargetTypeSuffixList().stream().anyMatch(suffix -> field.getGenericType().getTypeName().contains((CharSequence)suffix));
    }

    protected List<String> getTargetTypeSuffixList() {
        return TARGET_SUFFIX_LIST;
    }

    protected String adjustFieldName(Class<?> clazz, Field field) {
        return field.getName();
    }

    protected String adjustPublicFieldName(Class<?> clazz, Field field) {
        if (clazz == null || this.isActionFormComponentType(clazz)) {
            return field.getName();
        }
        return (String)this.getApplicationJsonMappingOption().flatMap(jsonMappingOption -> jsonMappingOption.getFieldNaming().map(naming -> {
            if (naming == JsonMappingOption.JsonFieldNaming.IDENTITY) {
                return FieldNamingPolicy.IDENTITY.translateName(field);
            }
            if (naming == JsonMappingOption.JsonFieldNaming.CAMEL_TO_LOWER_SNAKE) {
                return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES.translateName(field);
            }
            return field.getName();
        })).orElse((Object)field.getName());
    }

    protected boolean isActionFormComponentType(Class<?> clazz) {
        return clazz.getSimpleName().endsWith("Form") || clazz.getName().contains("Form$");
    }

    public Map<String, Map<String, String>> generateActionPropertyNameMap(List<ActionDocMeta> actionDocMetaList) {
        Map propertyNameMap = actionDocMetaList.stream().collect(Collectors.toMap(key -> key.getUrl().replaceAll("\\{.*", "").replaceAll("/$", "").replaceAll("/", "_"), value -> this.convertPropertyNameMap("", value.getFormTypeDocMeta()), (u, v) -> v, LinkedHashMap::new));
        return propertyNameMap;
    }

    protected Map<String, String> convertPropertyNameMap(String parentName, TypeDocMeta typeDocMeta) {
        if (typeDocMeta == null) {
            return DfCollectionUtil.newLinkedHashMap();
        }
        LinkedHashMap propertyNameMap = DfCollectionUtil.newLinkedHashMap();
        String name = this.calculateName(parentName, typeDocMeta.getName(), typeDocMeta.getTypeName());
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)name)) {
            propertyNameMap.put(name, "");
        }
        if (typeDocMeta.getNestTypeDocMetaList() != null) {
            typeDocMeta.getNestTypeDocMetaList().forEach(nestDocMeta -> propertyNameMap.putAll(this.convertPropertyNameMap(name, (TypeDocMeta)nestDocMeta)));
        }
        return propertyNameMap;
    }

    protected String calculateName(String parentName, String name, String type) {
        if (DfStringUtil.is_Null_or_Empty((String)name)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)parentName)) {
            builder.append(parentName + ".");
        }
        builder.append(name);
        if (name.endsWith("List")) {
            builder.append("[]");
        }
        return builder.toString();
    }

    protected List<String> findActionComponentNameList() {
        ArrayList componentNameList = DfCollectionUtil.newArrayList();
        LaContainer container = this.getRootContainer();
        this.srcDirList.stream().filter(srcDir -> Paths.get(srcDir, new String[0]).toFile().exists()).forEach(srcDir -> {
            try (Stream<Path> stream = Files.find(Paths.get(srcDir, new String[0]), Integer.MAX_VALUE, (path, attr) -> path.toString().endsWith("Action.java"), new FileVisitOption[0]);){
                stream.sorted().map(path -> {
                    String className = this.extractActionClassName((Path)path, (String)srcDir);
                    return DfReflectionUtil.forName((String)className);
                }).filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).forEach(clazz -> {
                    String componentName = container.getComponentDef(clazz).getComponentName();
                    if (componentName != null && !componentNameList.contains(componentName)) {
                        componentNameList.add(componentName);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to find the components: " + srcDir, e);
            }
        });
        IntStream.range(0, container.getComponentDefSize()).forEach(index -> {
            ComponentDef componentDef = container.getComponentDef(index);
            String componentName = componentDef.getComponentName();
            if (componentName.endsWith("Action") && !componentNameList.contains(componentName)) {
                componentNameList.add(componentDef.getComponentName());
            }
        });
        return componentNameList;
    }

    protected String extractActionClassName(Path path, String srcDir) {
        String className = DfStringUtil.substringFirstRear((String)path.toFile().getAbsolutePath(), (String[])new String[]{new File(srcDir).getAbsolutePath()});
        if (className.startsWith(File.separator)) {
            className = className.substring(1);
        }
        className = DfStringUtil.substringLastFront((String)className, (String[])new String[]{".java"}).replace(File.separatorChar, '.');
        return className;
    }

    protected DocumentGeneratorFactory createDocumentGeneratorFactory() {
        return new DocumentGeneratorFactory();
    }

    protected LaContainer getRootContainer() {
        return SingletonLaContainerFactory.getContainer().getRoot();
    }

    protected ActionPathResolver getActionPathResolver() {
        return (ActionPathResolver)ContainerUtil.getComponent(ActionPathResolver.class);
    }

    protected OptionalThing<JsonMappingOption> getApplicationJsonMappingOption() {
        return this.createDocumentGeneratorFactory().getApplicationJsonMappingOption();
    }
}

