/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.exception.ComponentNotFoundRuntimeException;
import org.lastaflute.di.core.util.BindingUtil;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.log.SLogger;

public abstract class AbstractAssembler {
    private static SLogger logger = SLogger.getLogger(AbstractAssembler.class);
    private final ComponentDef componentDef;

    public AbstractAssembler(ComponentDef componentDef) {
        this.componentDef = componentDef;
    }

    protected BeanDesc getBeanDesc(Object component) {
        return BindingUtil.getBeanDesc(this.getComponentDef(), component);
    }

    protected Class<?> getComponentClass(Object component) {
        return BindingUtil.getComponentClass(this.getComponentDef(), component);
    }

    protected Object[] getArgs(Class<?>[] argTypes) {
        Object[] args = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            try {
                args[i] = this.getComponentDef().getContainer().getComponent(argTypes[i]);
                continue;
            }
            catch (ComponentNotFoundRuntimeException ex) {
                logger.log("WSSR0007", new Object[]{this.getComponentDef().getComponentClass().getName(), ex.getComponentKey()});
                args[i] = null;
            }
        }
        return args;
    }

    protected final ComponentDef getComponentDef() {
        return this.componentDef;
    }
}

