/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.dixml.taghandler;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.aop.Pointcut;
import org.lastaflute.di.core.aop.impl.PointcutImpl;
import org.lastaflute.di.core.factory.dixml.taghandler.AbstractTagHandler;
import org.lastaflute.di.core.meta.AspectDef;
import org.lastaflute.di.core.meta.impl.AspectDefImpl;
import org.lastaflute.di.helper.xml.TagHandlerContext;
import org.lastaflute.di.util.LdiStringUtil;
import org.xml.sax.Attributes;

public class AspectTagHandler
extends AbstractTagHandler {
    private static final long serialVersionUID = 5619707344253136193L;

    @Override
    public void start(TagHandlerContext context, Attributes attributes) {
        AspectDefImpl aspectDef = null;
        String pointcutStr = attributes.getValue("pointcut");
        if (pointcutStr != null) {
            String[] methodNames = LdiStringUtil.split(pointcutStr, ", ");
            aspectDef = this.createAspectDef(this.createPointcut(methodNames));
        } else {
            aspectDef = this.createAspectDef();
        }
        context.push(aspectDef);
    }

    @Override
    public void end(TagHandlerContext context, String body) {
        AspectDef aspectDef = (AspectDef)context.pop();
        if (!LdiStringUtil.isEmpty(body)) {
            aspectDef.setExpression(this.createExpression(context, body));
        }
        ComponentDef componentDef = (ComponentDef)context.peek();
        componentDef.addAspectDef(aspectDef);
    }

    protected AspectDefImpl createAspectDef() {
        return new AspectDefImpl();
    }

    protected AspectDefImpl createAspectDef(Pointcut pointcut) {
        return new AspectDefImpl(pointcut);
    }

    protected Pointcut createPointcut(String[] methodNames) {
        return new PointcutImpl(methodNames);
    }
}

