/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.smart.cool;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.creator.ComponentCreator;
import org.lastaflute.di.core.util.ComponentUtil;
import org.lastaflute.di.naming.NamingConvention;
import org.lastaflute.di.util.ClassTraversal;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiModifierUtil;
import org.lastaflute.di.util.LdiResourcesUtil;

public class CoolComponentAutoRegister
implements ClassTraversal.ClassHandler {
    public static final String INIT_METHOD = "registerAll";
    public static final String container_BINDING = "bindingType=must";
    @Resource
    private LaContainer container;
    @Resource
    private ComponentCreator[] creators;
    @Resource
    private NamingConvention namingConvention;
    protected Set<Class<?>> registeredClasses = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll() {
        try {
            String[] rootPackageNames = this.namingConvention.getRootPackageNames();
            if (rootPackageNames != null) {
                for (int i = 0; i < rootPackageNames.length; ++i) {
                    LdiResourcesUtil.Resources[] resourcesArray = LdiResourcesUtil.getResourcesTypes(rootPackageNames[i]);
                    for (int j = 0; j < resourcesArray.length; ++j) {
                        try (LdiResourcesUtil.Resources resources = resourcesArray[j];){
                            resources.forEach(this);
                            continue;
                        }
                    }
                }
            }
        }
        finally {
            this.registeredClasses.clear();
        }
    }

    @Override
    public void processClass(String packageName, String shortClassName) {
        ComponentDef cd;
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = LdiClassUtil.concatName(packageName, shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        Class clazz = LdiClassUtil.forName(className);
        if (this.namingConvention.isSkipClass(clazz)) {
            return;
        }
        if (this.container.getRoot().hasComponentDef(clazz)) {
            if (clazz.isInterface() || LdiModifierUtil.isAbstract(clazz)) {
                return;
            }
            cd = this.container.getRoot().getComponentDef(clazz);
            if (clazz == cd.getComponentClass()) {
                return;
            }
        }
        if ((cd = this.createComponentDef(clazz)) == null) {
            return;
        }
        if (this.registeredClasses.contains(cd.getComponentClass())) {
            return;
        }
        this.container.getRoot().register(cd);
        this.registeredClasses.add(cd.getComponentClass());
        ComponentUtil.putRegisterLog(cd);
    }

    protected ComponentDef createComponentDef(Class<?> componentClass) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentClass);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }
}

