/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util.tiger;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lastaflute.di.util.tiger.LdiCollectionsUtil;

public abstract class LdiGenericUtil {
    protected static final Type[] EMPTY_TYPES = new Type[0];

    protected LdiGenericUtil() {
    }

    public static boolean isTypeOf(Type type, Class<?> clazz) {
        if (Class.class.isInstance(type)) {
            return clazz.isAssignableFrom((Class)Class.class.cast(type));
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return LdiGenericUtil.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    public static Class<?> getRawClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return LdiGenericUtil.getRawClass(parameterizedType.getRawType());
        }
        if (WildcardType.class.isInstance(type)) {
            WildcardType wildcardType = (WildcardType)WildcardType.class.cast(type);
            Type[] types = wildcardType.getUpperBounds();
            return LdiGenericUtil.getRawClass(types[0]);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = LdiGenericUtil.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    public static Type getGenericParameterType(Type type, int index) {
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        Type[] genericParameter = LdiGenericUtil.getGenericParameterTypes(type);
        if (genericParameter.length == 0 || genericParameter.length < index) {
            return null;
        }
        return genericParameter[index];
    }

    public static Type[] getGenericParameterTypes(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (GenericArrayType.class.isInstance(type)) {
            return LdiGenericUtil.getGenericParameterTypes(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        return EMPTY_TYPES;
    }

    public static Type getElementTypeOfArray(Type type) {
        if (!GenericArrayType.class.isInstance(type)) {
            return null;
        }
        return ((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType();
    }

    public static Type getElementTypeOfCollection(Type type) {
        if (!LdiGenericUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return LdiGenericUtil.getGenericParameterType(type, 0);
    }

    public static Type getElementTypeOfList(Type type) {
        if (!LdiGenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return LdiGenericUtil.getGenericParameterType(type, 0);
    }

    public static Type getElementTypeOfSet(Type type) {
        if (!LdiGenericUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return LdiGenericUtil.getGenericParameterType(type, 0);
    }

    public static Type getKeyTypeOfMap(Type type) {
        if (!LdiGenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return LdiGenericUtil.getGenericParameterType(type, 0);
    }

    public static Type getValueTypeOfMap(Type type) {
        if (!LdiGenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return LdiGenericUtil.getGenericParameterType(type, 1);
    }

    public static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> clazz) {
        TypeVariable<Class<?>>[] typeParameters;
        LinkedHashMap<TypeVariable<?>, Type> map = LdiCollectionsUtil.newLinkedHashMap();
        for (TypeVariable<Class<?>> typeParameter : typeParameters = clazz.getTypeParameters()) {
            map.put(typeParameter, LdiGenericUtil.getActualClass(typeParameter.getBounds()[0], map));
        }
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            LdiGenericUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            LdiGenericUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
        return map;
    }

    protected static void gatherTypeVariables(Class<?> clazz, Type type, Map<TypeVariable<?>, Type> map) {
        if (clazz == null) {
            return;
        }
        LdiGenericUtil.gatherTypeVariables(type, map);
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            LdiGenericUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            LdiGenericUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
    }

    protected static void gatherTypeVariables(Type type, Map<TypeVariable<?>, Type> map) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            TypeVariable<?>[] typeVariables = ((GenericDeclaration)GenericDeclaration.class.cast(parameterizedType.getRawType())).getTypeParameters();
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < actualTypes.length; ++i) {
                map.put(typeVariables[i], actualTypes[i]);
            }
        }
    }

    public static Class<?> getActualClass(Type type, Map<TypeVariable<?>, Type> map) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            return LdiGenericUtil.getActualClass(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType(), map);
        }
        if (WildcardType.class.isInstance(type)) {
            return LdiGenericUtil.getActualClass(((WildcardType)WildcardType.class.cast(type)).getUpperBounds()[0], map);
        }
        if (TypeVariable.class.isInstance(type)) {
            TypeVariable typeVariable = (TypeVariable)TypeVariable.class.cast(type);
            if (map.containsKey(typeVariable)) {
                return LdiGenericUtil.getActualClass(map.get(typeVariable), map);
            }
            return LdiGenericUtil.getActualClass(typeVariable.getBounds()[0], map);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> componentClass = LdiGenericUtil.getActualClass(genericArrayType.getGenericComponentType(), map);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static Class<?> getActualElementClassOfArray(Type type, Map<TypeVariable<?>, Type> map) {
        if (!GenericArrayType.class.isInstance(type)) {
            return null;
        }
        return LdiGenericUtil.getActualClass(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType(), map);
    }

    public static Class<?> getActualElementClassOfCollection(Type type, Map<TypeVariable<?>, Type> map) {
        if (!LdiGenericUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return LdiGenericUtil.getActualClass(LdiGenericUtil.getGenericParameterType(type, 0), map);
    }

    public static Class<?> getActualElementClassOfList(Type type, Map<TypeVariable<?>, Type> map) {
        if (!LdiGenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return LdiGenericUtil.getActualClass(LdiGenericUtil.getGenericParameterType(type, 0), map);
    }

    public static Class<?> getActualElementClassOfSet(Type type, Map<TypeVariable<?>, Type> map) {
        if (!LdiGenericUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return LdiGenericUtil.getActualClass(LdiGenericUtil.getGenericParameterType(type, 0), map);
    }

    public static Class<?> getActualKeyClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        if (!LdiGenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return LdiGenericUtil.getActualClass(LdiGenericUtil.getGenericParameterType(type, 0), map);
    }

    public static Class<?> getActualValueClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        if (!LdiGenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return LdiGenericUtil.getActualClass(LdiGenericUtil.getGenericParameterType(type, 1), map);
    }
}

