/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.dbcp.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.lastaflute.jta.dbcp.ConnectionPool;
import org.lastaflute.jta.dbcp.ConnectionWrapper;
import org.lastaflute.jta.dbcp.impl.PreparedStatementWrapper;
import org.lastaflute.jta.dbcp.impl.XAResourceWrapperImpl;
import org.lastaflute.jta.exception.LjtSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWrapperImpl
implements ConnectionWrapper,
ConnectionEventListener {
    private static final Logger logger_ = LoggerFactory.getLogger(ConnectionWrapperImpl.class);
    private XAConnection xaConnection_;
    private Connection physicalConnection_;
    private XAResource xaResource_;
    private ConnectionPool connectionPool_;
    private boolean closed_ = false;
    private Transaction tx_;

    public ConnectionWrapperImpl(XAConnection xaConnection, Connection physicalConnection, ConnectionPool connectionPool, Transaction tx) throws SQLException {
        this.xaConnection_ = xaConnection;
        this.physicalConnection_ = physicalConnection;
        this.xaResource_ = new XAResourceWrapperImpl(xaConnection.getXAResource(), this);
        this.connectionPool_ = connectionPool;
        this.tx_ = tx;
        this.xaConnection_.addConnectionEventListener(this);
    }

    @Override
    public void init(Transaction tx) {
        this.closed_ = false;
        this.tx_ = tx;
    }

    @Override
    public Connection getPhysicalConnection() {
        return this.physicalConnection_;
    }

    @Override
    public XAResource getXAResource() {
        return this.xaResource_;
    }

    @Override
    public XAConnection getXAConnection() {
        return this.xaConnection_;
    }

    @Override
    public void cleanup() {
        this.xaConnection_.removeConnectionEventListener(this);
        this.closed_ = true;
        this.xaConnection_ = null;
        this.physicalConnection_ = null;
        this.tx_ = null;
    }

    @Override
    public void closeReally() {
        block14: {
            if (this.xaConnection_ == null) {
                return;
            }
            this.closed_ = true;
            try {
                if (this.physicalConnection_.isClosed()) break block14;
                if (!this.physicalConnection_.getAutoCommit()) {
                    try {
                        this.physicalConnection_.rollback();
                        this.physicalConnection_.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        logger_.info("Failed to roll-back physical connection when closing really: " + this.physicalConnection_, (Throwable)e);
                    }
                }
                this.physicalConnection_.close();
            }
            catch (SQLException e) {
                logger_.info("Failed to close physical connection when closing really: " + this.physicalConnection_, (Throwable)e);
            }
            finally {
                this.physicalConnection_ = null;
            }
        }
        try {
            this.xaConnection_.close();
            logger_.debug("Closed the physical connection: " + this.xaConnection_);
        }
        catch (SQLException e) {
            logger_.info("Failed to close XA connection when closing really: " + this.xaConnection_, (Throwable)e);
        }
        finally {
            this.xaConnection_ = null;
        }
    }

    private void assertOpened() throws SQLException {
        if (this.closed_) {
            throw new LjtSQLException("Already closed the connection: " + this.xaConnection_);
        }
    }

    private void assertLocalTx() throws SQLException {
        if (this.tx_ != null) {
            throw new LjtSQLException("Cannot use when distributed transaction: " + this.tx_);
        }
    }

    @Override
    public void release() throws SQLException {
        if (!this.closed_) {
            this.connectionPool_.release(this);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            this.release();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.nativeSQL(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getMetaData();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed_) {
            return;
        }
        if (this.tx_ == null) {
            this.connectionPool_.checkIn(this);
        } else {
            this.connectionPool_.checkInTx(this.tx_);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.commit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.rollback();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertOpened();
        if (autoCommit) {
            this.assertLocalTx();
        }
        try {
            this.physicalConnection_.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setHoldability(holdability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            return this.physicalConnection_.setSavepoint(name);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, autoGeneratedKeys), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, columnIndexes), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, columnNames), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    private SQLException wrapException(SQLException e, String sql) {
        return new LjtSQLException("Failed to execute the SQL: " + sql, e);
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public Object unwrap(Class iface) throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }
}

