/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.core.aop.interceptors.AbstractInterceptor;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.exception.MethodNotFoundRuntimeException;
import org.lastaflute.di.helper.beans.factory.BeanDescFactory;
import org.lastaflute.di.util.LdiMethodUtil;

public class DelegateInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 3613140488663554089L;
    private Object target;
    private BeanDesc beanDesc;
    private Map methodNameMap = new HashMap();

    public DelegateInterceptor() {
    }

    public DelegateInterceptor(Object target) {
        this.setTarget(target);
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
        this.beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
    }

    public void addMethodNameMap(String methodName, String targetMethodName) {
        this.methodNameMap.put(methodName, targetMethodName);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.target == null) {
            throw new EmptyRuntimeException("target");
        }
        Method method = invocation.getMethod();
        String methodName = method.getName();
        if (this.methodNameMap.containsKey(methodName)) {
            methodName = (String)this.methodNameMap.get(methodName);
        }
        if (!LdiMethodUtil.isAbstract(method)) {
            return invocation.proceed();
        }
        if (this.beanDesc.hasMethod(methodName)) {
            return this.beanDesc.invoke(this.target, methodName, invocation.getArguments());
        }
        throw new MethodNotFoundRuntimeException(this.getTargetClass(invocation), methodName, invocation.getArguments());
    }
}

