/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression.engine;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.ExpressionClassCreateFailureException;
import org.lastaflute.di.core.expression.engine.ExpressionEngine;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class JavaScriptExpressionEngine
implements ExpressionEngine {
    protected static final String SQ = "'";
    protected static final String DQ = "\"";
    protected static final String CAST_INT_ARRAY = "(int[])";
    protected static final String CAST_STRING_ARRAY = "(String[])";
    protected static final String CAST_SET = "(Set)";
    protected static final ScriptEngineManager defaultManager = new ScriptEngineManager();

    @Override
    public Object parseExpression(String source) {
        return source.trim();
    }

    @Override
    public Object evaluate(Object exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> conversionType) {
        return this.viaVariableResolvedEvaluate((String)exp, contextMap, container, conversionType);
    }

    protected Object viaVariableResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> conversionType) {
        String filteredExp = exp;
        for (Map.Entry<String, ? extends Object> entry : contextMap.entrySet()) {
            filteredExp = LdiStringUtil.replace(filteredExp, "#" + entry.getKey(), SQ + entry.getValue() + SQ);
        }
        return this.viaCastResolvedEvaluate(filteredExp, contextMap, container, conversionType);
    }

    protected Object viaCastResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> conversionType) {
        Class resolvedType;
        String filteredExp;
        if (exp.startsWith(CAST_INT_ARRAY)) {
            filteredExp = exp.substring(CAST_INT_ARRAY.length());
            resolvedType = int[].class;
        } else if (exp.startsWith(CAST_STRING_ARRAY)) {
            filteredExp = exp.substring(CAST_STRING_ARRAY.length());
            resolvedType = String[].class;
        } else if (exp.startsWith(CAST_SET)) {
            filteredExp = exp.substring(CAST_SET.length());
            resolvedType = Set.class;
        } else {
            filteredExp = exp;
            resolvedType = conversionType;
        }
        return this.viaFirstNameResolvedEvaluate(filteredExp, contextMap, container, resolvedType);
    }

    protected Object viaFirstNameResolvedEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> conversionType) {
        String filteredExp;
        String firstName = null;
        LaContainer firstComponent = null;
        if (!exp.startsWith(DQ) && exp.contains(".")) {
            String componentName = exp.substring(0, exp.indexOf("."));
            LaContainer namedContainer = container.getRoot().findChild(componentName);
            if (namedContainer != null) {
                String rear = exp.substring(exp.indexOf(".") + ".".length());
                if (rear.contains(".")) {
                    String nextName = rear.substring(0, rear.indexOf("."));
                    if (namedContainer.hasComponentDef(nextName)) {
                        filteredExp = rear;
                        firstName = nextName;
                        firstComponent = namedContainer.getComponent(nextName);
                    } else {
                        filteredExp = exp;
                        firstName = componentName;
                        firstComponent = namedContainer;
                    }
                } else {
                    if (namedContainer.hasComponentDef(rear)) {
                        return namedContainer.getComponent(rear);
                    }
                    filteredExp = exp;
                    firstName = componentName;
                    firstComponent = namedContainer;
                }
            } else {
                filteredExp = exp;
                if (container.hasComponentDef(componentName)) {
                    firstName = componentName;
                    firstComponent = (LaContainer)container.getComponent(componentName);
                }
            }
        } else {
            filteredExp = exp;
        }
        Object evaluated = this.actuallyEvaluate(filteredExp, contextMap, container, firstName, firstComponent);
        return this.filterEvaluated(filteredExp, contextMap, container, evaluated, conversionType);
    }

    protected Object actuallyEvaluate(String exp, Map<String, ? extends Object> contextMap, LaContainer container, String firstName, Object firstComponent) {
        ScriptEngine engine = this.prepareScriptEngineManager().getEngineByName("javascript");
        if (firstName != null) {
            engine.put(firstName, firstComponent);
        }
        try {
            return engine.eval(exp);
        }
        catch (RuntimeException | ScriptException e) {
            this.throwJavaScriptExpressionException(exp, contextMap, container, e);
            return null;
        }
    }

    protected ScriptEngineManager prepareScriptEngineManager() {
        return defaultManager;
    }

    protected void throwJavaScriptExpressionException(Object exp, Map<String, ? extends Object> contextMap, LaContainer container, Exception e) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to evaluate the JavaScript expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Context Map");
        br.addElement(contextMap);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    protected Object filterEvaluated(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Object evaluated, Class<?> conversionType) {
        if (evaluated instanceof String) {
            String str = ((String)evaluated).trim();
            String prefix = "new ";
            String suffix = "()";
            if (str.startsWith("new ") && str.endsWith("()")) {
                String className = str.substring("new ".length(), str.length() - "()".length());
                try {
                    return LdiClassUtil.newInstance(className);
                }
                catch (RuntimeException e) {
                    this.throwExpressionClassCreateFailureException(exp, contextMap, container, className, e);
                }
            }
        }
        if (evaluated instanceof Map) {
            Map map = (Map)evaluated;
            return this.handleMap(exp, contextMap, container, map, conversionType);
        }
        return evaluated;
    }

    protected void throwExpressionClassCreateFailureException(String exp, Map<String, ? extends Object> contextMap, LaContainer container, String className, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to create the class in the expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Context Map");
        br.addElement(contextMap);
        br.addItem("Class Name");
        br.addElement(className);
        String msg = br.buildExceptionMessage();
        throw new ExpressionClassCreateFailureException(msg, cause);
    }

    protected Object handleMap(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Map<String, Object> map, Class<?> conversionType) {
        List<Object> challengeList = this.challengeList(map);
        if (challengeList != null) {
            if (int[].class.isAssignableFrom(conversionType)) {
                int[] intAry = new int[challengeList.size()];
                int index = 0;
                try {
                    for (Object element : challengeList) {
                        if (element == null) {
                            throw new IllegalStateException("Cannot handle null element in array: index=" + index);
                        }
                        intAry[index] = Integer.parseInt(element.toString());
                        ++index;
                    }
                }
                catch (RuntimeException e) {
                    this.throwExpressionCannotConvertException(exp, contextMap, container, conversionType, index, e);
                }
                return intAry;
            }
            if (String[].class.isAssignableFrom(conversionType)) {
                String[] strAry = new String[challengeList.size()];
                int index = 0;
                try {
                    for (Object element : challengeList) {
                        if (element == null) {
                            throw new IllegalStateException("Cannot handle null element in array: index=" + index);
                        }
                        if (!(element instanceof String)) {
                            throw new IllegalStateException("Non-string element in array: index=" + index);
                        }
                        strAry[index] = (String)element;
                        ++index;
                    }
                }
                catch (RuntimeException e) {
                    this.throwExpressionCannotConvertException(exp, contextMap, container, conversionType, index, e);
                }
                return strAry;
            }
            if (Set.class.isAssignableFrom(conversionType)) {
                return new LinkedHashSet<Object>(challengeList);
            }
            return challengeList;
        }
        return map;
    }

    protected List<Object> challengeList(Map<String, Object> map) {
        int index = 0;
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            if (LdiStringUtil.isNumber(key) && Integer.parseInt(key) == index) {
                ++index;
                continue;
            }
            return null;
        }
        return new ArrayList<Object>(map.values());
    }

    protected void throwExpressionCannotConvertException(String exp, Map<String, ? extends Object> contextMap, LaContainer container, Class<?> conversionType, Integer index, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to convert the value to the type in the expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Context Map");
        br.addElement(contextMap);
        br.addItem("Conversion Type");
        br.addElement(conversionType);
        if (index != null) {
            br.addItem("Array Index");
            br.addElement(index);
        }
        String msg = br.buildExceptionMessage();
        throw new ExpressionClassCreateFailureException(msg, cause);
    }

    @Override
    public String resolveStaticMethodReference(Class<?> refType, String methodName) {
        return refType.getName() + "." + methodName;
    }
}

