/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.smart;

public enum SmartDeployMode {
    COOL("cool"),
    HOT("hot"),
    WARM("warm");

    private static SmartDeployMode value;
    private final String code;

    private SmartDeployMode(String code) {
        this.code = code;
    }

    public String code() {
        return this.code;
    }

    public static SmartDeployMode codeOf(String code) {
        if (code == null) {
            return COOL;
        }
        for (SmartDeployMode mode : SmartDeployMode.values()) {
            if (!mode.code().equalsIgnoreCase(code)) continue;
            return mode;
        }
        throw new IllegalStateException("Unknown code of smart deploy mode: " + code);
    }

    public static boolean isCool() {
        return COOL.equals((Object)value);
    }

    public static SmartDeployMode getValue() {
        return value != null ? value : COOL;
    }

    public static void setValue(SmartDeployMode newValue) {
        value = newValue;
    }

    public String toString() {
        return this.code;
    }
}

