/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.naming;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lastaflute.di.Disposable;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.core.LastaDiProperties;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.naming.NamingConvention;
import org.lastaflute.di.util.LdiArrayUtil;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiMapUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiResourcesUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class StyledNamingConvention
implements NamingConvention,
Disposable {
    protected static final char PACKAGE_SEPARATOR = '_';
    protected static final String PACKAGE_SEPARATOR_STR = "_";
    protected boolean initialized;
    protected String actionSuffix = "Action";
    protected String formSuffix = "Form";
    protected String serviceSuffix = "Service";
    protected String logicSuffix = "Logic";
    protected String assistSuffix = "Assist";
    protected String helperSuffix = "Helper";
    protected String interceptorSuffix = "Interceptor";
    protected String validatorSuffix = "Validator";
    protected String converterSuffix = "Converter";
    protected String implementationSuffix = "Impl";
    protected String viewRootPath = "/view";
    protected String viewExtension = ".html";
    protected String[] rootPackageNames = new String[0];
    protected String subApplicationRootPackageName = "web";
    protected String[] ignorePackageNames = new String[0];
    protected final Set<String> hotdeployRootPackageNames = new HashSet<String>(4);
    protected final Map<String, LdiResourcesUtil.Resources[]> existCheckerArrays = LdiMapUtil.createHashMap();
    protected final Map<String, String> interfaceToImplementationMap = new HashMap<String, String>(4);
    protected final Map<String, String> implementationToInterfaceMap = new HashMap<String, String>(4);

    public StyledNamingConvention() {
        this.initialize();
        this.setupPropertiesSmartPackage();
    }

    protected void setupPropertiesSmartPackage() {
        LastaDiProperties.getInstance().getSmartPackageList().forEach(pkg -> this.addRootPackageName((String)pkg));
    }

    public void initialize() {
        if (!this.initialized) {
            for (int i = 0; i < this.rootPackageNames.length; ++i) {
                this.addExistChecker(this.rootPackageNames[i]);
            }
            DisposableUtil.add(this);
            this.initialized = true;
        }
    }

    public void addRootPackageName(String rootPackageName) {
        this.addRootPackageName(rootPackageName, true);
    }

    public void addRootPackageName(String rootPackageName, boolean hotdeploy) {
        this.rootPackageNames = (String[])LdiArrayUtil.add((Object[])this.rootPackageNames, rootPackageName);
        if (hotdeploy) {
            this.hotdeployRootPackageNames.add(rootPackageName);
        }
        this.addExistChecker(rootPackageName);
    }

    public void addIgnorePackageName(String ignorePackageName) {
        this.ignorePackageNames = (String[])LdiArrayUtil.add((Object[])this.ignorePackageNames, ignorePackageName);
    }

    public void addInterfaceToImplementationClassName(String interfaceName, String implementationClassName) {
        this.interfaceToImplementationMap.put(interfaceName, implementationClassName);
        this.implementationToInterfaceMap.put(implementationClassName, interfaceName);
    }

    @Override
    public boolean isTargetClassName(String className, String suffix) {
        if (this.isIgnoreClassName(className)) {
            return false;
        }
        if (!LdiStringUtil.trimSuffix(className, this.implementationSuffix).endsWith(suffix)) {
            return false;
        }
        String shortClassName = LdiClassUtil.getShortClassName(className);
        if (className.endsWith(this.implementationSuffix) && !className.endsWith("." + this.getImplementationPackageName() + "." + shortClassName)) {
            return false;
        }
        String middlePkgName = this.fromSuffixToPackageName(suffix);
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (className.startsWith(this.rootPackageNames[i] + "." + middlePkgName + ".")) {
                return true;
            }
            if (!className.startsWith(this.rootPackageNames[i] + "." + this.subApplicationRootPackageName + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTargetClassName(String className) {
        if (this.isIgnoreClassName(className)) {
            return false;
        }
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (!className.startsWith(this.rootPackageNames[i] + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHotdeployTargetClassName(String className) {
        if (this.isIgnoreClassName(className)) {
            return false;
        }
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (!className.startsWith(this.rootPackageNames[i] + ".")) continue;
            return this.hotdeployRootPackageNames.contains(this.rootPackageNames[i]);
        }
        return false;
    }

    @Override
    public boolean isIgnoreClassName(String className) {
        for (int i = 0; i < this.ignorePackageNames.length; ++i) {
            if (!className.startsWith(this.ignorePackageNames[i] + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String fromSuffixToPackageName(String suffix) {
        if (LdiStringUtil.isEmpty(suffix)) {
            throw new EmptyRuntimeException("suffix");
        }
        return suffix.toLowerCase();
    }

    @Override
    public String fromClassNameToShortComponentName(String className) {
        if (LdiStringUtil.isEmpty(className)) {
            throw new EmptyRuntimeException("className");
        }
        String s = LdiStringUtil.decapitalize(LdiClassUtil.getShortClassName(className));
        if (s.endsWith(this.implementationSuffix)) {
            return s.substring(0, s.length() - this.implementationSuffix.length());
        }
        return s;
    }

    @Override
    public String fromClassNameToComponentName(String className) {
        String prefix;
        int i;
        if (LdiStringUtil.isEmpty(className)) {
            throw new EmptyRuntimeException("className");
        }
        String cname = this.toInterfaceClassName(className);
        String suffix = this.fromClassNameToSuffix(cname);
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        String name = null;
        for (i = 0; i < this.rootPackageNames.length; ++i) {
            prefix = this.rootPackageNames[i] + "." + middlePackageName + ".";
            if (!cname.startsWith(prefix)) continue;
            name = cname.substring(prefix.length());
        }
        if (LdiStringUtil.isEmpty(name)) {
            for (i = 0; i < this.rootPackageNames.length; ++i) {
                prefix = this.rootPackageNames[i] + "." + this.subApplicationRootPackageName + ".";
                if (!cname.startsWith(prefix)) continue;
                name = cname.substring(prefix.length());
            }
            if (LdiStringUtil.isEmpty(name)) {
                return this.fromClassNameToShortComponentName(className);
            }
        }
        String[] array = LdiStringUtil.split(name, ".");
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 == array.length - 1) {
                buf.append(LdiStringUtil.decapitalize(array[i2]));
                continue;
            }
            buf.append(array[i2]);
            buf.append('_');
        }
        return buf.toString();
    }

    @Override
    public Class<?> fromComponentNameToClass(String componentName) {
        if (LdiStringUtil.isEmpty(componentName)) {
            throw new EmptyRuntimeException("componentName");
        }
        String suffix = this.fromComponentNameToSuffix(componentName);
        if (suffix == null) {
            return null;
        }
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        String partOfClassName = this.fromComponentNameToPartOfClassName(componentName);
        boolean subAppSuffix = this.isSubApplicationSuffix(suffix);
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            Class<?> clazz;
            String rootPackageName = this.rootPackageNames[i];
            if (subAppSuffix) {
                clazz = this.findClass(rootPackageName, this.subApplicationRootPackageName, partOfClassName);
                if (clazz != null) {
                    return clazz;
                }
                clazz = this.findClass(rootPackageName, middlePackageName, partOfClassName);
                if (clazz == null) continue;
                return clazz;
            }
            clazz = this.findClass(rootPackageName, middlePackageName, partOfClassName);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findClass(rootPackageName, this.subApplicationRootPackageName, partOfClassName);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    protected boolean isSubApplicationSuffix(String suffix) {
        if (this.actionSuffix.equals(suffix)) {
            return true;
        }
        return this.serviceSuffix.equals(suffix);
    }

    protected Class<?> findClass(String rootPackageName, String middlePackageName, String partOfClassName) {
        this.initialize();
        String backPartOfClassName = LdiClassUtil.concatName(middlePackageName, partOfClassName);
        String className = LdiClassUtil.concatName(rootPackageName, backPartOfClassName);
        String backPartOfImplClassName = this.toImplementationClassName(backPartOfClassName);
        String implClassName = LdiClassUtil.concatName(rootPackageName, backPartOfImplClassName);
        if (!this.isIgnoreClassName(implClassName) && this.isExist(rootPackageName, backPartOfImplClassName)) {
            return LdiClassUtil.forName(implClassName);
        }
        if (!this.isIgnoreClassName(className) && this.isExist(rootPackageName, backPartOfClassName)) {
            return LdiClassUtil.forName(className);
        }
        return null;
    }

    @Override
    public String fromComponentNameToSuffix(String componentName) {
        return this.fromNameToSuffix(componentName);
    }

    @Override
    public String fromClassNameToSuffix(String componentName) {
        return this.fromNameToSuffix(componentName);
    }

    @Override
    public String fromComponentNameToPartOfClassName(String componentName) {
        if (componentName == null) {
            throw new EmptyRuntimeException("componentName");
        }
        String[] names = LdiStringUtil.split(componentName, PACKAGE_SEPARATOR_STR);
        StringBuffer buf = new StringBuffer(50);
        for (int i = 0; i < names.length; ++i) {
            if (i == names.length - 1) {
                buf.append(LdiStringUtil.capitalize(names[i]));
                continue;
            }
            buf.append(names[i]).append(".");
        }
        return buf.toString();
    }

    protected String fromNameToSuffix(String name) {
        if (LdiStringUtil.isEmpty(name)) {
            throw new EmptyRuntimeException("name");
        }
        for (int i = name.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            return name.substring(i);
        }
        return null;
    }

    protected String fromPathToComponentName(String path, String nameSuffix) {
        if (!path.startsWith(this.viewRootPath) || !path.endsWith(this.viewExtension)) {
            throw new IllegalArgumentException(path);
        }
        String componentName = (path.substring(this.adjustViewRootPath().length() + 1, path.length() - this.viewExtension.length()) + nameSuffix).replace('/', '_');
        int pos = componentName.lastIndexOf(95);
        if (pos == -1) {
            return LdiStringUtil.decapitalize(componentName);
        }
        return componentName.substring(0, pos + 1) + LdiStringUtil.decapitalize(componentName.substring(pos + 1));
    }

    @Override
    public String fromPathToActionName(String path) {
        return this.fromPathToComponentName(path, this.actionSuffix);
    }

    @Override
    public String fromActionNameToPath(String actionName) {
        if (!actionName.endsWith(this.actionSuffix)) {
            throw new IllegalArgumentException(actionName);
        }
        String name = actionName.substring(0, actionName.length() - this.actionSuffix.length());
        return this.adjustViewRootPath() + "/" + name.replace('_', '/') + this.viewExtension;
    }

    @Override
    public String toImplementationClassName(String className) {
        String implementationClassName = this.interfaceToImplementationMap.get(className);
        if (implementationClassName != null) {
            return implementationClassName;
        }
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return this.getImplementationPackageName() + "." + className + this.implementationSuffix;
        }
        return className.substring(0, index) + "." + this.getImplementationPackageName() + "." + className.substring(index + 1) + this.implementationSuffix;
    }

    @Override
    public String toInterfaceClassName(String className) {
        String interfaceClassName = this.implementationToInterfaceMap.get(className);
        if (interfaceClassName != null) {
            return interfaceClassName;
        }
        if (!className.endsWith(this.implementationSuffix)) {
            return className;
        }
        String key = "." + this.getImplementationPackageName() + ".";
        int index = className.lastIndexOf(key);
        if (index < 0) {
            throw new IllegalArgumentException(className);
        }
        return className.substring(0, index) + "." + className.substring(index + key.length(), className.length() - this.implementationSuffix.length());
    }

    @Override
    public boolean isSkipClass(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.interfaceToImplementationMap.entrySet()) {
            Class interfaceClass = LdiClassUtil.forName(entry.getKey());
            if (!interfaceClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> toCompleteClass(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return clazz;
        }
        String className = this.toImplementationClassName(clazz.getName());
        if (LdiResourceUtil.isExist(LdiClassUtil.getResourcePath(className))) {
            return LdiClassUtil.forName(className);
        }
        return clazz;
    }

    protected boolean isExist(String rootPackageName, String lastClassName) {
        LdiResourcesUtil.Resources[] checkerArray = this.getExistCheckerArray(rootPackageName);
        for (int i = 0; i < checkerArray.length; ++i) {
            if (!checkerArray[i].isExistClass(lastClassName)) continue;
            return true;
        }
        return false;
    }

    protected LdiResourcesUtil.Resources[] getExistCheckerArray(String rootPackageName) {
        return this.existCheckerArrays.get(rootPackageName);
    }

    protected void addExistChecker(String rootPackageName) {
        LdiResourcesUtil.Resources[] checkerArray = LdiResourcesUtil.getResourcesTypes(rootPackageName);
        this.existCheckerArrays.put(rootPackageName, checkerArray);
    }

    @Override
    public void dispose() {
        for (LdiResourcesUtil.Resources[] array : this.existCheckerArrays.values()) {
            for (int i = 0; i < array.length; ++i) {
                array[i].close();
            }
        }
        this.existCheckerArrays.clear();
        this.initialized = false;
    }

    @Override
    public String getActionSuffix() {
        return this.actionSuffix;
    }

    public void setActionSuffix(String actionSuffix) {
        this.actionSuffix = actionSuffix;
    }

    @Override
    public String getFormSuffix() {
        return this.formSuffix;
    }

    public void setFormSuffix(String formSuffix) {
        this.formSuffix = formSuffix;
    }

    @Override
    public String getAssistSuffix() {
        return this.assistSuffix;
    }

    public void setAssistSuffix(String assistSuffix) {
        this.assistSuffix = assistSuffix;
    }

    @Override
    public String getHelperSuffix() {
        return this.helperSuffix;
    }

    public void setHelperSuffix(String helperSuffix) {
        this.helperSuffix = helperSuffix;
    }

    @Override
    public String getInterceptorSuffix() {
        return this.interceptorSuffix;
    }

    public void setInterceptorSuffix(String interceptorSuffix) {
        this.interceptorSuffix = interceptorSuffix;
    }

    @Override
    public String getLogicSuffix() {
        return this.logicSuffix;
    }

    public void setLogicSuffix(String logicSuffix) {
        this.logicSuffix = logicSuffix;
    }

    @Override
    public String getServiceSuffix() {
        return this.serviceSuffix;
    }

    public void setServiceSuffix(String serviceSuffix) {
        this.serviceSuffix = serviceSuffix;
    }

    @Override
    public String getValidatorSuffix() {
        return this.validatorSuffix;
    }

    public void setValidatorSuffix(String validatorSuffix) {
        this.validatorSuffix = validatorSuffix;
    }

    @Override
    public String getConverterSuffix() {
        return this.converterSuffix;
    }

    public void setConverterSuffix(String converterSuffix) {
        this.converterSuffix = converterSuffix;
    }

    @Override
    public String getImplementationSuffix() {
        return this.implementationSuffix;
    }

    public void setImplementationSuffix(String implementationSuffix) {
        this.implementationSuffix = implementationSuffix;
    }

    @Override
    public String getLogicPackageName() {
        return this.fromSuffixToPackageName(this.logicSuffix);
    }

    @Override
    public String getHelperPackageName() {
        return this.fromSuffixToPackageName(this.helperSuffix);
    }

    @Override
    public String getInterceptorPackageName() {
        return this.fromSuffixToPackageName(this.interceptorSuffix);
    }

    @Override
    public String getServicePackageName() {
        return this.fromSuffixToPackageName(this.serviceSuffix);
    }

    @Override
    public String getValidatorPackageName() {
        return this.fromSuffixToPackageName(this.validatorSuffix);
    }

    @Override
    public String getConverterPackageName() {
        return this.fromSuffixToPackageName(this.converterSuffix);
    }

    @Override
    public String getImplementationPackageName() {
        return this.fromSuffixToPackageName(this.implementationSuffix);
    }

    @Override
    public String getViewExtension() {
        return this.viewExtension;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension = viewExtension;
    }

    @Override
    public String getViewRootPath() {
        return this.viewRootPath;
    }

    public void setViewRootPath(String viewRootPath) {
        this.viewRootPath = viewRootPath;
    }

    @Override
    public String adjustViewRootPath() {
        return "/".equals(this.viewRootPath) ? "" : this.viewRootPath;
    }

    @Override
    public String[] getRootPackageNames() {
        return this.rootPackageNames;
    }

    @Override
    public String[] getIgnorePackageNames() {
        return this.ignorePackageNames;
    }

    @Override
    public String getSubApplicationRootPackageName() {
        return this.subApplicationRootPackageName;
    }

    public void setSubApplicationRootPackageName(String subApplicationRootPackageName) {
        this.subApplicationRootPackageName = subApplicationRootPackageName;
    }
}

