/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.tx;

import java.util.List;
import org.lastaflute.di.core.aop.frame.MethodInvocation;
import org.lastaflute.di.tx.TransactionCallback;
import org.lastaflute.di.tx.TransactionManagerAdapter;
import org.lastaflute.di.tx.TxRule;

public class DefaultTransactionCallback
implements TransactionCallback {
    protected final MethodInvocation methodInvocation;
    protected final List<TxRule> txRules;

    public DefaultTransactionCallback(MethodInvocation methodInvocation, List<TxRule> txRules) {
        this.methodInvocation = methodInvocation;
        this.txRules = txRules;
    }

    @Override
    public Object execute(TransactionManagerAdapter adapter) throws Throwable {
        try {
            return this.methodInvocation.proceed();
        }
        catch (Throwable t) {
            this.applyTxRule(adapter, t);
            throw t;
        }
    }

    protected void applyTxRule(TransactionManagerAdapter adapter, Throwable cause) {
        for (int i = 0; i < this.txRules.size(); ++i) {
            TxRule rule = this.txRules.get(i);
            if (!rule.isAssignableFrom(cause)) continue;
            rule.complete(adapter);
            return;
        }
        adapter.setRollbackOnly();
    }
}

