/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.lastaflute.jta.core.SynchronizationRegister;
import org.lastaflute.jta.exception.LjtIllegalStateException;
import org.lastaflute.jta.util.LjtTransactionManagerUtil;
import org.lastaflute.jta.util.LjtTransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    private static final Logger logger = LoggerFactory.getLogger(TransactionSynchronizationRegistryImpl.class);
    private TransactionManager tm;
    private final Map<Transaction, SynchronizationRegisterImpl> transactionContexts = Collections.synchronizedMap(new HashMap());

    public TransactionSynchronizationRegistryImpl() {
    }

    public TransactionSynchronizationRegistryImpl(TransactionManager tm) {
        this.tm = tm;
    }

    public void putResource(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.assertActive();
        this.getContext().putResource(key, value);
    }

    public Object getResource(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.assertActive();
        return this.getContext().getResource(key);
    }

    public void setRollbackOnly() {
        this.assertActive();
        LjtTransactionManagerUtil.setRollbackOnly(this.tm);
    }

    public boolean getRollbackOnly() {
        this.assertActive();
        switch (this.getTransactionStatus()) {
            case 1: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public Object getTransactionKey() {
        if (!this.isActive()) {
            return null;
        }
        return this.getTransaction();
    }

    public int getTransactionStatus() {
        return LjtTransactionManagerUtil.getStatus(this.tm);
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        this.assertActive();
        this.getContext().registerInterposedSynchronization(sync);
    }

    protected Transaction getTransaction() {
        return LjtTransactionManagerUtil.getTransaction(this.tm);
    }

    protected void assertActive() throws IllegalStateException {
        if (!this.isActive()) {
            throw new LjtIllegalStateException("Not begun transaction: transaction=" + this.tm);
        }
    }

    protected boolean isActive() {
        return LjtTransactionManagerUtil.isActive(this.tm);
    }

    protected SynchronizationRegister getContext() {
        Transaction tx = this.getTransaction();
        if (tx instanceof SynchronizationRegister) {
            return (SynchronizationRegister)tx;
        }
        SynchronizationRegisterImpl context = this.transactionContexts.get(tx);
        if (context == null) {
            context = new SynchronizationRegisterImpl(tx);
            LjtTransactionUtil.registerSynchronization(tx, context);
            this.transactionContexts.put(tx, context);
        }
        return context;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public class SynchronizationRegisterImpl
    implements SynchronizationRegister,
    Synchronization {
        private final Transaction tx;
        private final List interposedSynchronizations = new ArrayList();
        private final Map resourceMap = new HashMap();

        public SynchronizationRegisterImpl(Transaction tx) {
            this.tx = tx;
        }

        @Override
        public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
            this.interposedSynchronizations.add(sync);
        }

        @Override
        public void putResource(Object key, Object value) throws IllegalStateException {
            this.resourceMap.put(key, value);
        }

        @Override
        public Object getResource(Object key) throws IllegalStateException {
            return this.resourceMap.get(key);
        }

        public void beforeCompletion() {
            for (int i = 0; i < this.interposedSynchronizations.size(); ++i) {
                Synchronization sync = (Synchronization)this.interposedSynchronizations.get(i);
                sync.beforeCompletion();
            }
        }

        public void afterCompletion(int status) {
            for (int i = 0; i < this.interposedSynchronizations.size(); ++i) {
                Synchronization sync = (Synchronization)this.interposedSynchronizations.get(i);
                try {
                    sync.afterCompletion(status);
                    continue;
                }
                catch (Throwable t) {
                    logger.info("Failed to process the after completion: " + sync + " " + status, t);
                }
            }
            TransactionSynchronizationRegistryImpl.this.transactionContexts.remove(this.tx);
        }
    }
}

