/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.core.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.lastaflute.jta.core.xa.XAResourceStatus;
import org.lastaflute.jta.exception.LjtXAException;

public abstract class AbstractXAResource
implements XAResource,
XAResourceStatus {
    private Xid currentXid;
    private int status = 0;
    private int timeout = 0;

    @Override
    public void start(Xid xid, int flags) throws XAException {
        switch (flags) {
            case 0: {
                this.begin(xid);
                break;
            }
            case 0x8000000: {
                this.resume(xid);
                break;
            }
            default: {
                throw new LjtXAException("Unexpected flags: " + flags);
            }
        }
    }

    private void begin(Xid xid) throws XAException {
        this.assertCurrentXidNull();
        this.doBegin(xid);
        this.currentXid = xid;
        this.status = 1;
    }

    private void assertCurrentXidNull() throws XAException {
        if (this.currentXid != null) {
            throw new LjtXAException("Unsupported nested transaction: currentXid=" + this.currentXid);
        }
    }

    protected abstract void doBegin(Xid var1) throws XAException;

    private void resume(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusSuspended();
        this.doResume(xid);
        this.status = 1;
    }

    private void assertCurrentXidSame(Xid xid) throws XAException {
        if (this.currentXid != xid) {
            throw new LjtXAException("Not matched the current and specified xid: current=" + this.currentXid + " specified=" + xid);
        }
    }

    private void assertStatusSuspended() throws XAException {
        if (this.status != 2) {
            throw new LjtXAException("The status should be suspended but: " + this.status);
        }
    }

    protected abstract void doResume(Xid var1) throws XAException;

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusActive();
        switch (flags) {
            case 0x2000000: {
                this.suspend(xid);
                break;
            }
            case 0x20000000: {
                this.fail(xid);
                break;
            }
            case 0x4000000: {
                this.success(xid);
                break;
            }
            default: {
                throw new LjtXAException("Unexpected the flags: " + flags + " xid=" + xid);
            }
        }
    }

    private void assertStatusActive() throws XAException {
        if (this.status != 1) {
            throw new LjtXAException("The status should be active: status=" + this.status);
        }
    }

    private void suspend(Xid xid) throws XAException {
        this.doSuspend(xid);
        this.status = 2;
    }

    protected abstract void doSuspend(Xid var1) throws XAException;

    private void fail(Xid xid) throws XAException {
        this.doFail(xid);
        this.status = 3;
    }

    protected abstract void doFail(Xid var1) throws XAException;

    private void success(Xid xid) throws XAException {
        this.doSuccess(xid);
        this.status = 4;
    }

    protected abstract void doSuccess(Xid var1) throws XAException;

    @Override
    public int prepare(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusSuccess();
        int ret = this.doPrepare(xid);
        this.status = ret == 0 ? 5 : 0;
        return ret;
    }

    private void assertStatusSuccess() throws XAException {
        if (this.status != 4) {
            throw new LjtXAException("The status should be success: " + this.status);
        }
    }

    protected abstract int doPrepare(Xid var1) throws XAException;

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.assertCurrentXidSame(xid);
        if (onePhase) {
            this.assertStatusSuccess();
        } else {
            this.assertStatusPrepared();
        }
        this.doCommit(xid, onePhase);
        this.init();
    }

    private void assertStatusPrepared() throws XAException {
        if (this.status != 5) {
            throw new LjtXAException("The status should be prepared: " + this.status);
        }
    }

    protected abstract void doCommit(Xid var1, boolean var2) throws XAException;

    private void init() {
        this.currentXid = null;
        this.status = 0;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.doForget(xid);
        this.init();
    }

    protected abstract void doForget(Xid var1) throws XAException;

    @Override
    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusSuccessOrFailOrPrepared();
        this.doRollback(xid);
        this.init();
    }

    private void assertStatusSuccessOrFailOrPrepared() throws XAException {
        switch (this.status) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new LjtXAException("The status should be success or fail or prepared: " + this.status);
            }
        }
    }

    protected abstract void doRollback(Xid var1) throws XAException;

    @Override
    public boolean isSameRM(XAResource xar) throws XAException {
        return false;
    }

    public String toString() {
        return "xaResource:{" + this.currentXid + ", status=" + this.status + "}";
    }

    public Xid getCurrentXid() {
        return this.currentXid;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }
}

